/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.kernel;

import ghidra.app.util.bin.ByteProvider;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileImpl;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.GFileSystemBase;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.factory.GFileSystemBaseFactory;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.CryptoException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@FileSystemInfo(type="androidkernel", description="Android Compressed Kernel", factory=GFileSystemBaseFactory.class)
public class KernelFileSystem
extends GFileSystemBase {
    private static final int INDEX_WHERE_TO_START = 8192;
    private GFile compressedKernelFile = null;
    private long compressedKernelIndex;
    private long compressedKernelLength;

    public KernelFileSystem(String fileSystemName, ByteProvider provider) {
        super(fileSystemName, provider);
    }

    public boolean isValid(TaskMonitor monitor) throws IOException {
        byte[] bytes = this.provider.readBytes(0L, 32L);
        for (int i = 0; i < bytes.length; i += 4) {
            if (bytes[i] == 0 && bytes[i + 1] == 0 && bytes[i + 2] == -96 && bytes[i + 3] == -31) continue;
            return false;
        }
        return true;
    }

    public void open(TaskMonitor monitor) throws IOException, CryptoException, CancelledException {
        String message = "uncompression error";
        int index = 8192;
        monitor.setMaximum(this.provider.length());
        while ((long)index < this.provider.length() - (long)"uncompression error".length() + 1L) {
            monitor.checkCanceled();
            monitor.setProgress((long)index);
            String actualMessage = new String(this.provider.readBytes((long)index, (long)"uncompression error".length()));
            if ("uncompression error".equals(actualMessage)) {
                this.compressedKernelIndex = ((long)index & 0xFFFFFFFFL) + ((long)"uncompression error".length() & 0xFFFFFFFFL) + 1L;
                this.compressedKernelLength = this.provider.length() - this.compressedKernelIndex;
                this.compressedKernelFile = GFileImpl.fromFilename((GFileSystem)this, (GFile)this.root, (String)"compressed-kernel", (boolean)false, (long)this.compressedKernelLength, null);
                break;
            }
            ++index;
        }
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        return (directory == null || directory.equals(this.root)) && this.compressedKernelFile != null ? Arrays.asList(this.compressedKernelFile) : Collections.emptyList();
    }

    public String getInfo(GFile file, TaskMonitor monitor) throws IOException {
        return null;
    }

    protected InputStream getData(GFile file, TaskMonitor monitor) throws IOException, CancelledException, CryptoException {
        if (this.compressedKernelFile != null) {
            return this.provider.getInputStream(this.compressedKernelIndex);
        }
        return null;
    }
}

