/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table;

import docking.widgets.table.GTableCellRenderingData;
import ghidra.docking.settings.Settings;
import ghidra.util.Msg;
import ghidra.util.table.PreviewTableCellData;
import ghidra.util.table.column.AbstractGColumnRenderer;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;

public class PreviewDataTableCellRenderer
extends AbstractGColumnRenderer<PreviewTableCellData> {
    private static final Color DEFAULT_OFFCUT_FOREGROUND_COLOR = Color.RED;
    private static final Color DEFAULT_SELECTED_OFFCUT_FOREGROUND_COLOR = Color.PINK;

    public Component getTableCellRendererComponent(GTableCellRenderingData data) {
        JLabel renderer = (JLabel)super.getTableCellRendererComponent(data);
        Object value = data.getValue();
        JTable table = data.getTable();
        boolean isSelected = data.isSelected();
        if (value != null && !(value instanceof PreviewTableCellData)) {
            Msg.error((Object)((Object)this), (Object)("Renderer is not being used on " + PreviewTableCellData.class.getSimpleName()));
            return renderer;
        }
        PreviewTableCellData previewData = (PreviewTableCellData)value;
        String preview = previewData.getDisplayString();
        boolean isOffcut = previewData.isOffcut();
        String tooltipText = previewData.getHTMLDisplayString();
        Color foreground = this.getForeground(table, isSelected, isOffcut);
        renderer.setText(preview);
        renderer.setFont(this.getFixedWidthFont());
        renderer.setForeground(foreground);
        renderer.setToolTipText(tooltipText);
        return renderer;
    }

    private Color getForeground(JTable table, boolean isSelected, boolean isOffcut) {
        if (!isOffcut) {
            return this.getForeground();
        }
        boolean isFocused = table.hasFocus();
        if (!isFocused) {
            return DEFAULT_OFFCUT_FOREGROUND_COLOR;
        }
        return isSelected ? DEFAULT_SELECTED_OFFCUT_FOREGROUND_COLOR : DEFAULT_OFFCUT_FOREGROUND_COLOR;
    }

    public String getFilterString(PreviewTableCellData t, Settings settings) {
        return t.getDisplayString();
    }
}

