/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.fsbrowser.tasks;

import ghidra.app.services.ProgramManager;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.GFileSystemProgramProvider;
import ghidra.formats.gfilesystem.RefdFile;
import ghidra.framework.main.AppInfo;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.ProjectDataUtils;
import ghidra.framework.plugintool.Plugin;
import ghidra.plugin.importer.ImporterUtilities;
import ghidra.plugin.importer.ProgramMappingService;
import ghidra.program.model.lang.LanguageService;
import ghidra.program.model.listing.Program;
import ghidra.program.util.DefaultLanguageService;
import ghidra.program.util.GhidraProgramUtilities;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.List;

public class GFileSystemLoadKernelTask
extends Task {
    private List<FSRL> fileList;
    private ProgramManager programManager;

    public GFileSystemLoadKernelTask(Plugin plugin, ProgramManager programManager, List<FSRL> fileList) {
        super("Loading iOS kernel...", true, true, true);
        this.programManager = programManager;
        this.fileList = fileList;
    }

    public void run(TaskMonitor monitor) {
        if (this.fileList.isEmpty()) {
            Msg.showWarn((Object)((Object)this), null, (String)"Load Kernel Task Error", (Object)"Nothing to do");
            return;
        }
        if (!FSUtilities.isSameFS(this.fileList)) {
            Msg.showError((Object)((Object)this), null, (String)"Load Kernel Task Error", (Object)"The list of files to import must be from the same filesystem");
            return;
        }
        FSRL firstFSRL = this.fileList.get(0);
        try (RefdFile firstFile = FileSystemService.getInstance().getRefdFile(firstFSRL, monitor);){
            GFileSystem fs = firstFile.fsRef.getFilesystem();
            String containerName = fs.getFSRL().getContainer().getName();
            monitor.setMessage("Loading iOS Kernel from " + containerName + "...");
            for (FSRL fsrl : this.fileList) {
                if (monitor.isCancelled()) {
                    break;
                }
                GFile file = firstFile.fsRef.getFilesystem().lookup(fsrl.getPath());
                this.process(file, monitor);
            }
        }
        catch (CancelledException | IOException | UnsupportedOperationException e) {
            Msg.showError((Object)((Object)this), null, (String)"Error extracting file", (Object)e.getMessage(), (Throwable)e);
        }
    }

    private void process(GFile file, TaskMonitor monitor) throws IOException {
        if (this.isSpecialDirectory(file)) {
            return;
        }
        if (file.isDirectory() && !((GFileSystemProgramProvider)((Object)file.getFilesystem())).canProvideProgram(file)) {
            List<GFile> listing = file.getFilesystem().getListing(file);
            for (GFile child : listing) {
                if (!monitor.isCancelled()) {
                    this.process(child, monitor);
                    continue;
                }
                break;
            }
        } else {
            try {
                this.loadKext(file, monitor);
            }
            catch (Exception e) {
                Msg.warn((Object)((Object)this), (Object)("unable to load kext file: " + file.getName()), (Throwable)e);
            }
        }
    }

    private boolean isSpecialDirectory(GFile directory2) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadKext(GFile file, TaskMonitor monitor) throws Exception {
        if (file.getLength() == 0L) {
            return;
        }
        if (!file.getName().endsWith(".kext")) {
            return;
        }
        monitor.setMessage("Opening " + file.getName());
        Program program = ProgramMappingService.findMatchingProgramOpenIfNeeded(file.getFSRL(), (Object)this, this.programManager, 2);
        if (program != null) {
            program.release((Object)this);
            return;
        }
        if (file.getFilesystem() instanceof GFileSystemProgramProvider) {
            LanguageService languageService = DefaultLanguageService.getLanguageService();
            GFileSystemProgramProvider fileSystem = (GFileSystemProgramProvider)((Object)file.getFilesystem());
            program = fileSystem.getProgram(file, languageService, monitor, (Object)this);
        }
        if (program != null) {
            try {
                DomainFolder folder = ProjectDataUtils.createDomainFolderPath((DomainFolder)AppInfo.getActiveProject().getProjectData().getRootFolder(), (String)file.getParentFile().getPath());
                String fileName = ProjectDataUtils.getUniqueName((DomainFolder)folder, (String)program.getName());
                GhidraProgramUtilities.setAnalyzedFlag(program, true);
                ImporterUtilities.setProgramProperties(program, file.getFSRL(), monitor);
                folder.createFile(fileName, (DomainObject)program, monitor);
                this.programManager.openProgram(program);
                ProgramMappingService.createAssociation(file.getFSRL(), program);
            }
            finally {
                program.release((Object)this);
            }
        }
    }
}

