/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.action.DockingActionIf;
import docking.event.mouse.GMouseListenerAdapter;
import docking.widgets.tree.support.GTreeSelectionEvent;
import docking.widgets.tree.support.GTreeSelectionListener;
import ghidra.framework.main.AppInfo;
import ghidra.framework.main.datatree.ClearCutAction;
import ghidra.framework.main.datatree.ProjectDataTreePanel;
import ghidra.framework.main.projectdata.actions.ProjectDataCollapseAction;
import ghidra.framework.main.projectdata.actions.ProjectDataCopyAction;
import ghidra.framework.main.projectdata.actions.ProjectDataCutAction;
import ghidra.framework.main.projectdata.actions.ProjectDataDeleteAction;
import ghidra.framework.main.projectdata.actions.ProjectDataExpandAction;
import ghidra.framework.main.projectdata.actions.ProjectDataNewFolderAction;
import ghidra.framework.main.projectdata.actions.ProjectDataOpenDefaultToolAction;
import ghidra.framework.main.projectdata.actions.ProjectDataPasteAction;
import ghidra.framework.main.projectdata.actions.ProjectDataReadOnlyAction;
import ghidra.framework.main.projectdata.actions.ProjectDataRefreshAction;
import ghidra.framework.main.projectdata.actions.ProjectDataRenameAction;
import ghidra.framework.main.projectdata.actions.ProjectDataSelectAction;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFileFilter;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectData;
import ghidra.framework.model.ProjectLocator;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.layout.PairLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DataTreeDialog
extends DialogComponentProvider
implements GTreeSelectionListener,
ActionListener {
    public static final int OPEN = 0;
    public static final int SAVE = 1;
    public static final int CHOOSE_FOLDER = 2;
    public static final int CREATE = 3;
    protected static final int WIDTH = 350;
    protected static final int HEIGHT = 500;
    protected ProjectDataTreePanel treePanel;
    private JComboBox<String> projectComboBox;
    private ProjectLocator[] projectLocators;
    private DomainFileFilter filter;
    private JTextField nameField;
    private JLabel folderNameLabel;
    private ActionListener okActionListener;
    private DomainFolder domainFolder;
    private DomainFile domainFile;
    private int type;
    private Component parent;
    private String searchString;
    private boolean comboModelInitialized;
    private boolean cancelled = false;
    private String pendingNameText;
    private DomainFolder pendingDomainFolder;
    private ProjectDataCutAction cutAction;
    private ClearCutAction clearCutAction;
    private ProjectDataCopyAction copyAction;
    private ProjectDataPasteAction pasteAction;
    private ProjectDataRenameAction renameAction;
    private ProjectDataOpenDefaultToolAction openAction;
    private ProjectDataExpandAction expandAction;
    private ProjectDataCollapseAction collapseAction;
    private ProjectDataSelectAction selectAction;
    private ProjectDataReadOnlyAction readOnlyAction;
    private ProjectDataRefreshAction refreshAction;
    private ProjectDataNewFolderAction newFolderAction;
    private ProjectDataDeleteAction deleteAction;
    private Integer treeSelectionMode;

    public DataTreeDialog(Component parent, String title, int type) {
        this(parent, title, type, null);
    }

    public DataTreeDialog(Component parent, String title, int type, DomainFileFilter filter) {
        super(title, true, true, true, false);
        this.parent = parent;
        this.initDataTreeDialog(type, filter);
    }

    public void setTreeSelectionMode(int mode) {
        if (this.treePanel != null) {
            this.treePanel.getTreeSelectionModel().setSelectionMode(mode);
        }
        this.treeSelectionMode = mode;
    }

    private void initDataTreeDialog(int newType, DomainFileFilter newFilter) {
        if (newType < 0 || newType > 3) {
            throw new IllegalArgumentException("Invalid type specified: " + newType);
        }
        this.type = newType;
        this.filter = newFilter;
        this.okButton = new JButton("OK");
        this.okButton.setMnemonic('K');
        this.okButton.addActionListener(ev -> this.okCallback());
        this.addButton(this.okButton);
        this.addCancelButton();
        if (newType == 1) {
            this.okButton.setText("Save");
            this.okButton.setMnemonic('S');
        }
        if (newType == 3) {
            this.okButton.setText("Create");
            this.okButton.setMnemonic('C');
        }
        this.rootPanel.setPreferredSize(new Dimension(350, 500));
        this.setFocusComponent(this.nameField);
        this.createActions();
    }

    private void createActions() {
        String owner = "DataTreeDialogActions";
        String groupName = "Cut/copy/paste/new";
        this.newFolderAction = new ProjectDataNewFolderAction(owner, groupName);
        this.cutAction = new ProjectDataCutAction(owner, groupName);
        this.clearCutAction = new ClearCutAction(owner);
        this.copyAction = new ProjectDataCopyAction(owner, groupName);
        this.pasteAction = new ProjectDataPasteAction(owner, groupName);
        groupName = "Delete/Rename";
        this.renameAction = new ProjectDataRenameAction(owner, groupName);
        this.deleteAction = new ProjectDataDeleteAction(owner, groupName);
        this.openAction = new ProjectDataOpenDefaultToolAction(owner, "Delete/Rename");
        groupName = "Expand/Collapse";
        this.expandAction = new ProjectDataExpandAction(owner, groupName);
        this.collapseAction = new ProjectDataCollapseAction(owner, groupName);
        groupName = "Select/Toggle";
        this.selectAction = new ProjectDataSelectAction(owner, groupName);
        this.readOnlyAction = new ProjectDataReadOnlyAction(owner, groupName);
        groupName = "XRefresh";
        this.refreshAction = new ProjectDataRefreshAction(owner, groupName);
        this.addAction((DockingActionIf)this.newFolderAction);
        this.addAction((DockingActionIf)this.cutAction);
        this.addAction((DockingActionIf)this.clearCutAction);
        this.addAction((DockingActionIf)this.copyAction);
        this.addAction((DockingActionIf)this.pasteAction);
        this.addAction((DockingActionIf)this.deleteAction);
        this.addAction((DockingActionIf)this.openAction);
        this.addAction((DockingActionIf)this.renameAction);
        this.addAction((DockingActionIf)this.expandAction);
        this.addAction((DockingActionIf)this.collapseAction);
        this.addAction((DockingActionIf)this.selectAction);
        this.addAction((DockingActionIf)this.readOnlyAction);
        this.addAction((DockingActionIf)this.refreshAction);
    }

    public void addOkActionListener(ActionListener l) {
        this.okActionListener = l;
    }

    public ActionContext getActionContext(MouseEvent event) {
        if (this.treePanel == null) {
            return super.getActionContext(event);
        }
        return this.treePanel.getActionContext(null, event);
    }

    public void showComponent() {
        this.doSetup();
        DockingWindowManager.showDialog((Component)this.parent, (DialogComponentProvider)this);
    }

    protected void dialogShown() {
        if (!this.comboModelInitialized) {
            this.doSetup();
        }
    }

    private void doSetup() {
        this.addWorkPanel(this.buildMainPanel());
        this.comboModelInitialized = true;
        Project project = AppInfo.getActiveProject();
        ProjectData pd = project.getProjectData();
        this.treePanel.setProjectData(project.getName(), pd);
        String nameFieldText = this.pendingNameText == null ? "" : this.pendingNameText;
        this.pendingNameText = null;
        this.initializeSelectedFolder();
        if (this.type == 0) {
            this.domainFolder = null;
            this.nameField.setText(nameFieldText);
            this.nameField.selectAll();
            this.populateProjectModel();
        } else if (this.type == 1) {
            this.nameField.setText(nameFieldText);
            this.nameField.selectAll();
            this.initializeSelectedFolder();
        } else if (this.type == 3) {
            this.nameField.setText(nameFieldText);
            this.nameField.selectAll();
            this.initializeSelectedFolder();
        }
        this.setOkEnabled(!nameFieldText.isEmpty());
        if (this.searchString != null) {
            this.findAndSelect(this.searchString);
        }
        this.clearStatusText();
    }

    private void initializeSelectedFolder() {
        if (this.pendingDomainFolder != null) {
            this.treePanel.selectDomainFolder(this.pendingDomainFolder);
            this.pendingDomainFolder = null;
        } else {
            this.domainFolder = this.treePanel.getSelectedDomainFolder();
            if (this.domainFolder == null) {
                this.treePanel.selectRootDataFolder();
            }
        }
    }

    public String getNameText() {
        return this.nameField.getText();
    }

    public void setNameText(String name) {
        this.pendingNameText = name;
    }

    public void setSelectedFolder(DomainFolder folder) {
        this.pendingDomainFolder = folder;
    }

    public DomainFile getDomainFile() {
        if (this.domainFile == null && !this.cancelled) {
            this.domainFile = this.treePanel.getSelectedDomainFile();
        }
        return this.domainFile;
    }

    public DomainFolder getDomainFolder() {
        if (this.domainFolder == null && !this.cancelled) {
            this.domainFolder = this.treePanel.getSelectedDomainFolder();
        }
        return this.domainFolder;
    }

    public void valueChanged(GTreeSelectionEvent e) {
        this.clearStatusText();
        if (this.type == 2) {
            this.domainFolder = this.treePanel.getSelectedDomainFolder();
            if (this.domainFolder != null) {
                DomainFolder folderParent = this.domainFolder.getParent();
                if (folderParent != null) {
                    this.folderNameLabel.setText(folderParent.getPathname());
                } else {
                    this.folderNameLabel.setText("    ");
                }
                this.nameField.setText(this.domainFolder.getName());
            } else {
                this.domainFile = this.treePanel.getSelectedDomainFile();
                if (this.domainFile != null) {
                    this.domainFolder = this.domainFile.getParent();
                    DomainFolder grandParent = this.domainFolder.getParent();
                    if (grandParent != null) {
                        this.folderNameLabel.setText(grandParent.getPathname());
                    } else {
                        this.folderNameLabel.setText("");
                    }
                    this.nameField.setText(this.domainFolder.getName());
                } else {
                    this.domainFolder = AppInfo.getActiveProject().getProjectData().getRootFolder();
                    this.folderNameLabel.setText(this.domainFolder.getPathname());
                    this.nameField.setText(this.domainFolder.getName());
                }
            }
        } else {
            this.domainFile = this.treePanel.getSelectedDomainFile();
            if (this.domainFile != null) {
                this.folderNameLabel.setText(this.domainFile.getParent().getPathname());
                this.nameField.setText(this.domainFile.getName());
                this.domainFolder = this.domainFile.getParent();
            } else {
                this.domainFolder = this.treePanel.getSelectedDomainFolder();
                if (this.domainFolder == null) {
                    this.domainFolder = AppInfo.getActiveProject().getProjectData().getRootFolder();
                }
                this.folderNameLabel.setText(this.domainFolder.getPathname());
                if (this.nameField.isEditable()) {
                    if (this.nameField.getText().length() > 0) {
                        this.nameField.selectAll();
                    }
                } else {
                    this.nameField.setText("");
                }
            }
        }
        String text = this.nameField.getText();
        this.setOkEnabled(text != null && !text.isEmpty());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index = this.projectComboBox.getSelectedIndex();
        if (index < 0) {
            return;
        }
        Project project = AppInfo.getActiveProject();
        try {
            ProjectData pd = project.getProjectData(this.projectLocators[index]);
            if (pd == null) {
                Msg.showError(this.getClass(), (Component)this.getComponent(), (String)"Error Getting Project Data", (Object)("Could not get project data for " + this.projectLocators[index].getName()));
            } else {
                this.treePanel.setProjectData(this.projectLocators[index].getName(), pd);
            }
        }
        catch (Exception exc) {
            Msg.showError(this.getClass(), (Component)this.getComponent(), (String)"Error Getting Project Data", (Object)exc.toString(), (Throwable)exc);
        }
    }

    public void selectRootDataFolder() {
        SwingUtilities.invokeLater(() -> this.treePanel.selectRootDataFolder());
    }

    public void selectDomainFile(DomainFile file) {
        SwingUtilities.invokeLater(() -> this.treePanel.selectDomainFile(file));
    }

    public void close() {
        super.close();
        this.removeWorkPanel();
        if (this.treePanel != null) {
            this.treePanel.dispose();
        }
        this.treePanel = null;
        this.comboModelInitialized = false;
    }

    protected JPanel buildMainPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JPanel dataTreePanel = this.createDataTreePanel();
        if (this.type == 0) {
            JPanel comboPanel = this.createComboBoxPanel();
            panel.add((Component)comboPanel, "North");
        }
        panel.add((Component)dataTreePanel, "Center");
        JPanel namePanel = this.createNamePanel();
        panel.add((Component)namePanel, "South");
        return panel;
    }

    protected void okCallback() {
        this.cancelled = false;
        if (this.okActionListener == null) {
            this.close();
            return;
        }
        this.okActionListener.actionPerformed(new ActionEvent(this.okButton, 0, this.okButton.getActionCommand()));
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }

    protected void cancelCallback() {
        this.cancelled = true;
        this.close();
    }

    private JPanel createDataTreePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        Project project = AppInfo.getActiveProject();
        ProjectData pd = project.getProjectData();
        this.treePanel = new ProjectDataTreePanel(project.getName(), true, null, this.filter);
        if (this.treeSelectionMode != null) {
            this.treePanel.getTreeSelectionModel().setSelectionMode(this.treeSelectionMode);
        }
        this.treePanel.setProjectData(project.getName(), pd);
        this.treePanel.addTreeSelectionListener((GTreeSelectionListener)this);
        this.treePanel.setPreferredTreePanelSize(new Dimension(150, 150));
        this.addTreeListeners();
        panel.add((Component)this.treePanel, "Center");
        return panel;
    }

    protected void addTreeListeners() {
        if (this.type == 0) {
            this.treePanel.addTreeMouseListener((MouseListener)new GMouseListenerAdapter(){

                public void doubleClickTriggered(MouseEvent e) {
                    if (DataTreeDialog.this.okButton.isEnabled()) {
                        DataTreeDialog.this.okCallback();
                    }
                }
            });
        }
    }

    private JPanel createComboBoxPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(new TitledBorder("Current Projects"));
        this.projectComboBox = new JComboBox();
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        this.projectComboBox.setModel(model);
        model.addElement("defaultProject");
        panel.add(this.projectComboBox, "Center");
        this.projectComboBox.addActionListener(this);
        return panel;
    }

    private JPanel createNamePanel() {
        JPanel outerPanel = new JPanel();
        outerPanel.setLayout(new BorderLayout(5, 0));
        this.nameField = new JTextField(12);
        this.nameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            private void update() {
                String text = DataTreeDialog.this.nameField.getText();
                switch (DataTreeDialog.this.type) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        if (text != null && !text.isEmpty()) break;
                        DomainFile file = DataTreeDialog.this.treePanel.getSelectedDomainFile();
                        DataTreeDialog.this.okButton.setEnabled(file != null);
                        break;
                    }
                    case 3: {
                        if (text != null && !text.isEmpty()) break;
                        DomainFile file = DataTreeDialog.this.treePanel.getSelectedDomainFile();
                        DataTreeDialog.this.okButton.setEnabled(file != null);
                        break;
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        throw new AssertException("Must handle new type!: " + DataTreeDialog.this.type);
                    }
                }
                DataTreeDialog.this.setOkEnabled(text != null && !text.isEmpty());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update();
            }
        });
        this.folderNameLabel = new JLabel("   ");
        boolean userChoosesName = this.type == 1 || this.type == 3;
        this.nameField.setEditable(userChoosesName);
        this.nameField.setEnabled(userChoosesName);
        this.treePanel.setTreeFilterEnabled(!userChoosesName);
        JLabel nameLabel = null;
        nameLabel = this.type == 2 ? new JLabel("Folder Name:", 4) : new JLabel("Name:", 4);
        JPanel namePanel = new JPanel((LayoutManager)new PairLayout(2, 5, 100));
        if (!userChoosesName) {
            namePanel.setBorder(BorderFactory.createEmptyBorder(20, 5, 5, 5));
        }
        namePanel.add(new JLabel("Folder Path:", 4));
        namePanel.add(this.folderNameLabel);
        namePanel.add(nameLabel);
        namePanel.add(this.nameField);
        outerPanel.add((Component)namePanel, "Center");
        FieldKeyListener l = new FieldKeyListener();
        this.nameField.addKeyListener(l);
        this.nameField.addActionListener(e -> this.okCallback());
        return outerPanel;
    }

    private void populateProjectModel() {
        Project project = AppInfo.getActiveProject();
        ProjectLocator[] views = project.getProjectViews();
        this.projectLocators = new ProjectLocator[views.length + 1];
        this.projectLocators[0] = project.getProjectLocator();
        for (int i = 0; i < views.length; ++i) {
            this.projectLocators[i + 1] = views[i];
        }
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.projectComboBox.getModel();
        model.removeAllElements();
        HashSet<String> map = new HashSet<String>();
        for (ProjectLocator projectLocator : this.projectLocators) {
            String name = projectLocator.getName();
            if (map.contains(name)) {
                model.addElement(name + " (" + projectLocator.getLocation() + ")");
                continue;
            }
            map.add(name);
            model.addElement(name);
        }
        map = null;
    }

    public void findAndSelect(String s) {
        this.treePanel.findAndSelect(s);
    }

    public void setSearchText(String string) {
        this.searchString = string;
    }

    private class FieldKeyListener
    extends KeyAdapter {
        private FieldKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            DataTreeDialog.this.clearStatusText();
        }
    }
}

