/*
 * Decompiled with CFR 0.152.
 */
package ghidra.formats.gfilesystem;

import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileSystemRefManager;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileImpl;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.factory.GFileSystemFactoryIgnore;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FilenameUtils;

@FileSystemInfo(type="file", description="Local filesystem", factory=GFileSystemFactoryIgnore.class)
public class LocalFileSystem
implements GFileSystem {
    public static final String FSTYPE = "file";
    private final List<GFile> emptyDir = Collections.emptyList();
    private final FSRLRoot fsFSRL;
    private final FileSystemRefManager refManager = new FileSystemRefManager(this);

    public static LocalFileSystem makeGlobalRootFS() {
        return new LocalFileSystem(FSRLRoot.makeRoot(FSTYPE));
    }

    private LocalFileSystem(FSRLRoot fsrl) {
        this.fsFSRL = fsrl;
    }

    private boolean isSameFS(FSRL fsrl) {
        return this.fsFSRL.equals(fsrl.getFS());
    }

    public boolean isLocalSubdir(FSRL fsrl) {
        if (!this.isSameFS(fsrl)) {
            return false;
        }
        File localFile = new File(fsrl.getPath());
        return localFile.isDirectory();
    }

    public File getLocalFile(FSRL fsrl) throws IOException {
        if (!this.isSameFS(fsrl)) {
            throw new IOException("FSRL does not specify local file: " + fsrl);
        }
        File localFile = new File(fsrl.getPath());
        return localFile;
    }

    @Override
    public String getName() {
        return "Root Filesystem";
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public List<GFile> getListing(GFile directory) {
        ArrayList<GFile> results = new ArrayList<GFile>();
        if (directory == null) {
            for (File f : File.listRoots()) {
                results.add(GFileImpl.fromFSRL(this, null, this.fsFSRL.withPath(f.getName()), f.isDirectory(), -1L));
            }
        } else {
            File localDir = new File(directory.getPath());
            if (!localDir.isDirectory() || Files.isSymbolicLink(localDir.toPath())) {
                return this.emptyDir;
            }
            File[] files = localDir.listFiles();
            if (files == null) {
                return this.emptyDir;
            }
            for (File f : files) {
                if (!f.isFile() && !f.isDirectory()) continue;
                results.add(GFileImpl.fromFSRL(this, directory, directory.getFSRL().appendPath(f.getName()), f.isDirectory(), f.length()));
            }
        }
        return results;
    }

    @Override
    public String getInfo(GFile file, TaskMonitor monitor) {
        File localFile = new File(file.getPath());
        StringBuilder buffer = new StringBuilder();
        buffer.append("Name: " + localFile.getName() + "\n");
        buffer.append("Size: " + localFile.length() + "\n");
        buffer.append("Date: " + new Date(localFile.lastModified()).toString() + "\n");
        return buffer.toString();
    }

    @Override
    public FSRLRoot getFSRL() {
        return this.fsFSRL;
    }

    @Override
    public GFileImpl lookup(String path) throws IOException {
        File f = new File(path);
        GFileImpl gf = GFileImpl.fromPathString(this, FilenameUtils.separatorsToUnix((String)f.getPath()), null, f.isDirectory(), f.length());
        return gf;
    }

    @Override
    public InputStream getInputStream(GFile file, TaskMonitor monitor) throws IOException {
        File f = new File(file.getPath());
        return new FileInputStream(f);
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public FileSystemRefManager getRefManager() {
        return this.refManager;
    }

    public String toString() {
        return "Local file system " + this.fsFSRL;
    }
}

