/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.CompositeAttributedString;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.TextFieldElement;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.RowColLocation;
import ghidra.app.util.HighlightProvider;
import ghidra.app.util.XReferenceUtil;
import ghidra.app.util.viewer.field.BrowserCodeUnitFormat;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.ListingTextField;
import ghidra.app.util.viewer.field.NamespacePropertyEditor;
import ghidra.app.util.viewer.field.NamespaceWrappedOption;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.options.OptionsGui;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.framework.options.CustomOption;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.DataRefType;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ThunkReference;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.XRefFieldLocation;
import ghidra.util.HelpLocation;
import ghidra.util.exception.AssertException;
import java.awt.Color;
import java.beans.PropertyEditor;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.event.ChangeListener;

public class XRefFieldFactory
extends FieldFactory {
    static final String MORE_XREFS_STRING = "[more]";
    public static final String FIELD_NAME = "XRef";
    private static final String DELIMITER = ", ";
    private static final int MAX_XREFS = 20;
    protected SORT_CHOICE sortChoice = SORT_CHOICE.Address;
    private static final String GROUP_TITLE = "XREFs Field";
    private static final String DELIMITER_MSG = "XREFs Field.Delimiter";
    private static final String MAX_XREFS_MSG = "XREFs Field.Maximum Number of XREFs to Display";
    private static final String DISPLAY_BLOCK_NAME_MSG = "XREFs Field.Display Local Block";
    private static final String SORT_OPTION = "XREFs Field.Sort References By";
    private static final String DISPLAY_REFERENCE_TYPE_MSG = "XREFs Field.Display Reference Type";
    private static final String NAMESPACE_OPTIONS = "XREFs Field.Display Namespace";
    private PropertyEditor namespaceOptionsEditor = new NamespacePropertyEditor();
    protected Color offcutColor;
    protected Color readColor;
    protected Color writeColor;
    protected Color otherColor;
    protected String delim = ", ";
    protected boolean displayBlockName;
    protected int maxXRefs = 20;
    protected boolean displayRefType = true;
    protected Comparator<Reference> typeComparator;
    protected boolean displayLocalNamespace;
    protected boolean displayNonLocalNamespace;
    protected boolean useLocalPrefixOverride;
    protected String localPrefixText;
    private BrowserCodeUnitFormat codeUnitFormat;
    private ChangeListener codeUnitFormatListener = e -> this.model.update();

    public XRefFieldFactory() {
        this(FIELD_NAME);
    }

    protected XRefFieldFactory(String name) {
        super(name);
    }

    public XRefFieldFactory(FieldFormatModel model, HighlightProvider hlProvider, Options displayOptions, ToolOptions fieldOptions) {
        this(FIELD_NAME, model, hlProvider, displayOptions, fieldOptions);
    }

    protected XRefFieldFactory(String name, FieldFormatModel model, HighlightProvider hlProvider, Options displayOptions, ToolOptions fieldOptions) {
        super(name, model, hlProvider, displayOptions, (Options)fieldOptions);
        HelpLocation hl = new HelpLocation("CodeBrowserPlugin", "XREFs_Field");
        fieldOptions.registerOption(DELIMITER_MSG, (Object)DELIMITER, hl, "Delimiter string used for separating multiple xrefs.");
        fieldOptions.registerOption(DISPLAY_BLOCK_NAME_MSG, (Object)false, hl, "Prepends xref addresses with the name of the memory block containing the xref address.");
        fieldOptions.registerOption(MAX_XREFS_MSG, (Object)20, hl, "Sets the maximum number of xrefs to display.");
        fieldOptions.registerOption(DISPLAY_REFERENCE_TYPE_MSG, (Object)true, hl, "Appends xref type.");
        fieldOptions.registerOption(SORT_OPTION, (Object)SORT_CHOICE.Address, hl, "How to sort the xrefs");
        this.offcutColor = displayOptions.getColor(OptionsGui.XREF_OFFCUT.getColorOptionName(), OptionsGui.XREF_OFFCUT.getDefaultColor());
        this.readColor = displayOptions.getColor(OptionsGui.XREF_READ.getColorOptionName(), OptionsGui.XREF_READ.getDefaultColor());
        this.writeColor = displayOptions.getColor(OptionsGui.XREF_WRITE.getColorOptionName(), OptionsGui.XREF_WRITE.getDefaultColor());
        this.otherColor = displayOptions.getColor(OptionsGui.XREF_OTHER.getColorOptionName(), OptionsGui.XREF_OTHER.getDefaultColor());
        this.typeComparator = (r1, r2) -> {
            if (r1.getReferenceType().toString().equals(r2.getReferenceType().toString())) {
                return r1.compareTo(r2);
            }
            return r1.getReferenceType().toString().compareTo(r2.getReferenceType().toString());
        };
        this.delim = fieldOptions.getString(DELIMITER_MSG, DELIMITER);
        this.displayBlockName = fieldOptions.getBoolean(DISPLAY_BLOCK_NAME_MSG, false);
        this.maxXRefs = fieldOptions.getInt(MAX_XREFS_MSG, 20);
        this.sortChoice = (SORT_CHOICE)fieldOptions.getEnum(SORT_OPTION, (Enum)SORT_CHOICE.Address);
        this.displayRefType = fieldOptions.getBoolean(DISPLAY_REFERENCE_TYPE_MSG, true);
        fieldOptions.getOptions(GROUP_TITLE).setOptionsHelpLocation(hl);
        this.setupNamespaceOptions((Options)fieldOptions);
        this.codeUnitFormat = new BrowserCodeUnitFormat(fieldOptions, true);
        this.codeUnitFormat.addChangeListener(this.codeUnitFormatListener);
    }

    private void setupNamespaceOptions(Options fieldOptions) {
        fieldOptions.registerOption(NAMESPACE_OPTIONS, OptionType.CUSTOM_TYPE, (Object)new NamespaceWrappedOption(), null, null, this.namespaceOptionsEditor);
        CustomOption customOption = fieldOptions.getCustomOption(NAMESPACE_OPTIONS, null);
        fieldOptions.getOptions(NAMESPACE_OPTIONS).setOptionsHelpLocation(new HelpLocation("CodeBrowserPlugin", "XREFs_Field"));
        if (!(customOption instanceof NamespaceWrappedOption)) {
            throw new AssertException("Someone set an option for XREFs Field.Display Namespace that is not the expected ghidra.app.util.viewer.field.NamespaceWrappedOption type.");
        }
        NamespaceWrappedOption namespaceOption = (NamespaceWrappedOption)customOption;
        this.displayLocalNamespace = namespaceOption.isShowLocalNamespace();
        this.displayNonLocalNamespace = namespaceOption.isShowNonLocalNamespace();
        this.useLocalPrefixOverride = namespaceOption.isUseLocalPrefixOverride();
        this.localPrefixText = namespaceOption.getLocalPrefixText();
    }

    @Override
    public void displayOptionsChanged(Options options, String optionName, Object oldValue, Object newValue) {
        super.displayOptionsChanged(options, optionName, oldValue, newValue);
        if (optionName.equals(OptionsGui.XREF_OFFCUT.getColorOptionName())) {
            this.offcutColor = (Color)newValue;
            this.model.update();
        } else if (optionName.equals(OptionsGui.XREF.getColorOptionName())) {
            this.color = (Color)newValue;
            this.model.update();
        } else if (optionName.equals(OptionsGui.XREF_READ.getColorOptionName())) {
            this.readColor = (Color)newValue;
            this.model.update();
        } else if (optionName.equals(OptionsGui.XREF_WRITE.getColorOptionName())) {
            this.writeColor = (Color)newValue;
            this.model.update();
        } else if (optionName.equals(OptionsGui.XREF_OTHER.getColorOptionName())) {
            this.otherColor = (Color)newValue;
            this.model.update();
        }
    }

    @Override
    public void fieldOptionsChanged(Options options, String optionName, Object oldValue, Object newValue) {
        super.fieldOptionsChanged(options, optionName, oldValue, newValue);
        if (optionName.equals(DELIMITER_MSG)) {
            this.delim = (String)newValue;
            this.model.update();
        } else if (optionName.equals(DISPLAY_BLOCK_NAME_MSG)) {
            this.displayBlockName = (Boolean)newValue;
        } else if (optionName.equals(DISPLAY_REFERENCE_TYPE_MSG)) {
            this.displayRefType = (Boolean)newValue;
        } else if (optionName.equals(MAX_XREFS_MSG)) {
            this.setMaxSize((Integer)newValue, options);
        } else if (optionName.equals(SORT_OPTION)) {
            this.sortChoice = (SORT_CHOICE)((Object)newValue);
            this.model.update();
        } else if (optionName.equals(NAMESPACE_OPTIONS)) {
            this.setupNamespaceOptions(options);
            this.model.update();
        }
    }

    private void setMaxSize(int n, Options options) {
        if (n < 1) {
            n = 1;
            options.setInt(MAX_XREFS_MSG, 1);
        }
        this.maxXRefs = n;
    }

    @Override
    public Color getDefaultColor() {
        return OptionsGui.XREF.getDefaultColor();
    }

    @Override
    public ListingField getField(ProxyObj<?> proxy, int varWidth) {
        int count;
        Object obj = proxy.getObject();
        if (!this.enabled) {
            return null;
        }
        if (obj == null || !(obj instanceof CodeUnit)) {
            return null;
        }
        CodeUnit cu = (CodeUnit)obj;
        Program pgm = cu.getProgram();
        Object[] xrefs = XReferenceUtil.getXReferences(cu, this.maxXRefs + 1);
        int maxOffcuts = Math.max(0, this.maxXRefs - xrefs.length);
        Object[] offcuts = XReferenceUtil.getOffcutXReferences(cu, maxOffcuts);
        if (this.sortChoice == SORT_CHOICE.Address) {
            Arrays.sort(xrefs);
            Arrays.sort(offcuts);
        } else {
            Arrays.sort(xrefs, this.typeComparator);
            Arrays.sort(offcuts, this.typeComparator);
        }
        int totalXrefs = xrefs.length + offcuts.length;
        if (totalXrefs == 0) {
            return null;
        }
        boolean tooMany = totalXrefs > this.maxXRefs;
        AttributedString delimiter = new AttributedString(this.delim, Color.BLACK, this.getMetrics());
        FieldElement[] elements = new FieldElement[tooMany ? this.maxXRefs + 1 : totalXrefs];
        Function currentFunction = pgm.getFunctionManager().getFunctionContaining(cu.getMinAddress());
        for (count = 0; count < xrefs.length && count < elements.length; ++count) {
            String prefix = this.getPrefix(pgm, (Reference)xrefs[count], currentFunction);
            String addressString = xrefs[count].getFromAddress().toString(prefix);
            AttributedString as = new AttributedString(addressString, this.color, this.getMetrics());
            if (this.displayRefType) {
                as = this.createRefTypeAttributedString((Reference)xrefs[count], as);
            }
            if (count < totalXrefs - 1) {
                as = new CompositeAttributedString(new AttributedString[]{as, delimiter});
            } else {
                char[] charSpaces = new char[delimiter.length()];
                Arrays.fill(charSpaces, ' ');
                AttributedString spaces = new AttributedString(new String(charSpaces), this.color, this.getMetrics());
                as = new CompositeAttributedString(new AttributedString[]{as, spaces});
            }
            elements[count] = new TextFieldElement(as, count, 0);
        }
        for (int i = 0; i < offcuts.length && count < elements.length; ++i, ++count) {
            String prefix = this.getPrefix(pgm, (Reference)offcuts[i], currentFunction);
            String addressString = offcuts[i].getFromAddress().toString(prefix);
            AttributedString as = new AttributedString(addressString, this.offcutColor, this.getMetrics());
            if (this.displayRefType) {
                as = this.createRefTypeAttributedString((Reference)offcuts[i], as);
            }
            if (count < totalXrefs - 1) {
                as = new CompositeAttributedString(new AttributedString[]{as, delimiter});
            } else {
                char[] charSpaces = new char[delimiter.length()];
                Arrays.fill(charSpaces, ' ');
                AttributedString spaces = new AttributedString(new String(charSpaces), this.offcutColor, this.getMetrics());
                as = new CompositeAttributedString(new AttributedString[]{as, spaces});
            }
            elements[count] = new TextFieldElement(as, count, 0);
        }
        if (tooMany) {
            AttributedString as = new AttributedString(MORE_XREFS_STRING, this.color, this.getMetrics());
            elements[elements.length - 1] = new TextFieldElement(as, count - 1, 0);
        }
        return ListingTextField.createPackedTextField(this, proxy, elements, this.startX + varWidth, this.width, this.maxXRefs, this.hlProvider);
    }

    protected AttributedString createRefTypeAttributedString(Reference reference, AttributedString referenceString) {
        AttributedString fullReferenceString = referenceString;
        if (reference.getReferenceType().isRead() && reference.getReferenceType().isWrite()) {
            AttributedString typeString = new AttributedString("(R", this.readColor, this.getMetrics());
            fullReferenceString = new CompositeAttributedString(new AttributedString[]{fullReferenceString, typeString});
            typeString = new AttributedString("W)", this.writeColor, this.getMetrics());
            return new CompositeAttributedString(new AttributedString[]{fullReferenceString, typeString});
        }
        Color displayColor = this.color;
        if (reference.getReferenceType().isRead() || reference.getReferenceType().isIndirect()) {
            displayColor = this.readColor;
        } else if (reference.getReferenceType().isWrite()) {
            displayColor = this.writeColor;
        } else if (reference.getReferenceType().isData()) {
            displayColor = this.otherColor;
        }
        AttributedString typeString = new AttributedString(this.getRefTypeDisplayString(reference), displayColor, this.getMetrics());
        return new CompositeAttributedString(new AttributedString[]{fullReferenceString, typeString});
    }

    protected String getPrefix(Program program, Reference reference, Function currentFunction) {
        Object prefix = "";
        Address fromAddress = reference.getFromAddress();
        if (this.displayBlockName) {
            prefix = this.getBlockName(program, fromAddress) + ":";
        }
        if (!this.displayLocalNamespace && !this.displayNonLocalNamespace) {
            return prefix;
        }
        Function refFunction = program.getListing().getFunctionContaining(fromAddress);
        if (refFunction == null) {
            return prefix;
        }
        boolean isLocal = refFunction.equals(currentFunction);
        if (!isLocal) {
            if (this.displayNonLocalNamespace) {
                return (String)prefix + refFunction.getName() + ":";
            }
            return prefix;
        }
        if (!this.displayLocalNamespace) {
            return prefix;
        }
        if (this.useLocalPrefixOverride) {
            return (String)prefix + this.localPrefixText;
        }
        return (String)prefix + currentFunction.getName() + ":";
    }

    private String getRefTypeDisplayString(Reference reference) {
        RefType refType = reference.getReferenceType();
        if (reference instanceof ThunkReference) {
            return "(T)";
        }
        if (refType instanceof DataRefType) {
            if (refType.isRead() || refType.isIndirect()) {
                return "(R)";
            }
            if (refType.isWrite()) {
                return "(W)";
            }
            if (refType.isData()) {
                return "(*)";
            }
        }
        if (refType.isCall()) {
            return "(c)";
        }
        if (refType.isJump()) {
            return "(j)";
        }
        return "";
    }

    @Override
    public FieldLocation getFieldLocation(ListingField bf, BigInteger index, int fieldNum, ProgramLocation loc) {
        if (!(loc instanceof XRefFieldLocation)) {
            return null;
        }
        XRefFieldLocation xRefLoc = (XRefFieldLocation)loc;
        int xrefPos = xRefLoc.getCharOffset();
        int xrefIndex = xRefLoc.getIndex();
        if (!this.hasSamePath(bf, loc)) {
            return null;
        }
        return this.createFieldLocation(xrefPos, xrefIndex, (ListingTextField)bf, index, fieldNum);
    }

    protected FieldLocation createFieldLocation(int xrefPos, int xrefIndex, ListingTextField field, BigInteger index, int fieldNum) {
        RowColLocation loc = field.dataToScreenLocation(xrefIndex, xrefPos);
        return new FieldLocation(index, fieldNum, loc.row(), loc.col());
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int col, ListingField bf) {
        Object obj = bf.getProxy().getObject();
        if (obj == null || !(obj instanceof CodeUnit)) {
            return null;
        }
        CodeUnit cu = (CodeUnit)obj;
        ListingTextField field = (ListingTextField)this.getField(bf.getProxy(), 0);
        if (field == null) {
            return null;
        }
        RowColLocation loc = field.screenToDataLocation(row, col);
        int index = loc.row();
        Object[] xrefs = XReferenceUtil.getXReferences(cu, this.maxXRefs + 1);
        if (this.sortChoice == SORT_CHOICE.Address) {
            Arrays.sort(xrefs);
        } else {
            Arrays.sort(xrefs, this.typeComparator);
        }
        Address refAddr = null;
        if (index < xrefs.length) {
            refAddr = xrefs[index].getFromAddress();
        } else {
            Object[] offcuts = XReferenceUtil.getOffcutXReferences(cu, this.maxXRefs);
            if (this.sortChoice == SORT_CHOICE.Address) {
                Arrays.sort(offcuts);
            } else {
                Arrays.sort(offcuts, this.typeComparator);
            }
            if (index < xrefs.length + offcuts.length) {
                refAddr = offcuts[index - xrefs.length].getFromAddress();
            }
        }
        if (refAddr != null) {
            int[] cpath = null;
            if (cu instanceof Data) {
                cpath = ((Data)cu).getComponentPath();
            }
            return new XRefFieldLocation(cu.getProgram(), cu.getMinAddress(), cpath, refAddr, index, loc.col());
        }
        return null;
    }

    protected String getBlockName(Program pgm, Address addr) {
        Memory mem = pgm.getMemory();
        MemoryBlock block = mem.getBlock(addr);
        if (block != null) {
            return block.getName();
        }
        return "";
    }

    protected Address getXRefLocation(Object obj) {
        if (obj == null || !(obj instanceof CodeUnit)) {
            return null;
        }
        return ((CodeUnit)obj).getMinAddress();
    }

    protected Program getProgram(Object obj) {
        if (obj == null || !(obj instanceof CodeUnit)) {
            return null;
        }
        return ((CodeUnit)obj).getProgram();
    }

    @Override
    public boolean acceptsType(int category, Class<?> proxyObjectClass) {
        if (!CodeUnit.class.isAssignableFrom(proxyObjectClass)) {
            return false;
        }
        return category == 4 || category == 5;
    }

    @Override
    public FieldFactory newInstance(FieldFormatModel formatModel, HighlightProvider provider, ToolOptions displayOptions, ToolOptions fieldOptions) {
        return new XRefFieldFactory(formatModel, provider, (Options)displayOptions, fieldOptions);
    }

    public static enum SORT_CHOICE {
        Address,
        Type;

    }
}

