/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.bin.format.MemoryLoadable;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSpace;

public class MemorySection {
    protected final MemoryLoadable key;
    protected final boolean isInitialized;
    protected final long fileOffset;
    protected final long length;
    protected final boolean isFragmentationOK;
    protected final AddressRange range;
    protected final String sectionName;
    protected final boolean isReadable;
    protected final boolean isWritable;
    protected final boolean isExecute;
    protected final String comment;

    protected MemorySection(MemoryLoadable key, boolean isInitialized, long fileOffset, long length, AddressRange range, String sectionName, boolean isReadable, boolean isWritable, boolean isExecute, String comment, boolean isFragmentationOK) {
        AddressSpace space = range.getAddressSpace();
        if (!space.isMemorySpace()) {
            throw new IllegalArgumentException("memory-based address required");
        }
        this.key = key;
        this.isInitialized = isInitialized;
        this.fileOffset = fileOffset;
        this.length = length;
        this.range = range;
        this.sectionName = sectionName;
        this.isReadable = isReadable;
        this.isWritable = isWritable;
        this.isExecute = isExecute;
        this.comment = comment;
        this.isFragmentationOK = isFragmentationOK;
    }

    public MemoryLoadable getKey() {
        return this.key;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public long getFileOffset() {
        return this.fileOffset;
    }

    public long getNumberOfBytes() {
        return this.length;
    }

    public AddressRange getRange() {
        return this.range;
    }

    public Address getMinAddress() {
        return this.range.getMinAddress();
    }

    public Address getMaxAddress() {
        return this.range.getMaxAddress();
    }

    public AddressSpace getAddressSpace() {
        return this.range.getMinAddress().getAddressSpace();
    }

    public String getSectionName() {
        return this.sectionName;
    }

    public boolean isLoaded() {
        return this.range.getAddressSpace() != AddressSpace.OTHER_SPACE;
    }

    public boolean isReadable() {
        return this.isReadable;
    }

    public boolean isWritable() {
        return this.isWritable;
    }

    public boolean isExecute() {
        return this.isExecute;
    }

    public String getComment() {
        return this.comment;
    }

    public String toString() {
        return this.isInitialized ? String.format("%s (%d, %d @ %s)", this.sectionName, this.fileOffset, this.length, this.range) : String.format("%s (uninitialized @ %s)", this.sectionName, this.range);
    }
}

