/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import generic.continues.GenericFactory;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.Section;
import ghidra.app.util.bin.format.macho.prelink.PrelinkMap;
import ghidra.app.util.importer.MemoryConflictHandler;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.importer.MessageLogContinuesFactory;
import ghidra.app.util.opinion.MachoPrelinkUtils;
import ghidra.app.util.opinion.MachoProgramBuilder;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.Pointer64DataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.BidiMap;

public class MachoPrelinkProgramBuilder
extends MachoProgramBuilder {
    private List<PrelinkMap> prelinkList;

    protected MachoPrelinkProgramBuilder(Program program, ByteProvider provider, List<PrelinkMap> prelinkList, MessageLog log, MemoryConflictHandler memoryConflictHandler, TaskMonitor monitor) {
        super(program, provider, log, memoryConflictHandler, monitor);
        this.prelinkList = prelinkList;
    }

    public static void buildProgram(Program program, ByteProvider provider, List<PrelinkMap> prelinkList, MessageLog log, MemoryConflictHandler memoryConflictHandler, TaskMonitor monitor) throws Exception {
        MachoPrelinkProgramBuilder machoPrelinkProgramBuilder = new MachoPrelinkProgramBuilder(program, provider, prelinkList, log, memoryConflictHandler, monitor);
        machoPrelinkProgramBuilder.build();
    }

    @Override
    protected void build() throws Exception {
        super.build();
        List<Address> fixedAddresses = this.fixupChainedPointers();
        List<Long> machoHeaderOffsets = MachoPrelinkUtils.findPrelinkMachoHeaderOffsets(this.provider, this.monitor);
        if (machoHeaderOffsets.isEmpty()) {
            return;
        }
        BidiMap<PrelinkMap, Long> map = MachoPrelinkUtils.matchPrelinkToMachoHeaderOffsets(this.provider, this.prelinkList, machoHeaderOffsets, this.monitor);
        long prelinkStart = MachoPrelinkUtils.getPrelinkStartAddr(this.machoHeader);
        Address prelinkStartAddr = null;
        prelinkStartAddr = prelinkStart == 0L ? this.program.getImageBase().add(machoHeaderOffsets.get(0).longValue()) : this.space.getAddress(prelinkStart);
        ArrayList<PrelinkMachoInfo> prelinkMachoInfoList = new ArrayList<PrelinkMachoInfo>();
        for (Long machoHeaderOffset : machoHeaderOffsets) {
            prelinkMachoInfoList.add(new PrelinkMachoInfo(this.provider, machoHeaderOffset, prelinkStartAddr.add(machoHeaderOffset - machoHeaderOffsets.get(0)), (PrelinkMap)map.getKey((Object)machoHeaderOffset)));
        }
        this.monitor.initialize((long)prelinkMachoInfoList.size());
        for (int i = 0; i < prelinkMachoInfoList.size(); ++i) {
            PrelinkMachoInfo info = (PrelinkMachoInfo)prelinkMachoInfoList.get(i);
            PrelinkMachoInfo next = null;
            if (i < prelinkMachoInfoList.size() - 1) {
                next = (PrelinkMachoInfo)prelinkMachoInfoList.get(i + 1);
            }
            info.processMemoryBlocks();
            info.markupHeaders();
            info.addToProgramTree(next);
            this.monitor.incrementProgress(1L);
        }
        fixedAddresses.forEach(addr -> {
            try {
                DataUtilities.createData((Program)this.program, (Address)addr, (DataType)Pointer64DataType.dataType, (int)-1, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CLEAR_ALL_UNDEFINED_CONFLICT_DATA);
            }
            catch (CodeUnitInsertionException codeUnitInsertionException) {
                // empty catch block
            }
        });
    }

    @Override
    protected void renameObjMsgSendRtpSymbol() throws DuplicateNameException, InvalidInputException {
    }

    private List<Address> fixupChainedPointers() throws MemoryAccessException {
        int headStartOffset;
        Section threadStarts = this.machoHeader.getSection("__TEXT", "__thread_starts");
        if (threadStarts == null) {
            return Collections.emptyList();
        }
        this.monitor.setMessage("Fixing up chained pointers...");
        ArrayList<Address> fixedAddresses = new ArrayList<Address>();
        Address threadSectionStart = this.space.getAddress(threadStarts.getAddress());
        Address threadSectionEnd = threadSectionStart.add(threadStarts.getSize() - 1L);
        long nextOffSize = (this.memory.getInt(threadSectionStart) & 1) * 4 + 4;
        Address chainHead = threadSectionStart.add(4L);
        while (chainHead.compareTo((Object)threadSectionEnd) < 0 && !this.monitor.isCancelled() && (headStartOffset = this.memory.getInt(chainHead)) != -1 && headStartOffset != 0) {
            Address chainStart = this.program.getImageBase().add((long)headStartOffset & 0xFFFFFFFFL);
            fixedAddresses.addAll(this.processPointerChain(chainStart, nextOffSize));
            chainHead = chainHead.add(4L);
        }
        this.log.appendMsg("Fixed up " + fixedAddresses.size() + " chained pointers.");
        return fixedAddresses;
    }

    private List<Address> processPointerChain(Address chainStart, long nextOffSize) throws MemoryAccessException {
        ArrayList<Address> fixedAddresses = new ArrayList<Address>();
        while (!this.monitor.isCancelled()) {
            long chainValue = this.memory.getLong(chainStart);
            this.fixupPointer(chainStart, chainValue);
            fixedAddresses.add(chainStart);
            long nextValueOff = (chainValue >> 51 & 0x7FFL) * nextOffSize;
            if (nextValueOff == 0L) break;
            chainStart = chainStart.add(nextValueOff);
        }
        return fixedAddresses;
    }

    private void fixupPointer(Address pointerAddr, long pointerValue) throws MemoryAccessException {
        long BIT63 = Long.MIN_VALUE;
        long BIT62 = 0x4000000000000000L;
        if ((pointerValue & 0x4000000000000000L) != 0L) {
            // empty if block
        }
        long fixedPointerValue = 0L;
        long fixedPointerType = 0L;
        if ((pointerValue & Long.MIN_VALUE) != 0L) {
            long pacMod;
            fixedPointerType = pacMod = pointerValue >> 32 & 0xFFFFL;
            fixedPointerValue = this.program.getImageBase().getOffset() + (pointerValue & 0xFFFFFFFFL);
        } else {
            fixedPointerValue = pointerValue << 13 & 0xFF00000000000000L | pointerValue & 0x7FFFFFFFFFFL;
            if ((pointerValue & 0x40000000000L) != 0L) {
                fixedPointerValue |= 0xFFFC0000000000L;
            }
        }
        byte[] origBytes = new byte[8];
        this.memory.getBytes(pointerAddr, origBytes);
        this.program.getRelocationTable().add(pointerAddr, (int)fixedPointerType, new long[]{fixedPointerValue}, origBytes, null);
        this.memory.setLong(pointerAddr, fixedPointerValue);
    }

    private class PrelinkMachoInfo {
        private Address headerAddr;
        private MachHeader header;
        private String name;

        public PrelinkMachoInfo(ByteProvider provider, long offset, Address headerAddr, PrelinkMap prelink) throws Exception {
            String path;
            this.headerAddr = headerAddr;
            this.header = MachHeader.createMachHeader((GenericFactory)MessageLogContinuesFactory.create((MessageLog)MachoPrelinkProgramBuilder.this.log), provider, offset);
            this.header.parse();
            this.headerAddr = headerAddr;
            this.name = "";
            if (prelink != null && (path = prelink.getPrelinkBundlePath()) != null) {
                this.name = new File(path).getName();
            }
        }

        public void processMemoryBlocks() throws Exception {
            MachoPrelinkProgramBuilder.this.processMemoryBlocks(this.header, this.name, false);
        }

        public void markupHeaders() throws Exception {
            MachoPrelinkProgramBuilder.this.markupHeaders(this.header, this.headerAddr);
            if (!this.name.isEmpty()) {
                MachoPrelinkProgramBuilder.this.listing.setComment(this.headerAddr, 3, this.name);
            }
        }

        public void addToProgramTree(PrelinkMachoInfo next) throws Exception {
            if (!this.name.isEmpty()) {
                ProgramFragment fragment = MachoPrelinkProgramBuilder.this.listing.getDefaultRootModule().createFragment(this.name);
                if (next != null) {
                    fragment.move(this.headerAddr, next.headerAddr.subtract(1L));
                } else {
                    for (Section section : MachoPrelinkProgramBuilder.this.machoHeader.getAllSections()) {
                        Address sectionAddr = MachoPrelinkProgramBuilder.this.space.getAddress(section.getAddress());
                        if (this.headerAddr.compareTo((Object)sectionAddr) < 0 || this.headerAddr.compareTo((Object)sectionAddr.add(section.getSize() - 1L)) > 0) continue;
                        fragment.move(this.headerAddr, sectionAddr.add(section.getSize() - 1L));
                    }
                }
            }
        }
    }
}

