/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.html;

import ghidra.app.util.html.EmptyTextLine;
import ghidra.app.util.html.HTMLDataTypeRepresentation;
import ghidra.app.util.html.PlaceHolderLine;
import ghidra.app.util.html.TextLine;
import ghidra.app.util.html.ValidatableLine;
import ghidra.app.util.html.diff.DataTypeDiff;
import ghidra.app.util.html.diff.DataTypeDiffBuilder;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Enum;
import ghidra.util.HTMLUtilities;
import ghidra.util.exception.AssertException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class EnumDataTypeHTMLRepresentation
extends HTMLDataTypeRepresentation {
    protected List<ValidatableLine> headerContent;
    protected List<ValidatableLine> bodyContent;
    protected TextLine footerLine;
    protected TextLine displayName;

    private EnumDataTypeHTMLRepresentation(List<ValidatableLine> headerLines, TextLine displayName, List<ValidatableLine> bodyContent, TextLine footerLine) {
        this.headerContent = headerLines;
        this.displayName = displayName;
        this.bodyContent = bodyContent;
        this.footerLine = footerLine;
        this.originalHTMLData = EnumDataTypeHTMLRepresentation.buildHTMLText(headerLines, displayName, bodyContent, footerLine);
    }

    public EnumDataTypeHTMLRepresentation(Enum enumDataType) {
        this.headerContent = this.buildHeaderText((DataType)enumDataType);
        this.bodyContent = this.buildContent(enumDataType);
        this.footerLine = this.buildFooterText((DataType)enumDataType);
        this.displayName = new TextLine(enumDataType.getDisplayName());
        this.originalHTMLData = EnumDataTypeHTMLRepresentation.buildHTMLText(this.headerContent, this.displayName, this.bodyContent, this.footerLine);
    }

    @Override
    protected PlaceHolderLine createPlaceHolderLine(ValidatableLine oppositeLine) {
        if (!(oppositeLine instanceof TextLine)) {
            throw new AssertException("I didn't know you could pass me other types of lines?!");
        }
        TextLine textLine = (TextLine)oppositeLine;
        int stringLength = textLine.getText().length();
        return new EmptyTextLine(stringLength);
    }

    private List<ValidatableLine> buildContent(Enum enumDataType) {
        long[] values = enumDataType.getValues();
        Arrays.sort(values);
        ArrayList<ValidatableLine> list = new ArrayList<ValidatableLine>(values.length);
        for (long value : values) {
            String name = enumDataType.getName(value);
            list.add(new TextLine(name + " = 0x" + Long.toHexString(value)));
        }
        return list;
    }

    private static String buildHTMLText(List<ValidatableLine> headerLines, TextLine displayName, List<ValidatableLine> bodyLines, TextLine footerLine) {
        StringBuffer buffy = new StringBuffer();
        for (TextLine textLine : headerLines) {
            String encodedHeaderLine = textLine.getText();
            String headerLine = EnumDataTypeHTMLRepresentation.wrapStringInColor(encodedHeaderLine, textLine.getTextColor());
            buffy.append(headerLine);
        }
        String string = HTMLUtilities.friendlyEncodeHTML((String)displayName.getText());
        String displayNameText = EnumDataTypeHTMLRepresentation.wrapStringInColor(string, displayName.getTextColor());
        buffy.append("<TT>").append(displayNameText).append("</TT>").append("&nbsp;").append("{").append("&nbsp;").append("<BR>");
        int length = bodyLines.size();
        for (int i = 0; i < length; ++i) {
            TextLine textLine = (TextLine)bodyLines.get(i);
            String text = textLine.getText();
            String encodedBodyLine = HTMLUtilities.friendlyEncodeHTML((String)text);
            text = EnumDataTypeHTMLRepresentation.wrapStringInColor(encodedBodyLine, textLine.getTextColor());
            buffy.append(TAB).append(text).append("&nbsp;");
            if (i < length - 1) {
                buffy.append("<BR>");
            }
            if (i <= 50) continue;
            buffy.append(TAB).append("...").append("<BR>");
            break;
        }
        buffy.append("<BR>").append("}").append("<BR>").append("</TT>");
        EnumDataTypeHTMLRepresentation.addDataTypeLength(footerLine.getText(), buffy);
        return buffy.toString();
    }

    @Override
    public HTMLDataTypeRepresentation[] diff(HTMLDataTypeRepresentation otherRepresentation) {
        if (this == otherRepresentation) {
            return new HTMLDataTypeRepresentation[]{this, this};
        }
        if (!(otherRepresentation instanceof EnumDataTypeHTMLRepresentation)) {
            return this.completelyDifferentDiff(otherRepresentation);
        }
        EnumDataTypeHTMLRepresentation compositeRepresentation = (EnumDataTypeHTMLRepresentation)otherRepresentation;
        List<ValidatableLine> header = this.copyLines(this.headerContent);
        List<ValidatableLine> body = this.copyLines(this.bodyContent);
        TextLine diffDisplayName = new TextLine(this.displayName.getText());
        List<ValidatableLine> otherHeader = this.copyLines(compositeRepresentation.headerContent);
        List<ValidatableLine> otherBody = this.copyLines(compositeRepresentation.bodyContent);
        TextLine otherDiffDisplayName = new TextLine(compositeRepresentation.displayName.getText());
        DataTypeDiff headerDiff = DataTypeDiffBuilder.diffHeader(this.getDiffInput(header), this.getDiffInput(otherHeader));
        DataTypeDiff bodyDiff = DataTypeDiffBuilder.diffBody(this.getDiffInput(body), this.getDiffInput(otherBody));
        this.diffTextLine(diffDisplayName, otherDiffDisplayName);
        return new HTMLDataTypeRepresentation[]{new EnumDataTypeHTMLRepresentation(headerDiff.getLeftLines(), diffDisplayName, bodyDiff.getLeftLines(), this.footerLine), new EnumDataTypeHTMLRepresentation(headerDiff.getRightLines(), otherDiffDisplayName, bodyDiff.getRightLines(), compositeRepresentation.footerLine)};
    }
}

