/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.ne;

import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.ne.LengthStringSet;
import ghidra.app.util.bin.format.ne.Resource;
import ghidra.app.util.bin.format.ne.ResourceTable;
import ghidra.util.Conv;
import java.io.IOException;
import java.util.ArrayList;

public class ResourceStringTable
extends Resource {
    private LengthStringSet[] strings;

    ResourceStringTable(FactoryBundledWithBinaryReader reader, ResourceTable rt) throws IOException {
        super(reader, rt);
        byte[] bytes = this.getBytes();
        ArrayList<LengthStringSet> list = new ArrayList<LengthStringSet>();
        int i = 0;
        while (i < bytes.length) {
            if (bytes[i] != 0) {
                long oldIndex = reader.getPointerIndex();
                reader.setPointerIndex(this.getFileOffsetShifted() + i);
                LengthStringSet lss = new LengthStringSet(reader);
                if (lss.getLength() == 0) break;
                list.add(lss);
                i += Conv.byteToInt((byte)lss.getLength()) + 1;
                reader.setPointerIndex(oldIndex);
                continue;
            }
            ++i;
        }
        this.strings = new LengthStringSet[list.size()];
        list.toArray(this.strings);
    }

    public LengthStringSet[] getStrings() {
        return this.strings;
    }
}

