/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.LoadCommand;
import ghidra.app.util.bin.format.macho.commands.LoadCommandString;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.flatapi.FlatProgramAPI;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class SubClientCommand
extends LoadCommand {
    private LoadCommandString client;

    static SubClientCommand createSubClientCommand(FactoryBundledWithBinaryReader reader) throws IOException {
        SubClientCommand clientCommand = (SubClientCommand)reader.getFactory().create(SubClientCommand.class, new Object[0]);
        clientCommand.initSubClientCommand(reader);
        return clientCommand;
    }

    private void initSubClientCommand(FactoryBundledWithBinaryReader reader) throws IOException {
        this.initLoadCommand(reader);
        this.client = LoadCommandString.createLoadCommandString(reader, this);
    }

    public String getClientName() {
        return this.client.getString();
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(this.getCommandName(), 0);
        struct.add(DWORD, "cmd", null);
        struct.add(DWORD, "cmdsize", null);
        struct.add(this.client.toDataType(), "client", null);
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }

    @Override
    public String getCommandName() {
        return "sub_client_command";
    }

    @Override
    public void markup(MachHeader header, FlatProgramAPI api, Address baseAddress, boolean isBinary, ProgramModule parentModule, TaskMonitor monitor, MessageLog log) {
        this.updateMonitor(monitor);
        if (isBinary) {
            try {
                this.createFragment(api, baseAddress, parentModule);
            }
            catch (Exception e) {
                log.appendException((Throwable)e);
            }
            Address addr = baseAddress.getNewAddress(this.getStartIndex());
            try {
                api.createData(addr, this.toDataType());
            }
            catch (Exception e) {
                log.appendMsg("Unable to create " + this.getCommandName() + " - " + e.getMessage());
            }
            try {
                int strLen = this.getCommandSize() - this.client.getOffset();
                Address strAddr = addr.add((long)this.client.getOffset());
                api.createAsciiString(strAddr, strLen);
            }
            catch (Exception e) {
                log.appendMsg("Unable to create load command string for " + this.getCommandName() + " - " + e.getMessage());
            }
        }
    }
}

