/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.tablechooser;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.action.ToolBarData;
import ghidra.app.nav.Navigatable;
import ghidra.app.nav.NavigatableRemovalListener;
import ghidra.app.services.GoToService;
import ghidra.app.tablechooser.AddressableRowObject;
import ghidra.app.tablechooser.ColumnDisplay;
import ghidra.app.tablechooser.TableChooserExecutor;
import ghidra.app.tablechooser.TableChooserTableModel;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import ghidra.util.table.GhidraThreadedTablePanel;
import ghidra.util.table.SelectionNavigationAction;
import ghidra.util.task.TaskMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import resources.ResourceManager;

public class TableChooserDialog
extends DialogComponentProvider
implements NavigatableRemovalListener {
    private final TableChooserExecutor executor;
    private Set<ExecutorSwingWorker> workers = new HashSet<ExecutorSwingWorker>();
    private GhidraTable table;
    private TableChooserTableModel model;
    private final Program program;
    private final PluginTool tool;
    private Navigatable navigatable;

    public TableChooserDialog(PluginTool tool, TableChooserExecutor executor, Program program, String title, Navigatable navigatable, boolean isModal) {
        super(title, isModal, true, true, true);
        this.tool = tool;
        this.executor = executor;
        this.program = program;
        this.navigatable = navigatable;
        this.addWorkPanel(this.buildMainPanel());
        if (executor != null) {
            this.addOKButton();
            this.setOkButtonText(executor.getButtonName());
        }
        this.addDismissButton();
        this.createActions();
        this.setOkEnabled(false);
    }

    public TableChooserDialog(PluginTool tool, TableChooserExecutor executor, Program program, String title, Navigatable navigatable) {
        this(tool, executor, program, title, navigatable, false);
    }

    private JPanel buildMainPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.createTableModel();
        GhidraThreadedTablePanel<AddressableRowObject> tablePanel = new GhidraThreadedTablePanel<AddressableRowObject>(this.model, 50, 2000);
        this.table = tablePanel.getTable();
        GoToService goToService = (GoToService)this.tool.getService(GoToService.class);
        if (goToService != null) {
            this.navigatable = this.navigatable == null ? goToService.getDefaultNavigatable() : this.navigatable;
            this.navigatable.addNavigatableListener(this);
            this.table.installNavigation(goToService, this.navigatable);
        }
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                TableChooserDialog.this.setOkEnabled(TableChooserDialog.this.table.getSelectedRowCount() > 0);
            }
        });
        GhidraTableFilterPanel filterPanel = new GhidraTableFilterPanel((JTable)((Object)this.table), this.model);
        panel.add((Component)((Object)tablePanel), "Center");
        panel.add((Component)((Object)filterPanel), "South");
        return panel;
    }

    public void add(AddressableRowObject rowObject) {
        this.model.addObject(rowObject);
    }

    private void createTableModel() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    TableChooserDialog.this.model = new TableChooserTableModel("Test", (ServiceProvider)TableChooserDialog.this.tool, TableChooserDialog.this.program, null);
                }
            });
        }
        catch (Exception e) {
            Msg.showError((Object)this, null, (String)"Error Creating Table", (Object)"Error Creating Table", (Throwable)e);
        }
    }

    private void createActions() {
        String owner = this.getClass().getSimpleName();
        DockingAction selectAction = new DockingAction("Make Selection", owner, false){

            public void actionPerformed(ActionContext context) {
                TableChooserDialog.this.makeSelection();
            }

            public boolean isEnabledForContext(ActionContext context) {
                return TableChooserDialog.this.table.getSelectedRowCount() != 0;
            }
        };
        selectAction.setDescription("Make a selection using selected rows");
        selectAction.setEnabled(true);
        ImageIcon icon = ResourceManager.loadImage((String)"images/text_align_justify.png");
        selectAction.setToolBarData(new ToolBarData((Icon)icon));
        selectAction.setPopupMenuData(new MenuData(new String[]{"Make Selection"}, (Icon)icon));
        selectAction.setHelpLocation(new HelpLocation("Search", "Make_Selection"));
        SelectionNavigationAction selectionNavigationAction = new SelectionNavigationAction(owner, this.table);
        selectionNavigationAction.setHelpLocation(new HelpLocation("Search", "Selection_Navigation"));
        this.addAction((DockingActionIf)selectAction);
        this.addAction((DockingActionIf)selectionNavigationAction);
    }

    private void makeSelection() {
        ProgramSelection selection = this.table.getProgramSelection();
        if (this.program == null || this.program.isClosed() || selection.getNumAddresses() == 0L) {
            return;
        }
        if (this.navigatable != null) {
            this.navigatable.goTo(this.program, new ProgramLocation(this.program, selection.getMinAddress()));
            this.navigatable.setSelection(selection);
            this.navigatable.requestFocus();
        }
    }

    public void show() {
        DockingWindowManager manager = DockingWindowManager.getActiveInstance();
        this.tool.showDialog((DialogComponentProvider)this, (Component)manager.getMainWindow());
    }

    public void close() {
        super.close();
        if (this.navigatable != null) {
            this.navigatable.removeNavigatableListener(this);
        }
    }

    protected void okCallback() {
        TaskMonitor monitor = this.showTaskMonitorComponent(this.executor.getButtonName(), true, true);
        try {
            ExecutorSwingWorker worker = new ExecutorSwingWorker(monitor);
            worker.execute();
            this.workers.add(worker);
        }
        finally {
            this.hideTaskMonitorComponent();
        }
    }

    public boolean isBusy() {
        ExecutorSwingWorker[] threadSafeArray;
        for (ExecutorSwingWorker worker : threadSafeArray = this.workers.toArray(new ExecutorSwingWorker[this.workers.size()])) {
            if (worker.isDone()) continue;
            return true;
        }
        return false;
    }

    private void doExecute(TaskMonitor monitor) {
        int[] selectedRows = this.table.getSelectedRows();
        monitor.initialize((long)selectedRows.length);
        ArrayList<AddressableRowObject> deletedRowObjects = new ArrayList<AddressableRowObject>();
        for (int selectedRow : selectedRows) {
            if (monitor.isCancelled()) {
                return;
            }
            AddressableRowObject rowObject = (AddressableRowObject)this.model.getRowObject(selectedRow);
            monitor.setMessage("Processing item at address " + rowObject.getAddress());
            if (this.executor.execute(rowObject)) {
                deletedRowObjects.add(rowObject);
            }
            monitor.incrementProgress(1L);
            this.table.repaint();
        }
        Object object = deletedRowObjects.iterator();
        while (object.hasNext()) {
            AddressableRowObject addressableRowObject = (AddressableRowObject)object.next();
            this.model.removeObject(addressableRowObject);
        }
        this.model.fireTableDataChanged();
        this.setStatusText("");
    }

    public void addCustomColumn(ColumnDisplay<?> columnDisplay) {
        this.model.addCustomColumn(columnDisplay);
    }

    @Override
    public void navigatableRemoved(Navigatable nav) {
        this.close();
    }

    public void setMessage(String message) {
        this.setStatusText(message);
    }

    public int getRowCount() {
        return this.model.getRowCount();
    }

    private class ExecutorSwingWorker
    extends SwingWorker<Object, Object> {
        private final TaskMonitor monitor;

        ExecutorSwingWorker(TaskMonitor monitor) {
            this.monitor = monitor;
        }

        @Override
        protected Object doInBackground() throws Exception {
            TableChooserDialog.this.doExecute(this.monitor);
            return null;
        }

        @Override
        protected void done() {
            TableChooserDialog.this.workers.remove(this);
        }
    }
}

