/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.table;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.ComponentProviderActivationListener;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.action.ToolBarData;
import docking.widgets.table.AbstractSortedTableModel;
import docking.widgets.table.GTable;
import docking.widgets.table.threaded.GThreadedTablePanel;
import ghidra.app.nav.Navigatable;
import ghidra.app.nav.NavigatableRemovalListener;
import ghidra.app.plugin.core.table.TableServicePlugin;
import ghidra.app.services.GoToService;
import ghidra.app.services.MarkerListener;
import ghidra.app.services.MarkerService;
import ghidra.app.services.MarkerSet;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.Plugin;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.BytesFieldLocation;
import ghidra.program.util.MarkerLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.SystemUtilities;
import ghidra.util.table.DeleteTableRowAction;
import ghidra.util.table.GhidraProgramTableModel;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import ghidra.util.table.GhidraThreadedTablePanel;
import ghidra.util.table.SelectionNavigationAction;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import resources.ResourceManager;

public class TableComponentProvider<T>
extends ComponentProviderAdapter
implements TableModelListener,
NavigatableRemovalListener,
OptionsChangeListener {
    private JPanel componentPanel;
    private GhidraThreadedTablePanel<T> threadedPanel;
    private GhidraTableFilterPanel<T> tableFilterPanel;
    private TableServicePlugin tableServicePlugin;
    private Program program;
    private GhidraProgramTableModel<T> model;
    private MarkerSet markerSet;
    private MarkerService markerService;
    private String programName;
    private String windowSubMenu;
    private List<ComponentProviderActivationListener> activationListenerList = new ArrayList<ComponentProviderActivationListener>();
    private Navigatable navigatable;
    private SelectionNavigationAction selectionNavigationAction;
    private DockingAction selectAction;
    private DockingAction removeItemsAction;
    private HelpLocation helpLoc = new HelpLocation("Search", "Query_Results");

    TableComponentProvider(TableServicePlugin plugin, String title, String name, GhidraProgramTableModel<T> model, String programName, GoToService gotoService, String windowSubMenu, Navigatable navigatable) {
        this(plugin, title, name, model, programName, gotoService, null, null, null, windowSubMenu, navigatable);
    }

    TableComponentProvider(TableServicePlugin plugin, String title, String name, GhidraProgramTableModel<T> model, String programName, GoToService gotoService, MarkerService markerService, Color markerColor, ImageIcon markerIcon, String windowSubMenu, Navigatable navigatable) {
        super(plugin.getTool(), name, plugin.getName());
        this.tableServicePlugin = plugin;
        this.navigatable = navigatable;
        this.program = plugin.getProgram();
        this.model = model;
        this.programName = programName;
        this.markerService = markerService;
        this.windowSubMenu = windowSubMenu;
        this.setIcon(ResourceManager.loadImage((String)"images/magnifier.png"));
        this.setTransient();
        this.setTitle(title);
        this.setHelpLocation(this.helpLoc);
        this.componentPanel = this.buildMainPanel(model, gotoService);
        this.addToTool();
        this.setVisible(true);
        this.updateTitle();
        this.createActions(plugin);
        if (markerService != null) {
            this.markerSet = markerService.createPointMarker(name, title, this.program, 75, true, true, false, markerColor, markerIcon);
            this.markerSet.setNavigationListener(new MarkerListener(){

                @Override
                public ProgramLocation getProgramLocation(MarkerLocation loc) {
                    return new BytesFieldLocation(TableComponentProvider.this.program, loc.getAddr());
                }

                @Override
                public String getTooltip(MarkerLocation loc) {
                    return null;
                }

                @Override
                public ImageIcon getIcon(MarkerLocation loc) {
                    return null;
                }
            });
            markerService.removeMarker(this.markerSet, this.program);
            this.loadMarkers();
            model.addTableModelListener(this);
        }
    }

    private JPanel buildMainPanel(GhidraProgramTableModel<T> tableModel, GoToService gotoService) {
        JPanel panel = new JPanel(new BorderLayout());
        this.threadedPanel = new GhidraThreadedTablePanel(tableModel);
        GhidraTable table = this.threadedPanel.getTable();
        table.getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.tool.contextChanged((ComponentProvider)this);
        });
        table.setActionsEnabled(this.navigatable.isConnected());
        if (gotoService != null) {
            if (this.navigatable != null) {
                this.navigatable.addNavigatableListener(this);
            }
            table.installNavigation(gotoService, this.navigatable);
        }
        panel.add((Component)((Object)this.threadedPanel), "Center");
        panel.add((Component)this.createFilterFieldPanel((JTable)((Object)table), (AbstractSortedTableModel<T>)tableModel), "South");
        return panel;
    }

    private void createActions(final Plugin plugin) {
        this.selectAction = new DockingAction("Make Selection", this.tableServicePlugin.getName(), false){

            public void actionPerformed(ActionContext context) {
                TableComponentProvider.this.makeSelection(plugin);
            }

            public boolean isEnabledForContext(ActionContext context) {
                GhidraTable table = TableComponentProvider.this.threadedPanel.getTable();
                return table.getSelectedRowCount() > 0;
            }
        };
        this.selectAction.setDescription("Make a selection using selected rows");
        this.selectAction.setEnabled(false);
        ImageIcon icon = ResourceManager.loadImage((String)"images/text_align_justify.png");
        this.selectAction.setToolBarData(new ToolBarData((Icon)icon, null));
        this.selectAction.setPopupMenuData(new MenuData(new String[]{"Make Selection"}, (Icon)icon, null));
        this.selectAction.setHelpLocation(new HelpLocation("Search", "Make_Selection"));
        this.selectionNavigationAction = new SelectionNavigationAction(plugin, this.threadedPanel.getTable());
        this.selectionNavigationAction.setHelpLocation(new HelpLocation("Search", "Selection_Navigation"));
        DockingAction externalGotoAction = new DockingAction("Go to External Location", this.getName(), false){

            public void actionPerformed(ActionContext context) {
                TableComponentProvider.this.gotoExternalAddress(this.getSlectedExternalAddress());
            }

            public boolean isEnabledForContext(ActionContext context) {
                return this.getSlectedExternalAddress() != null && TableComponentProvider.this.tool.getService(GoToService.class) != null;
            }

            private Address getSlectedExternalAddress() {
                GhidraTable table = TableComponentProvider.this.threadedPanel.getTable();
                if (table.getSelectedRowCount() != 1) {
                    return null;
                }
                ProgramSelection selection = TableComponentProvider.this.threadedPanel.getTable().getProgramSelection();
                Program modelProgram = TableComponentProvider.this.model.getProgram();
                if (modelProgram == null || selection.getNumAddresses() != 1L) {
                    return null;
                }
                Address addr = selection.getMinAddress();
                return addr.isExternalAddress() ? addr : null;
            }
        };
        externalGotoAction.setDescription("Go to an external location");
        externalGotoAction.setEnabled(false);
        icon = ResourceManager.loadImage((String)"images/searchm_obj.gif");
        externalGotoAction.setPopupMenuData(new MenuData(new String[]{"GoTo External Location"}, (Icon)icon, null));
        externalGotoAction.setHelpLocation(new HelpLocation("Search", "Navigation"));
        this.configureKeybinding(this.selectAction, null);
        plugin.getTool().addLocalAction((ComponentProvider)this, (DockingActionIf)this.selectAction);
        plugin.getTool().addLocalAction((ComponentProvider)this, (DockingActionIf)this.selectionNavigationAction);
        plugin.getTool().addLocalAction((ComponentProvider)this, (DockingActionIf)externalGotoAction);
    }

    public void installRemoveItemsAction() {
        if (this.removeItemsAction != null) {
            return;
        }
        GhidraTable table = this.threadedPanel.getTable();
        this.removeItemsAction = new DeleteTableRowAction(this.tool, table, this.tableServicePlugin.getName());
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.removeItemsAction);
    }

    private void configureKeybinding(DockingAction action, KeyStroke keyBinding) {
        ToolOptions options = this.tool.getOptions("Key Bindings");
        KeyStroke keyStroke = options.getKeyStroke(action.getName() + " (Tool)", keyBinding);
        if (!SystemUtilities.isEqual((Object)keyBinding, (Object)keyStroke)) {
            action.setUnvalidatedKeyBindingData(new KeyBindingData(keyStroke));
        } else {
            action.setKeyBindingData(new KeyBindingData(keyStroke));
        }
        options.removeOptionsChangeListener((OptionsChangeListener)this);
        options.addOptionsChangeListener((OptionsChangeListener)this);
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        if (optionName.startsWith("Make Selection")) {
            KeyStroke keyStroke = (KeyStroke)newValue;
            this.selectAction.setUnvalidatedKeyBindingData(new KeyBindingData(keyStroke));
        }
    }

    private JPanel createFilterFieldPanel(JTable table, AbstractSortedTableModel<T> sortedModel) {
        this.tableFilterPanel = new GhidraTableFilterPanel<T>(table, sortedModel);
        this.tableFilterPanel.setToolTipText("Filter search results");
        return this.tableFilterPanel;
    }

    private String generateSubTitle() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("(");
        buffer.append(this.programName);
        buffer.append(") ");
        int n = this.model.getRowCount();
        if (n == 1) {
            buffer.append("    (1 entry)");
        } else if (n > 1) {
            buffer.append("    (" + n + " entries)");
        }
        return buffer.toString();
    }

    private void loadMarkers() {
        if (this.markerSet == null) {
            return;
        }
        this.markerSet.clearAll();
        int n = this.model.getRowCount();
        for (int i = 0; i < n; ++i) {
            ProgramLocation loc = this.model.getProgramLocation(i, 0);
            if (loc == null) continue;
            this.markerSet.add(loc.getByteAddress());
        }
        this.markerService.setMarkerForGroup("HIGHLIGHT_GROUP", this.markerSet, this.program);
    }

    private void gotoExternalAddress(Address extAddr) {
        GoToService gotoSvc = (GoToService)this.tool.getService(GoToService.class);
        if (gotoSvc != null) {
            gotoSvc.goTo(extAddr, this.model.getProgram());
        }
    }

    private void makeSelection(Plugin plugin) {
        ProgramSelection selection = this.threadedPanel.getTable().getProgramSelection();
        Program modelProgram = this.model.getProgram();
        if (modelProgram == null || selection.getNumAddresses() == 0L) {
            return;
        }
        this.navigatable.goTo(this.model.getProgram(), new ProgramLocation(modelProgram, selection.getMinAddress()));
        this.navigatable.setSelection(selection);
        this.navigatable.requestFocus();
    }

    public void closeComponent() {
        if (this.navigatable != null) {
            this.navigatable.removeNavigatableListener(this);
        }
        this.tool.removeComponentProvider((ComponentProvider)this);
        this.tableServicePlugin.remove(this);
        this.model.dispose();
        if (this.markerSet != null) {
            this.markerSet.clearAll();
            this.markerService.removeMarker(this.markerSet, this.program);
        }
        this.tableServicePlugin = null;
        this.threadedPanel.dispose();
        this.tableFilterPanel.dispose();
    }

    public GThreadedTablePanel<T> getThreadedTablePanel() {
        return this.threadedPanel;
    }

    public JComponent getComponent() {
        return this.componentPanel;
    }

    public void refresh() {
        GhidraTable threadedTable = this.threadedPanel.getTable();
        int rowCount = threadedTable.getRowCount();
        if (rowCount == 0) {
            return;
        }
        boolean wasEnabled = this.selectionNavigationAction.setEnabled(false);
        int[] selectedRows = threadedTable.getSelectedRows();
        this.model.refresh();
        this.restoreSelection(threadedTable, selectedRows);
        this.selectionNavigationAction.setEnabled(wasEnabled);
    }

    private void restoreSelection(GTable threadedTable, int[] selectedRows) {
        if (selectedRows.length == 0) {
            return;
        }
        int start = selectedRows[0];
        int end = selectedRows[0];
        for (int row : selectedRows) {
            if (row > end + 1) {
                threadedTable.addRowSelectionInterval(start, end);
                start = row;
            }
            end = row;
        }
        threadedTable.addRowSelectionInterval(start, end);
    }

    @Override
    public void tableChanged(TableModelEvent ev) {
        this.updateTitle();
        this.loadMarkers();
    }

    public GhidraProgramTableModel<T> getModel() {
        return this.model;
    }

    private void updateTitle() {
        this.setSubTitle(this.generateSubTitle());
    }

    public void addActivationListener(ComponentProviderActivationListener listener) {
        this.activationListenerList.add(listener);
    }

    public void removeActivationListener(ComponentProviderActivationListener listener) {
        this.activationListenerList.remove(listener);
    }

    public void componentActivated() {
        this.loadMarkers();
        for (ComponentProviderActivationListener listener : this.activationListenerList) {
            listener.componentProviderActivated((ComponentProvider)this);
        }
    }

    public void componentDeactived() {
        for (ComponentProviderActivationListener listener : this.activationListenerList) {
            listener.componentProviderDeactivated((ComponentProvider)this);
        }
    }

    public String getWindowSubMenuName() {
        return this.windowSubMenu;
    }

    @Override
    public void navigatableRemoved(Navigatable removedNavigatable) {
        removedNavigatable.removeNavigatableListener(this);
        this.closeComponent();
    }

    public ActionContext getActionContext(MouseEvent event) {
        return new ActionContext((ComponentProvider)this, (Object)this.threadedPanel.getTable());
    }
}

