/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.strings;

import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.app.plugin.core.string.translate.ManualStringTranslationService;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.AbstractStringDataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.StringDataInstance;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.util.DefinedDataIterator;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.StringUtilities;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.AddressBasedTableModel;
import ghidra.util.table.column.AbstractGColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import ghidra.util.table.field.AbstractProgramLocationTableColumn;
import ghidra.util.table.field.AddressBasedLocation;
import ghidra.util.task.TaskMonitor;
import java.util.HashMap;
import java.util.Map;

class ViewStringsTableModel
extends AddressBasedTableModel<ProgramLocation> {
    private Map<Address, ProgramLocation> rowsIndexedByAddress = new HashMap<Address, ProgramLocation>();

    ViewStringsTableModel(PluginTool tool) {
        super("Defined String Table", (ServiceProvider)tool, null, null);
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        DynamicTableColumn column = this.getColumn(columnIndex);
        return column instanceof StringRepColumn;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        DynamicTableColumn column = this.getColumn(columnIndex);
        if (column instanceof StringRepColumn) {
            ProgramLocation progLoc = (ProgramLocation)this.getRowObject(rowIndex);
            ManualStringTranslationService.setTranslatedValue(this.program, progLoc, aValue.toString());
        }
    }

    @Override
    protected TableColumnDescriptor<ProgramLocation> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn((DynamicTableColumn)new DataLocationColumn(), 1, true);
        descriptor.addVisibleColumn((DynamicTableColumn)new DataValueColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new StringRepColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new DataTypeColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new IsAsciiColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new CharsetColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new HasEncodingErrorColumn());
        return descriptor;
    }

    protected void doLoad(Accumulator<ProgramLocation> accumulator, TaskMonitor monitor) throws CancelledException {
        this.rowsIndexedByAddress.clear();
        Program localProgram = this.getProgram();
        if (localProgram == null) {
            return;
        }
        Listing listing = localProgram.getListing();
        monitor.setCancelEnabled(true);
        monitor.initialize((long)((int)listing.getNumDefinedData()));
        for (Data stringInstance : DefinedDataIterator.definedStrings((Program)localProgram)) {
            accumulator.add((Object)this.createIndexedStringInstanceLocation(localProgram, stringInstance));
            monitor.checkCanceled();
            monitor.incrementProgress(1L);
        }
    }

    private ProgramLocation createIndexedStringInstanceLocation(Program localProgram, Data data) {
        ProgramLocation pl = new ProgramLocation(localProgram, data.getMinAddress(), data.getComponentPath(), null, 0, 0, 0);
        this.rowsIndexedByAddress.put(data.getMinAddress(), pl);
        return pl;
    }

    public void removeDataInstanceAt(Address addr) {
        ProgramLocation progLoc = this.rowsIndexedByAddress.get(addr);
        if (progLoc != null) {
            this.removeObject(progLoc);
        }
    }

    public ProgramLocation findEquivProgramLocation(ProgramLocation pl) {
        return pl != null ? this.rowsIndexedByAddress.get(pl.getAddress()) : null;
    }

    public void addDataInstance(Program localProgram, Data data, TaskMonitor monitor) {
        for (Data stringInstance : DefinedDataIterator.definedStrings((Data)data)) {
            this.addObject(this.createIndexedStringInstanceLocation(localProgram, stringInstance));
        }
    }

    @Override
    public ProgramSelection getProgramSelection(int[] rows) {
        AddressSet set = new AddressSet();
        for (int element : rows) {
            ProgramLocation progLoc = (ProgramLocation)this.filteredData.get(element);
            Data data = this.getProgram().getListing().getDataContaining(progLoc.getAddress());
            data = data.getComponent(progLoc.getComponentPath());
            set.addRange(data.getMinAddress(), data.getMaxAddress());
        }
        return new ProgramSelection((AddressSetView)set);
    }

    public void reload(Program newProgram) {
        this.setProgram(newProgram);
        this.reload();
    }

    @Override
    public Address getAddress(int row) {
        return ((ProgramLocation)this.getRowObject(row)).getAddress();
    }

    private static class CharsetColumn
    extends AbstractProgramLocationTableColumn<ProgramLocation, String> {
        private CharsetColumn() {
        }

        public String getColumnName() {
            return "Charset";
        }

        public String getValue(ProgramLocation rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            Data data = DataUtilities.getDataAtLocation((ProgramLocation)rowObject);
            return StringDataInstance.getStringDataInstance((Data)data).getCharsetName();
        }

        @Override
        public ProgramLocation getProgramLocation(ProgramLocation rowObject, Settings settings, Program program, ServiceProvider serviceProvider) {
            return rowObject;
        }
    }

    private static class HasEncodingErrorColumn
    extends AbstractProgramLocationTableColumn<ProgramLocation, Boolean> {
        private HasEncodingErrorColumn() {
        }

        public String getColumnName() {
            return "Has Encoding Error";
        }

        public Boolean getValue(ProgramLocation rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            Data data = DataUtilities.getDataAtLocation((ProgramLocation)rowObject);
            String s = StringDataInstance.getStringDataInstance((Data)data).getStringValue();
            return s != null && s.chars().anyMatch(codePoint -> StringUtilities.isUnicodeReplacementCodePoint((int)codePoint));
        }

        @Override
        public ProgramLocation getProgramLocation(ProgramLocation rowObject, Settings settings, Program program, ServiceProvider serviceProvider) {
            return rowObject;
        }
    }

    private static class IsAsciiColumn
    extends AbstractProgramLocationTableColumn<ProgramLocation, Boolean> {
        private IsAsciiColumn() {
        }

        public String getColumnName() {
            return "Is Ascii";
        }

        public Boolean getValue(ProgramLocation rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            Data data = DataUtilities.getDataAtLocation((ProgramLocation)rowObject);
            String s = StringDataInstance.getStringDataInstance((Data)data).getStringValue();
            return s != null && s.codePoints().allMatch(codePoint -> 0 <= codePoint && codePoint < 128);
        }

        @Override
        public ProgramLocation getProgramLocation(ProgramLocation rowObject, Settings settings, Program program, ServiceProvider serviceProvider) {
            return rowObject;
        }
    }

    private static class DataTypeColumn
    extends AbstractProgramLocationTableColumn<ProgramLocation, String> {
        private DataTypeColumn() {
        }

        public String getColumnName() {
            return "Data Type";
        }

        public String getValue(ProgramLocation rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            Data data = DataUtilities.getDataAtLocation((ProgramLocation)rowObject);
            if (data == null) {
                return "";
            }
            return data.getDataType() instanceof AbstractStringDataType ? data.getDataType().getMnemonic(settings) : data.getDataType().getName();
        }

        @Override
        public ProgramLocation getProgramLocation(ProgramLocation rowObject, Settings settings, Program program, ServiceProvider serviceProvider) {
            return rowObject;
        }
    }

    private static class StringRepColumn
    extends AbstractProgramLocationTableColumn<ProgramLocation, StringDataInstance> {
        private StringRepCellRenderer renderer = new StringRepCellRenderer();

        private StringRepColumn() {
        }

        public String getColumnName() {
            return "String Representation";
        }

        public StringDataInstance getValue(ProgramLocation rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            Data data = DataUtilities.getDataAtLocation((ProgramLocation)rowObject);
            if (StringDataInstance.isString((Data)data)) {
                StringDataInstance sdi = StringDataInstance.getStringDataInstance((Data)data);
                return sdi;
            }
            return null;
        }

        @Override
        public ProgramLocation getProgramLocation(ProgramLocation rowObject, Settings settings, Program program, ServiceProvider serviceProvider) {
            return rowObject;
        }

        public GColumnRenderer<StringDataInstance> getColumnRenderer() {
            return this.renderer;
        }

        private class StringRepCellRenderer
        extends AbstractGColumnRenderer<StringDataInstance> {
            private StringRepCellRenderer() {
            }

            protected String getText(Object value) {
                if (value instanceof StringDataInstance) {
                    return ((StringDataInstance)value).getStringRepresentation();
                }
                return "";
            }

            public String getFilterString(StringDataInstance t, Settings settings) {
                return this.getText(t);
            }
        }
    }

    private static class DataValueColumn
    extends AbstractProgramLocationTableColumn<ProgramLocation, StringDataInstance> {
        private DataValueCellRenderer renderer = new DataValueCellRenderer();

        private DataValueColumn() {
        }

        public String getColumnName() {
            return "String Value";
        }

        public StringDataInstance getValue(ProgramLocation rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return StringDataInstance.getStringDataInstance((Data)DataUtilities.getDataAtLocation((ProgramLocation)rowObject));
        }

        @Override
        public ProgramLocation getProgramLocation(ProgramLocation rowObject, Settings settings, Program program, ServiceProvider serviceProvider) {
            return rowObject;
        }

        public GColumnRenderer<StringDataInstance> getColumnRenderer() {
            return this.renderer;
        }

        private class DataValueCellRenderer
        extends AbstractGColumnRenderer<StringDataInstance> {
            private DataValueCellRenderer() {
            }

            protected String getText(Object value) {
                if (value instanceof StringDataInstance) {
                    return ((StringDataInstance)value).toString();
                }
                return "";
            }

            public String getFilterString(StringDataInstance t, Settings settings) {
                return this.getText(t);
            }
        }
    }

    private static class DataLocationColumn
    extends AbstractProgramLocationTableColumn<ProgramLocation, AddressBasedLocation> {
        private DataLocationColumn() {
        }

        public String getColumnName() {
            return "Location";
        }

        public AddressBasedLocation getValue(ProgramLocation rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return new AddressBasedLocation(rowObject.getProgram(), rowObject.getAddress());
        }

        @Override
        public ProgramLocation getProgramLocation(ProgramLocation rowObject, Settings settings, Program program, ServiceProvider serviceProvider) {
            return rowObject;
        }
    }

    public static enum COLUMNS {
        ADDRESS_COL,
        STRING_VALUE_COL,
        STRING_REP_COL,
        DATA_TYPE_COL,
        IS_ASCII_COL,
        CHARSET_COL,
        HAS_ENCODING_ERROR;

    }
}

