/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.searchmem;

import ghidra.app.plugin.core.searchmem.SearchData;
import ghidra.app.plugin.core.searchmem.SearchFormat;
import ghidra.util.StringUtilities;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AsciiSearchFormat
extends SearchFormat {
    private JLabel searchType;
    private JComboBox<Charset> encodingCB;
    private JCheckBox caseSensitiveCkB;
    private JCheckBox escapeSequencesCkB;
    private Charset[] supportedCharsets = new Charset[]{StandardCharsets.US_ASCII, StandardCharsets.UTF_8, StandardCharsets.UTF_16};

    public AsciiSearchFormat(ChangeListener listener) {
        super("String", listener);
    }

    @Override
    public String getToolTip() {
        return "Interpret value as a sequence of characters.";
    }

    @Override
    public JPanel getOptionsPanel() {
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AsciiSearchFormat.this.changeListener.stateChanged(new ChangeEvent(this));
            }
        };
        this.searchType = new JLabel("Encoding: ");
        this.encodingCB = new JComboBox<Charset>(this.supportedCharsets);
        this.encodingCB.setName("Encoding Options");
        this.encodingCB.setSelectedIndex(0);
        this.encodingCB.addActionListener(al);
        this.caseSensitiveCkB = new JCheckBox("Case Sensitive");
        this.caseSensitiveCkB.setToolTipText("Allows for case sensitive searching.");
        this.caseSensitiveCkB.addActionListener(al);
        this.escapeSequencesCkB = new JCheckBox("Escape Sequences");
        this.escapeSequencesCkB.setToolTipText("Allows specifying control characters using escape sequences (i.e., allows \\n to be searched for as a single line feed character).");
        this.escapeSequencesCkB.addActionListener(al);
        JPanel stringOptionsPanel = new JPanel();
        stringOptionsPanel.setLayout(new BoxLayout(stringOptionsPanel, 1));
        stringOptionsPanel.setBorder(new TitledBorder("Format Options"));
        JPanel encodingOptionsPanel = new JPanel(new FlowLayout(0));
        encodingOptionsPanel.add(this.searchType);
        encodingOptionsPanel.add(this.encodingCB);
        stringOptionsPanel.add(encodingOptionsPanel);
        JPanel caseSensitivePanel = new JPanel(new FlowLayout(0));
        caseSensitivePanel.add(this.caseSensitiveCkB);
        stringOptionsPanel.add(caseSensitivePanel);
        JPanel escapeSequencesPanel = new JPanel(new FlowLayout(0));
        escapeSequencesPanel.add(this.escapeSequencesCkB);
        stringOptionsPanel.add(escapeSequencesPanel);
        return stringOptionsPanel;
    }

    @Override
    public boolean usesEndieness() {
        return this.encodingCB.getSelectedItem() == StandardCharsets.UTF_16;
    }

    @Override
    public SearchData getSearchData(String input) {
        int MASK_BYTE = -33;
        int inputLength = input.length();
        Charset encodingSelection = (Charset)this.encodingCB.getSelectedItem();
        if (encodingSelection == StandardCharsets.UTF_16) {
            Charset charset = encodingSelection = this.isBigEndian ? StandardCharsets.UTF_16BE : StandardCharsets.UTF_16LE;
        }
        if (this.escapeSequencesCkB.isSelected() && inputLength >= 2) {
            input = StringUtilities.convertEscapeSequences((String)input);
        }
        byte[] byteArray = input.getBytes(encodingSelection);
        byte[] maskArray = new byte[byteArray.length];
        Arrays.fill(maskArray, (byte)-1);
        if (!this.caseSensitiveCkB.isSelected()) {
            int i = 0;
            while (i < byteArray.length) {
                if (encodingSelection == StandardCharsets.US_ASCII && Character.isLetter(byteArray[i])) {
                    maskArray[i] = -33;
                    ++i;
                    continue;
                }
                if (encodingSelection == StandardCharsets.UTF_8) {
                    int numBytes = this.bytesPerCharUTF8(byteArray[i]);
                    if (numBytes == 1 && Character.isLetter(byteArray[i])) {
                        maskArray[i] = -33;
                    }
                    i += numBytes;
                    continue;
                }
                if (encodingSelection == StandardCharsets.UTF_16BE) {
                    if (byteArray[i] == 0 && Character.isLetter(byteArray[i + 1])) {
                        maskArray[i + 1] = -33;
                    }
                    i += 2;
                    continue;
                }
                if (encodingSelection == StandardCharsets.UTF_16LE) {
                    if (byteArray[i + 1] == 0 && Character.isLetter(byteArray[i])) {
                        maskArray[i] = -33;
                    }
                    i += 2;
                    continue;
                }
                ++i;
            }
        }
        return SearchData.createSearchData(input, byteArray, maskArray);
    }

    private int bytesPerCharUTF8(byte zByte) {
        int offset = 1;
        while ((zByte & 0x80) != 0) {
            zByte = (byte)(zByte << 1);
            ++offset;
        }
        return offset;
    }
}

