/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation.locationreferences;

import docking.action.MenuData;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.navigation.locationreferences.LocationReferencesPlugin;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.util.AddressFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;

public class FindReferencesToAddressAction
extends ListingContextAction {
    private LocationReferencesPlugin plugin;

    public FindReferencesToAddressAction(LocationReferencesPlugin plugin, int subGroupPosition) {
        super("Show References to Address", plugin.getName(), false);
        this.plugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"References", "Show References to Address"}, null, "ShowReferencesTo", -1, Integer.toString(subGroupPosition)));
        this.setDescription("Shows references to the current Instruction or Data");
        this.setHelpLocation(new HelpLocation(plugin.getName(), "Show_Refs_To_Code_Unit"));
    }

    @Override
    public void actionPerformed(ListingActionContext context) {
        Program program = context.getProgram();
        ProgramLocation location = context.getLocation();
        Address address = location.getAddress();
        Listing listing = program.getListing();
        CodeUnit cu = listing.getCodeUnitContaining(address);
        int[] path = location.getComponentPath();
        if (cu instanceof Data) {
            Data outerData = (Data)cu;
            Data data = outerData.getComponent(location.getComponentPath());
            address = data.getMinAddress();
        }
        AddressFieldLocation addressLocation = new AddressFieldLocation(program, address, path, address.toString(), 0);
        this.plugin.showReferencesToLocation((ProgramLocation)addressLocation, context.getNavigatable());
    }

    @Override
    protected boolean isEnabledForContext(ListingActionContext context) {
        Program program = context.getProgram();
        ProgramLocation location = context.getLocation();
        Address address = location.getAddress();
        if (address == null) {
            return false;
        }
        Listing listing = program.getListing();
        CodeUnit cu = listing.getCodeUnitContaining(address);
        return cu != null;
    }
}

