/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.memory;

import ghidra.app.plugin.core.clear.ClearCmd;
import ghidra.app.plugin.core.clear.ClearOptions;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.exception.RollbackException;
import ghidra.util.task.TaskMonitor;

public class UninitializedBlockCmd
extends BackgroundCommand {
    private MemoryBlock block;
    private Program program;

    public UninitializedBlockCmd(Program program, MemoryBlock block) {
        super("Unitialize Memory Block", false, true, true);
        this.program = program;
        this.block = block;
    }

    public boolean applyTo(DomainObject obj, TaskMonitor monitor) throws RuntimeException {
        ClearOptions clearOptions = new ClearOptions(false);
        clearOptions.setClearCode(true);
        clearOptions.setClearDefaultReferences(true);
        clearOptions.setClearFunctions(true);
        clearOptions.setClearAnalysisReferences(true);
        clearOptions.setClearImportReferences(true);
        clearOptions.setClearUserReferences(true);
        ClearCmd clearCmd = new ClearCmd((AddressSetView)new AddressSet(this.block.getStart(), this.block.getEnd()), clearOptions);
        if (!clearCmd.applyTo((DomainObject)this.program, monitor)) {
            this.setStatusMsg(clearCmd.getStatusMsg());
            return false;
        }
        if (monitor.isCancelled()) {
            throw new RollbackException("Operation cancelled");
        }
        try {
            this.program.getMemory().convertToUninitialized(this.block);
        }
        catch (Exception e) {
            this.setStatusMsg(e.getMessage());
            return false;
        }
        return true;
    }
}

