/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.label;

import docking.DialogComponentProvider;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.label.LabelHistoryDialog;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.LabelHistory;
import ghidra.program.util.OperandFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.Msg;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class LabelHistoryAction
extends ListingContextAction {
    private final PluginTool tool;

    public LabelHistoryAction(PluginTool tool, String owner) {
        super("Show Label History", owner);
        this.tool = tool;
        this.setPopupMenuData(new MenuData(new String[]{"Show Label History..."}, null, "Label"));
        this.setKeyBindingData(new KeyBindingData(72, 0));
    }

    @Override
    protected boolean isEnabledForContext(ListingActionContext context) {
        return context.getAddress() != null;
    }

    @Override
    protected void actionPerformed(ListingActionContext context) {
        List<LabelHistory> list;
        Address a;
        Address addr = context.getAddress();
        ProgramLocation location = context.getLocation();
        if (location instanceof OperandFieldLocation && (a = ((OperandFieldLocation)location).getRefAddress()) != null) {
            addr = a;
        }
        if ((list = this.getHistoryList(context.getProgram(), addr)).size() > 0) {
            LabelHistoryDialog dialog = new LabelHistoryDialog(this.tool, context.getProgram(), addr, this.getHistoryList(context.getProgram(), addr));
            this.tool.showDialog((DialogComponentProvider)dialog);
        } else {
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)this.tool.getToolFrame(), (String)"History Not Found", (Object)("No Label History was found at address: " + addr));
        }
    }

    private List<LabelHistory> getHistoryList(Program program, Address addr) {
        ArrayList<LabelHistory> list = new ArrayList<LabelHistory>();
        LabelHistory[] history = program.getSymbolTable().getLabelHistory(addr);
        for (int i = 0; i < history.length; ++i) {
            list.add(history[i]);
        }
        return list;
    }
}

