/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functioncompare;

import docking.ActionContext;
import docking.DockingUtils;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ProgramActionContext;
import ghidra.app.context.ProgramContextAction;
import ghidra.app.plugin.core.functioncompare.FunctionComparisonPlugin;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.util.ArrayList;

public class CompareFunctionsAction
extends ProgramContextAction {
    FunctionComparisonPlugin functionComparisonPlugin;

    CompareFunctionsAction(FunctionComparisonPlugin plugin) {
        super("Compare Two Functions", plugin.getName());
        this.functionComparisonPlugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"Compare Selected Functions..."}, null, "Function", -1, "Z_End"));
        this.setKeyBindingData(new KeyBindingData(70, DockingUtils.CONTROL_KEY_MODIFIER_MASK | 0x40));
        this.setHelpLocation(new HelpLocation("FunctionComparison", "Compare_Selected_Functions"));
    }

    @Override
    public boolean isAddToPopup(ActionContext context) {
        return context instanceof ListingActionContext;
    }

    @Override
    protected boolean isEnabledForContext(ProgramActionContext context) {
        return context instanceof ListingActionContext;
    }

    @Override
    public void actionPerformed(ProgramActionContext context) {
        if (context instanceof ListingActionContext) {
            ListingActionContext listingContext = (ListingActionContext)context;
            ProgramSelection selection = listingContext.getSelection();
            Program program = listingContext.getProgram();
            FunctionManager functionManager = program.getFunctionManager();
            ArrayList<Function> functionList = new ArrayList<Function>();
            FunctionIterator functionIter = functionManager.getFunctions((AddressSetView)selection, true);
            for (Function selectedFunction : functionIter) {
                functionList.add(selectedFunction);
            }
            Function[] functions = functionList.toArray(new Function[functionList.size()]);
            if (functions.length < 2) {
                String message = "You must select at least two functions in the current program.";
                Msg.showError((Object)((Object)this), null, (String)"Compare Functions", (Object)message);
                return;
            }
            this.functionComparisonPlugin.showFunctionComparisonProvider(functions);
        }
    }
}

