/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.disassembler;

import ghidra.app.cmd.function.CreateFunctionCmd;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.plugin.core.clear.ClearFlowAndRepairCmd;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.InjectPayload;
import ghidra.program.model.lang.InjectPayloadCallfixup;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.PcodeInjectLibrary;
import ghidra.program.model.listing.FlowOverride;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorAdapter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class CallFixupAnalyzer
extends AbstractAnalyzer {
    private static final String DESCRIPTION = "Installs Call-Fixups defined by the compiler specification and fixes any functions calling Non-Returning or CallFixup Functions";
    private static final String NAME = "Call-Fixup Installer";
    private static LanguageID cachedLanguageId;
    private static CompilerSpecID cachedSpecId;
    private static Map<String, String> cachedTargetFixupMap;
    private static String lastPrimaryStatusMessage;

    public CallFixupAnalyzer() {
        this(NAME, AnalyzerType.FUNCTION_ANALYZER, true);
    }

    public CallFixupAnalyzer(String name, AnalyzerType analyzerType, boolean supportsOneTimeAnalysis) {
        super(name, DESCRIPTION, analyzerType);
        this.setPriority(AnalysisPriority.DISASSEMBLY.after().after());
        this.setDefaultEnablement(true);
        if (supportsOneTimeAnalysis) {
            this.setSupportsOneTimeAnalysis();
        }
    }

    @Override
    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        AutoAnalysisManager analysisMgr = AutoAnalysisManager.getAnalysisManager(program);
        Map<String, String> targetFixupMap = this.getTargetFixupMap(program);
        AddressSet codeChangeSet = new AddressSet();
        AddressSet funcsToFixupSet = new AddressSet();
        AddressSet protectedLocs = new AddressSet();
        AddressSet repairedCallLocations = new AddressSet();
        HashSet<Function> nonFixedFuncs = new HashSet<Function>();
        FunctionIterator functionIter = program.getFunctionManager().getFunctions(set, true);
        while (functionIter.hasNext()) {
            boolean mustFix;
            monitor.checkCanceled();
            Function function = (Function)functionIter.next();
            String fixupName = this.getCallFixupNameForFunction(targetFixupMap, function);
            if (fixupName != null && function.getCallFixup() == null) {
                function.setCallFixup(fixupName);
            }
            String callFixupApplied = function.getCallFixup();
            boolean noReturn = function.hasNoReturn();
            boolean bl = mustFix = noReturn || callFixupApplied != null && !callFixupApplied.equals("");
            if (mustFix) {
                PcodeInjectLibrary snippetLibrary = program.getCompilerSpec().getPcodeInjectLibrary();
                InjectPayload callFixup = snippetLibrary.getPayload(1, callFixupApplied, program, null);
                boolean isfallthru = true;
                if (callFixup != null) {
                    isfallthru = callFixup.isFallThru();
                }
                if (noReturn) {
                    isfallthru = false;
                }
                if (!isfallthru) {
                    AddressSet functionAddresses = new AddressSet();
                    functionAddresses.add(function.getEntryPoint());
                    this.addInThunkedFunctionsToList(program, set, function, functionAddresses);
                    AddressIterator iterator = functionAddresses.getAddresses(true);
                    for (Address functionAddr : iterator) {
                        protectedLocs.add(functionAddr);
                        repairedCallLocations.add((AddressSetView)this.repairLocationsForNonReturningFunction(program, function, functionAddr, monitor));
                    }
                }
            }
            if (fixupName != null) continue;
            nonFixedFuncs.add(function);
        }
        protectedLocs.add(analysisMgr.getProtectedLocations());
        this.repairDamage(program, repairedCallLocations, protectedLocs, monitor);
        codeChangeSet.add((AddressSetView)repairedCallLocations);
        AddressIterator addresses = codeChangeSet.getAddresses(true);
        for (Address address : addresses) {
            monitor.checkCanceled();
            Function func = program.getFunctionManager().getFunctionContaining(address);
            if (func != null) {
                address = func.getEntryPoint();
            }
            funcsToFixupSet.addRange(address, address);
        }
        for (Function function : nonFixedFuncs) {
            Address entryPoint = function.getEntryPoint();
            funcsToFixupSet.deleteRange(entryPoint, entryPoint);
            codeChangeSet.deleteRange(entryPoint, entryPoint);
        }
        if (!funcsToFixupSet.isEmpty()) {
            analysisMgr.functionDefined((AddressSetView)funcsToFixupSet);
        }
        if (!codeChangeSet.isEmpty()) {
            analysisMgr.codeDefined((AddressSetView)codeChangeSet);
            analysisMgr.blockAdded((AddressSetView)codeChangeSet);
        }
        return true;
    }

    private void addInThunkedFunctionsToList(Program program, AddressSetView initialSet, Function function, AddressSet functionAddresses) {
        Address[] thunkAddrs = function.getFunctionThunkAddresses();
        if (thunkAddrs != null) {
            for (Address addr : thunkAddrs) {
                if (initialSet.contains(addr)) continue;
                functionAddresses.add(addr);
                Function thunkingFunc = program.getFunctionManager().getFunctionAt(addr);
                if (functionAddresses.contains(addr) || thunkingFunc == null) continue;
                this.addInThunkedFunctionsToList(program, initialSet, thunkingFunc, functionAddresses);
            }
        }
    }

    private String getCallFixupNameForFunction(Map<String, String> targetFixupMap, Function function) {
        String fixupName = null;
        String funcName = function.getName();
        if (funcName.startsWith("libID_conflict_")) {
            funcName = funcName.replace("libID_conflict_", "");
        }
        if ((fixupName = targetFixupMap.get(funcName)) == null) {
            fixupName = targetFixupMap.get("_" + funcName);
        }
        if (fixupName == null) {
            fixupName = targetFixupMap.get("__" + funcName);
        }
        return fixupName;
    }

    private AddressSet repairLocationsForNonReturningFunction(Program program, Function func, Address entry, TaskMonitor monitor) {
        AddressSet fixedCallLocations = new AddressSet();
        try {
            String name = func.getName();
            monitor.setMessage("Clearing fallthrough for: " + name);
            fixedCallLocations = this.setNoFallThru(program, entry);
            if (fixedCallLocations.isEmpty()) {
                return fixedCallLocations;
            }
            monitor.setMessage("Fixup function bodies for: " + name);
            this.fixCallingFunctionBody(program, fixedCallLocations, monitor);
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
        return fixedCallLocations;
    }

    private void repairDamage(Program program, AddressSet repairedCallLocations, AddressSet protectedLocs, TaskMonitor monitor) {
        try {
            monitor.setMessage("Clearing and repairing flows");
            this.clearAndRepairFlows(program, repairedCallLocations, protectedLocs, monitor);
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
    }

    protected AddressSet setNoFallThru(Program program, Address nonReturningFunctionEntry) {
        AddressSet calledLocations = new AddressSet();
        ReferenceIterator refIter = program.getReferenceManager().getReferencesTo(nonReturningFunctionEntry);
        while (refIter.hasNext()) {
            Reference ref = refIter.next();
            if (!ref.getReferenceType().isCall()) continue;
            Address fromAddr = ref.getFromAddress();
            Instruction instr = program.getListing().getInstructionAt(fromAddr);
            if (instr == null) continue;
            Address fallthruAddr = instr.getFallThrough();
            if (instr.getFlowOverride() == FlowOverride.CALL_RETURN || fallthruAddr == null) continue;
            instr.setFlowOverride(FlowOverride.CALL_RETURN);
            if (instr.getFlowType().hasFallthrough()) continue;
            calledLocations.add(instr.getMinAddress());
        }
        return calledLocations;
    }

    protected AddressSet fixCallingFunctionBody(Program program, AddressSet callLocations, TaskMonitor monitor) throws CancelledException {
        AddressSet fixedSet = new AddressSet();
        AddressSet repairedFunctions = new AddressSet();
        AddressIterator addrIter = callLocations.getAddresses(true);
        while (addrIter.hasNext()) {
            Function fixFunc;
            Address fromAddr = addrIter.next();
            if (fixedSet.contains(fromAddr) || (fixFunc = program.getFunctionManager().getFunctionContaining(fromAddr)) == null) continue;
            repairedFunctions.add(fixFunc.getEntryPoint());
            CreateFunctionCmd.fixupFunctionBody(program, fixFunc, monitor);
            fixedSet.add(fixFunc.getBody());
        }
        return repairedFunctions;
    }

    protected void clearAndRepairFlows(Program program, AddressSet repairedCallLocations, AddressSet protectedLocs, TaskMonitor monitor) throws CancelledException {
        long numRefs = repairedCallLocations.getNumAddresses();
        int refCnt = 0;
        lastPrimaryStatusMessage = "Repair";
        SubMonitor subMonitor = new SubMonitor(monitor);
        AddressSet clearInstSet = new AddressSet();
        AddressSet clearDataSet = new AddressSet();
        AddressIterator addrIter = repairedCallLocations.getAddresses(true);
        while (addrIter.hasNext()) {
            Function functionBelow;
            monitor.checkCanceled();
            monitor.setMaximum(numRefs);
            monitor.setProgress((long)refCnt++);
            Address fromAddr = addrIter.next();
            Instruction instr = program.getListing().getInstructionAt(fromAddr);
            if (instr == null) continue;
            Address fallthruAddr = instr.getFallThrough();
            if (fallthruAddr == null) {
                try {
                    fallthruAddr = instr.getMinAddress().addNoWrap((long)instr.getDefaultFallThroughOffset());
                }
                catch (AddressOverflowException addressOverflowException) {
                    // empty catch block
                }
            }
            if (fallthruAddr == null || program.getSymbolTable().isExternalEntryPoint(fallthruAddr) || (functionBelow = program.getFunctionManager().getFunctionAt(fallthruAddr)) != null && functionBelow.getSymbol().getSource() != SourceType.DEFAULT || this.hasFlowRefInto(program, fallthruAddr)) continue;
            Instruction inst = program.getListing().getInstructionAt(fallthruAddr);
            if (inst != null) {
                clearInstSet.add(fallthruAddr);
                continue;
            }
            clearDataSet.add(fallthruAddr);
        }
        program.getBookmarkManager().removeBookmarks((AddressSetView)repairedCallLocations, "Error", monitor);
        if (!clearInstSet.isEmpty()) {
            AddressSet protect = new AddressSet((AddressSetView)repairedCallLocations).union((AddressSetView)protectedLocs);
            ClearFlowAndRepairCmd cmd = new ClearFlowAndRepairCmd((AddressSetView)clearInstSet, (AddressSetView)protect, true, false, true);
            cmd.applyTo((DomainObject)program, (TaskMonitor)subMonitor);
        }
        if (!clearDataSet.isEmpty()) {
            ClearFlowAndRepairCmd.clearBadBookmarks(program, (AddressSetView)clearDataSet, (TaskMonitor)subMonitor);
        }
    }

    private boolean hasFlowRefInto(Program program, Address addr) {
        ReferenceIterator refs = program.getReferenceManager().getReferencesTo(addr);
        while (refs.hasNext()) {
            Reference ref = refs.next();
            RefType refType = ref.getReferenceType();
            if (!refType.isFlow()) continue;
            return true;
        }
        return false;
    }

    private synchronized Map<String, String> getTargetFixupMap(Program program) {
        String[] callFixupNames;
        LanguageID languageid = program.getLanguageID();
        CompilerSpec compilerSpec = program.getCompilerSpec();
        if (compilerSpec.getCompilerSpecID().equals((Object)cachedSpecId) && languageid.equals((Object)cachedLanguageId)) {
            return cachedTargetFixupMap;
        }
        cachedLanguageId = languageid;
        cachedSpecId = compilerSpec.getCompilerSpecID();
        cachedTargetFixupMap = new HashMap<String, String>();
        PcodeInjectLibrary snippetLibrary = compilerSpec.getPcodeInjectLibrary();
        for (String fixupName : callFixupNames = snippetLibrary.getCallFixupNames()) {
            InjectPayload payload = snippetLibrary.getPayload(1, fixupName, program, null);
            List callFixupTargets = ((InjectPayloadCallfixup)payload).getTargets();
            for (String name : callFixupTargets) {
                cachedTargetFixupMap.put(name, fixupName);
            }
        }
        return cachedTargetFixupMap;
    }

    private static class SubMonitor
    extends TaskMonitorAdapter {
        private final TaskMonitor parentMonitor;

        public SubMonitor(TaskMonitor parentMonitor) {
            this.parentMonitor = parentMonitor;
        }

        public boolean isCancelled() {
            return this.parentMonitor.isCancelled();
        }

        public void checkCanceled() throws CancelledException {
            this.parentMonitor.checkCanceled();
        }

        public void cancel() {
            this.parentMonitor.cancel();
        }

        public void setMessage(String message) {
            this.parentMonitor.setMessage("<html>" + lastPrimaryStatusMessage + "&gt;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + message);
        }
    }
}

