/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesActionContext;
import ghidra.app.plugin.core.datamgr.tree.DataTypeNode;
import ghidra.app.plugin.core.navigation.FindAppliedDataTypesService;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.StringUtils;

public class FindReferencesToFieldAction
extends DockingAction {
    private final DataTypeManagerPlugin plugin;

    public FindReferencesToFieldAction(DataTypeManagerPlugin plugin) {
        super("Find Uses of Field", plugin.getName());
        this.plugin = plugin;
        String menuGroup = "ZVeryLast";
        this.setPopupMenuData(new MenuData(new String[]{"Find Uses of Field..."}, null, menuGroup));
        this.setHelpLocation(new HelpLocation("LocationReferencesPlugin", "Data_Types"));
        this.setEnabled(true);
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof DataTypesActionContext)) {
            return false;
        }
        Object contextObject = context.getContextObject();
        GTree gtree = (GTree)contextObject;
        TreePath[] selectionPaths = gtree.getSelectionPaths();
        if (selectionPaths.length != 1) {
            return false;
        }
        GTreeNode node = (GTreeNode)selectionPaths[0].getLastPathComponent();
        if (!(node instanceof DataTypeNode)) {
            return false;
        }
        DataTypeNode dtNode = (DataTypeNode)node;
        DataType dataType = dtNode.getDataType();
        return dataType instanceof Composite;
    }

    public void actionPerformed(ActionContext context) {
        GTree gTree = (GTree)context.getContextObject();
        TreePath[] selectionPaths = gTree.getSelectionPaths();
        DataTypeNode dataTypeNode = (DataTypeNode)selectionPaths[0].getLastPathComponent();
        PluginTool tool = this.plugin.getTool();
        FindAppliedDataTypesService service = (FindAppliedDataTypesService)tool.getService(FindAppliedDataTypesService.class);
        if (service == null) {
            Msg.showError((Object)((Object)this), null, (String)"Missing Plugin", (Object)"The FindAppliedDataTypesService is not installed.\nPlease add the plugin implementing this service.");
            return;
        }
        Composite composite = (Composite)dataTypeNode.getDataType();
        DataTypeComponent[] components = composite.getComponents();
        ArrayList<String> names = new ArrayList<String>();
        for (DataTypeComponent dataTypeComponent : components) {
            String fieldName = dataTypeComponent.getFieldName();
            if (StringUtils.isBlank((CharSequence)fieldName)) continue;
            names.add(fieldName);
        }
        String[] array = names.toArray(new String[names.size()]);
        String userChoice = OptionDialog.showInputChoiceDialog(null, (String)"Choose Field", (String)("Find uses of '" + composite.getName() + "' field"), (String[])array, null, (int)3);
        if (userChoice == null) {
            return;
        }
        SwingUtilities.invokeLater(() -> service.findAndDisplayAppliedDataTypeAddresses(composite, userChoice));
    }
}

