/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.action.KeyBindingData;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorAction;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CycleGroupAction;
import ghidra.app.plugin.core.compositeeditor.EditorActionListener;
import ghidra.app.plugin.core.compositeeditor.FavoritesAction;
import ghidra.app.services.DataTypeManagerService;
import ghidra.framework.options.Options;
import ghidra.program.model.data.CycleGroup;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypeManagerChangeListener;
import ghidra.program.model.data.DataTypeManagerChangeListenerAdapter;
import ghidra.program.model.data.DataTypePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.KeyStroke;

public class CompositeEditorActionManager {
    private CompositeEditorProvider provider;
    private ArrayList<CompositeEditorAction> editorActions = new ArrayList();
    private ArrayList<CompositeEditorAction> favoritesActions = new ArrayList();
    private ArrayList<CycleGroupAction> cycleGroupActions = new ArrayList();
    private ArrayList<EditorActionListener> listeners = new ArrayList();
    private DataTypeManagerService dataTypeMgrService;
    private DataTypeManagerChangeListenerAdapter adapter;

    public CompositeEditorActionManager(CompositeEditorProvider provider) {
        this.provider = provider;
        this.dataTypeMgrService = provider.dtmService;
        this.adapter = new DataTypeManagerChangeListenerAdapter(){

            public void favoritesChanged(DataTypeManager dtm, DataTypePath path, boolean isFavorite) {
                CompositeEditorActionManager.this.setFavoritesActions(CompositeEditorActionManager.this.dataTypeMgrService.getFavorites());
            }
        };
        List<DataType> favorites = Collections.emptyList();
        if (this.dataTypeMgrService != null) {
            favorites = this.dataTypeMgrService.getFavorites();
            this.dataTypeMgrService.addDataTypeManagerChangeListener((DataTypeManagerChangeListener)this.adapter);
        }
        this.setFavoritesActions(favorites);
        this.setCycleGroupActions();
    }

    void dispose() {
        if (this.dataTypeMgrService != null) {
            this.dataTypeMgrService.removeDataTypeManagerChangeListener((DataTypeManagerChangeListener)this.adapter);
        }
        this.listeners.clear();
        this.editorActions.clear();
        this.favoritesActions.clear();
        this.cycleGroupActions.clear();
        this.dataTypeMgrService = null;
    }

    public void addEditorActionListener(EditorActionListener listener) {
        this.listeners.add(listener);
    }

    public void removeEditorActionListener(EditorActionListener listener) {
        this.listeners.remove(listener);
    }

    public CompositeEditorAction[] getEditorActions() {
        return this.editorActions.toArray(new CompositeEditorAction[this.editorActions.size()]);
    }

    public CompositeEditorAction[] getFavoritesActions() {
        return this.favoritesActions.toArray(new CompositeEditorAction[this.favoritesActions.size()]);
    }

    public CompositeEditorAction[] getCycleGroupActions() {
        return this.cycleGroupActions.toArray(new CompositeEditorAction[this.cycleGroupActions.size()]);
    }

    public CompositeEditorAction[] getAllActions() {
        int numActions = this.getActionCount();
        CompositeEditorAction[] allActions = new CompositeEditorAction[numActions];
        int index = 0;
        int length = this.editorActions.size();
        int i = 0;
        while (i < length) {
            allActions[index] = this.editorActions.get(i);
            ++i;
            ++index;
        }
        length = this.favoritesActions.size();
        i = 0;
        while (i < length) {
            allActions[index] = this.favoritesActions.get(i);
            ++i;
            ++index;
        }
        length = this.cycleGroupActions.size();
        i = 0;
        while (i < length) {
            allActions[index] = this.cycleGroupActions.get(i);
            ++i;
            ++index;
        }
        return allActions;
    }

    public CompositeEditorAction getNamedAction(String actionName) {
        CompositeEditorAction action;
        int i;
        int length = this.editorActions.size();
        for (i = 0; i < length; ++i) {
            action = this.editorActions.get(i);
            if (!action.getName().equals(actionName)) continue;
            return action;
        }
        length = this.favoritesActions.size();
        for (i = 0; i < length; ++i) {
            action = this.favoritesActions.get(i);
            if (!action.getName().equals(actionName)) continue;
            return action;
        }
        length = this.cycleGroupActions.size();
        for (i = 0; i < length; ++i) {
            action = this.cycleGroupActions.get(i);
            if (!action.getName().equals(actionName)) continue;
            return action;
        }
        return null;
    }

    private int getActionCount() {
        return this.editorActions.size() + this.favoritesActions.size() + this.cycleGroupActions.size();
    }

    public void setEditorActions(CompositeEditorAction[] actions) {
        this.editorActions.clear();
        for (int i = 0; i < actions.length; ++i) {
            this.editorActions.add(actions[i]);
        }
    }

    private void setFavoritesActions(List<DataType> favorites) {
        this.clearFavoritesActions();
        for (DataType dataType : favorites) {
            FavoritesAction action = new FavoritesAction(this.provider, dataType);
            this.favoritesActions.add(action);
        }
        this.notifyActionsAdded(this.favoritesActions);
    }

    private void clearFavoritesActions() {
        this.notifyActionsRemoved(this.favoritesActions);
        this.favoritesActions.clear();
    }

    private void setCycleGroupActions() {
        this.clearCycleGroupActions();
        for (CycleGroup group : CycleGroup.ALL_CYCLE_GROUPS) {
            CycleGroupAction action = new CycleGroupAction(this.provider, group);
            this.cycleGroupActions.add(action);
        }
        this.notifyActionsAdded(this.cycleGroupActions);
    }

    private void clearCycleGroupActions() {
        this.notifyActionsRemoved(this.cycleGroupActions);
        this.cycleGroupActions.clear();
    }

    private void notifyActionsAdded(ArrayList<? extends CompositeEditorAction> actions) {
        if (actions.size() <= 0) {
            return;
        }
        int length = this.listeners.size();
        CompositeEditorAction[] cea = actions.toArray(new CompositeEditorAction[actions.size()]);
        for (int i = 0; i < length; ++i) {
            this.listeners.get(i).actionsAdded(cea);
        }
    }

    private void notifyActionsRemoved(ArrayList<? extends CompositeEditorAction> actions) {
        if (actions.size() <= 0) {
            return;
        }
        int length = this.listeners.size();
        CompositeEditorAction[] cea = actions.toArray(new CompositeEditorAction[actions.size()]);
        for (int i = 0; i < length; ++i) {
            this.listeners.get(i).actionsRemoved(cea);
        }
    }

    public void optionsChanged(Options options, String name, Object oldValue, Object newValue) {
        CompositeEditorAction[] actions = this.getEditorActions();
        for (int i = 0; i < actions.length; ++i) {
            String actionName = actions[i].getFullName();
            if (!actionName.equals(name)) continue;
            KeyStroke actionKs = actions[i].getKeyBinding();
            KeyStroke oldKs = (KeyStroke)oldValue;
            KeyStroke newKs = (KeyStroke)newValue;
            if (actionKs != oldKs) break;
            actions[i].setUnvalidatedKeyBindingData(new KeyBindingData(newKs));
            break;
        }
    }
}

