/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.bookmark;

import ghidra.app.services.MarkerListener;
import ghidra.app.services.MarkerService;
import ghidra.app.services.MarkerSet;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Bookmark;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.BookmarkType;
import ghidra.program.model.listing.Program;
import ghidra.program.util.MarkerLocation;
import ghidra.program.util.ProgramLocation;
import java.awt.Color;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import resources.ResourceManager;

public class BookmarkNavigator {
    private static final int BIG_CHANGE = 1000;
    static final ImageIcon NOTE_ICON = ResourceManager.loadImage((String)"images/notes.gif");
    static final ImageIcon INFO_ICON = ResourceManager.loadImage((String)"images/information.png");
    static final ImageIcon WARNING_ICON = ResourceManager.loadImage((String)"images/warning.png");
    static final ImageIcon ERROR_ICON = ResourceManager.loadImage((String)"images/edit-delete.png");
    static final ImageIcon ANALYSIS_ICON = ResourceManager.loadImage((String)"images/applications-system.png");
    static final ImageIcon DEFAULT_ICON = ResourceManager.loadImage((String)"images/unknown.gif");
    static final int NOTE_PRIORITY = 0;
    static final int ERROR_PRIORITY = 1000;
    static final int WARNING_PRIORITY = 500;
    static final int INFO_PRIORITY = 4;
    static final int ANALYSIS_PRIORITY = 6;
    static final int DEFAULT_PRIORITY = 8;
    static final Color NOTE_COLOR = new Color(128, 0, 255);
    static final Color INFO_COLOR = new Color(0, 255, 255);
    static final Color WARNING_COLOR = new Color(255, 196, 51);
    static final Color ERROR_COLOR = new Color(204, 0, 51);
    static final Color ANALYSIS_COLOR = new Color(255, 128, 0);
    static final Color DEFAULT_COLOR = new Color(255, 0, 255);
    private String type;
    private MarkerService markerService;
    private BookmarkManager bookmarkMgr;
    private MarkerSet markerSet;
    private Runnable updateRunnable;
    private AddressSet addressSet;

    public BookmarkNavigator(MarkerService markerService, BookmarkManager bookmarkManager, BookmarkType bmt) {
        Color color;
        ImageIcon icon;
        this.markerService = markerService;
        this.bookmarkMgr = bookmarkManager;
        this.type = bmt.getTypeString();
        this.updateRunnable = new Runnable(){

            @Override
            public void run() {
                BookmarkNavigator.this.updateMarkerSetAddresses();
            }
        };
        int priority = bmt.getMarkerPriority();
        if (priority < 0) {
            priority = 8;
        }
        if ((icon = bmt.getIcon()) == null) {
            icon = DEFAULT_ICON;
        }
        if ((color = bmt.getMarkerColor()) == null) {
            color = DEFAULT_COLOR;
        }
        this.markerSet = markerService.createPointMarker(this.type + " Bookmarks", this.type + " Bookmarks", this.bookmarkMgr.getProgram(), priority, true, true, false, color, icon);
        this.markerSet.setNavigationListener(new MarkerListener(){

            @Override
            public ProgramLocation getProgramLocation(MarkerLocation loc) {
                return null;
            }

            @Override
            public String getTooltip(MarkerLocation loc) {
                Bookmark[] bookmarks = BookmarkNavigator.this.bookmarkMgr.getBookmarks(loc.getAddr(), BookmarkNavigator.this.type);
                if (bookmarks == null) {
                    return BookmarkNavigator.this.type;
                }
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < bookmarks.length; ++i) {
                    if (i != 0) {
                        buf.append("<br>");
                    }
                    buf.append(BookmarkNavigator.this.type);
                    String cat = bookmarks[i].getCategory();
                    if (cat != null && cat.length() != 0) {
                        buf.append(" [");
                        buf.append(cat);
                        buf.append("]");
                    }
                    buf.append(": ");
                    buf.append(bookmarks[i].getComment());
                }
                return buf.toString();
            }

            @Override
            public ImageIcon getIcon(MarkerLocation loc) {
                return null;
            }
        });
    }

    private synchronized void updateMarkerSetAddresses() {
        if (this.addressSet != null && this.markerSet != null) {
            this.markerSet.setAddressSet((AddressSetView)this.addressSet);
            this.addressSet = null;
        }
    }

    public void dispose() {
        if (this.markerService != null) {
            this.markerService.removeMarker(this.markerSet, this.bookmarkMgr.getProgram());
            this.markerSet = null;
            this.bookmarkMgr = null;
        }
    }

    String getType() {
        return this.type;
    }

    public synchronized void updateBookmarkers(AddressSet set) {
        if (this.addressSet != null) {
            this.addressSet = set;
            return;
        }
        this.addressSet = set;
        SwingUtilities.invokeLater(this.updateRunnable);
    }

    public void add(Address addr) {
        this.markerSet.add(addr);
    }

    public void clear(Address addr) {
        this.markerSet.clear(addr);
    }

    public boolean intersects(Address start, Address end) {
        return this.markerSet.intersects(start, end);
    }

    public static void defineBookmarkTypes(Program program) {
        BookmarkManager mgr = program.getBookmarkManager();
        mgr.defineType("Note", NOTE_ICON, NOTE_COLOR, 0);
        mgr.defineType("Info", INFO_ICON, INFO_COLOR, 4);
        mgr.defineType("Warning", WARNING_ICON, WARNING_COLOR, 500);
        mgr.defineType("Error", ERROR_ICON, ERROR_COLOR, 1000);
        mgr.defineType("Analysis", ANALYSIS_ICON, ANALYSIS_COLOR, 6);
    }
}

