/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.bin.format.pe.cli.CliMetadataRoot;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTableRow;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableMethodDef;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Program;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class CliMetadataTokenAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "CLI Metadata Token Analyzer";
    private static final String DESCRIPTION = "Takes CLI metadata tokens from their table/index form and gives a more useful representation.";

    public CliMetadataTokenAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.INSTRUCTION_ANALYZER);
        this.setSupportsOneTimeAnalysis();
        this.setPriority(AnalysisPriority.CODE_ANALYSIS);
        this.setPrototype();
    }

    @Override
    public boolean getDefaultEnablement(Program program) {
        return program.getLanguage().getLanguageDescription().getLanguageID().getIdAsString().contains("CLI");
    }

    @Override
    public boolean canAnalyze(Program program) {
        return this.getDefaultEnablement(program);
    }

    @Override
    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        Symbol metadataRootSymbol = SymbolUtilities.getExpectedLabelOrFunctionSymbol((Program)program, (String)"CLI_METADATA_HEADER", err -> log.error(this.getName(), err));
        if (metadataRootSymbol == null) {
            String message = "CLI Metadata Root Symbol not found.";
            log.appendMsg(this.getName(), message);
            log.setStatus(message);
            return false;
        }
        Address metadataRootAddr = metadataRootSymbol.getAddress();
        MemoryByteProvider bytes = new MemoryByteProvider(program.getMemory(), metadataRootAddr);
        BinaryReader reader = new BinaryReader(bytes, !program.getLanguage().isBigEndian());
        try {
            CliMetadataRoot metadataRoot = new CliMetadataRoot(reader, 0);
            metadataRoot.parse();
            CliStreamMetadata metadataStream = metadataRoot.getMetadataStream();
            InstructionIterator instIter = program.getListing().getInstructions(set, true);
            while (instIter.hasNext()) {
                try {
                    Instruction inst = instIter.next();
                    if (inst.getMnemonicString().endsWith("ldstr")) {
                        this.processUserString(metadataStream, inst);
                        continue;
                    }
                    if (inst.getMnemonicString().endsWith("call")) {
                        this.processControlFlowInstruction(program, metadataStream, inst, (RefType)RefType.UNCONDITIONAL_CALL);
                        continue;
                    }
                    if (inst.getMnemonicString().endsWith("calli")) {
                        this.processControlFlowInstruction(program, metadataStream, inst, (RefType)RefType.COMPUTED_CALL);
                        continue;
                    }
                    if (inst.getMnemonicString().endsWith("jmp")) {
                        this.processControlFlowInstruction(program, metadataStream, inst, (RefType)RefType.UNCONDITIONAL_JUMP);
                        continue;
                    }
                    if (inst.getMnemonicString().endsWith("ldftn")) {
                        this.processGenericMetadataToken(metadataStream, inst);
                        continue;
                    }
                    if (inst.getMnemonicString().endsWith("box") || inst.getMnemonicString().endsWith("castclass") || inst.getMnemonicString().endsWith("cpobj") || inst.getMnemonicString().endsWith("initobj") || inst.getMnemonicString().endsWith("isinst") || inst.getMnemonicString().endsWith("ldelem") || inst.getMnemonicString().endsWith("ldelema") || inst.getMnemonicString().endsWith("ldfld") || inst.getMnemonicString().endsWith("ldflda") || inst.getMnemonicString().endsWith("ldobj") || inst.getMnemonicString().endsWith("ldsfld") || inst.getMnemonicString().endsWith("ldsflda") || inst.getMnemonicString().endsWith("ldtoken") || inst.getMnemonicString().endsWith("mkrefany") || inst.getMnemonicString().endsWith("newarr") || inst.getMnemonicString().endsWith("newobj") || inst.getMnemonicString().endsWith("refanyval") || inst.getMnemonicString().endsWith("sizeof") || inst.getMnemonicString().endsWith("stelem") || inst.getMnemonicString().endsWith("stfld") || inst.getMnemonicString().endsWith("stobj") || inst.getMnemonicString().endsWith("stsfld") || inst.getMnemonicString().endsWith("unbox") || inst.getMnemonicString().endsWith("unbox.any")) {
                        this.processObjectModelInstruction(program, metadataStream, inst);
                        continue;
                    }
                    if (inst.getMnemonicString().endsWith("callvirt")) {
                        this.processControlFlowInstruction(program, metadataStream, inst, (RefType)RefType.COMPUTED_CALL);
                        continue;
                    }
                    if (inst.getMnemonicString().endsWith("constrained")) {
                        CliAbstractTableRow tableRow = this.getRowForMetadataToken(metadataStream, inst);
                        this.markMetadataRow(inst, tableRow, "Next instr type req'd to be: ", "", metadataStream);
                        continue;
                    }
                    if (!inst.getMnemonicString().endsWith("ldvirtfn")) continue;
                    this.processObjectModelInstruction(program, metadataStream, inst);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            String message = e.toString();
            log.appendMsg(this.getName(), message);
            log.setStatus(message);
            return false;
        }
        return true;
    }

    private void processGenericMetadataToken(CliStreamMetadata metaStream, Instruction inst) {
        CliAbstractTableRow tableRow = this.getRowForMetadataToken(metaStream, inst);
        this.markMetadataRow(inst, tableRow, metaStream);
    }

    private void processObjectModelInstruction(Program program, CliStreamMetadata metaStream, Instruction inst) {
        CliAbstractTableRow tableRow = this.getRowForMetadataToken(metaStream, inst);
        this.markMetadataRow(inst, tableRow, "", " (Object Model Instruction)", metaStream);
    }

    private void processUserString(CliStreamMetadata metaStream, Instruction inst) {
        Scalar strIndexOp = (Scalar)inst.getOpObjects(0)[0];
        int strIndex = (int)strIndexOp.getUnsignedValue();
        inst.setComment(0, "\"" + metaStream.getUserStringsStream().getUserString(strIndex) + "\"");
    }

    private void processControlFlowInstruction(Program program, CliStreamMetadata metaStream, Instruction inst, RefType refType) {
        CliAbstractTableRow tableRow = this.getRowForMetadataToken(metaStream, inst);
        this.markMetadataRow(inst, tableRow, metaStream);
        if (tableRow instanceof CliTableMethodDef.CliMethodDefRow) {
            CliTableMethodDef.CliMethodDefRow methodDef = (CliTableMethodDef.CliMethodDefRow)tableRow;
            if (methodDef.RVA != 0) {
                Address destAddr = program.getAddressFactory().getDefaultAddressSpace().getAddress((long)methodDef.RVA);
                inst.addOperandReference(1, destAddr, refType, SourceType.ANALYSIS);
            }
        }
    }

    private CliAbstractTableRow getRowForMetadataToken(CliStreamMetadata metaStream, Instruction inst) {
        Object[] ops = inst.getOpObjects(0);
        Scalar tableOp = (Scalar)ops[0];
        Scalar indexOp = (Scalar)ops[1];
        int table = (int)tableOp.getUnsignedValue();
        int index = (int)indexOp.getUnsignedValue();
        CliAbstractTableRow tableRow = metaStream.getTable(table).getRow(index);
        return tableRow;
    }

    private void markMetadataRow(Instruction inst, CliAbstractTableRow tableRow, String prependComment, String appendComment, CliStreamMetadata stream) {
        inst.setComment(0, String.format("%s%s%s", prependComment, tableRow.getShortRepresentation(stream), appendComment));
    }

    private void markMetadataRow(Instruction inst, CliAbstractTableRow tableRow, CliStreamMetadata stream) {
        this.markMetadataRow(inst, tableRow, "", "", stream);
    }
}

