/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.store.LockException;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.task.TaskMonitor;

public abstract class AbstractCInitAnalyzer
extends AbstractAnalyzer {
    private static final String DESCRIPTION = "Initializes the .bss uninitilized memory using data from the .cinit section.";
    private String[] supportProcessors;
    private static final String CINIT = ".cinit";

    public AbstractCInitAnalyzer(String analyzerName, String ... supportProcessors) {
        super(analyzerName, DESCRIPTION, AnalyzerType.BYTE_ANALYZER);
        this.supportProcessors = supportProcessors;
        this.setDefaultEnablement(true);
        this.setPriority(AnalysisPriority.FORMAT_ANALYSIS.before().before());
    }

    private boolean isSupportedProcessor(Processor processor) {
        String processorName = processor.toString();
        for (String pname : this.supportProcessors) {
            if (!processorName.equals(pname)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canAnalyze(Program p) {
        if (!this.isSupportedProcessor(p.getLanguage().getProcessor())) {
            return false;
        }
        Memory mem = p.getMemory();
        MemoryBlock cinitBlock = mem.getBlock(CINIT);
        return cinitBlock != null && cinitBlock.isInitialized();
    }

    protected abstract CInitRecord getCinitRecord(Program var1, Address var2) throws CodeUnitInsertionException, AddressOverflowException;

    @Override
    public synchronized boolean added(Program p, AddressSetView set, TaskMonitor monitor, MessageLog log) {
        Memory mem = p.getMemory();
        MemoryBlock cinitBlock = mem.getBlock(CINIT);
        if (cinitBlock == null || !set.contains(cinitBlock.getStart())) {
            return true;
        }
        BookmarkManager bookmarkManager = p.getBookmarkManager();
        Address addr = cinitBlock.getStart();
        MemoryBlock block = null;
        try {
            CInitRecord initRec;
            while (addr.compareTo((Object)cinitBlock.getEnd()) < 0 && !(initRec = this.getCinitRecord(p, addr)).isTerminalRecord()) {
                byte[] bytes;
                addr = initRec.getNextRecordAddress();
                Address dataAddr = initRec.getTargetAddress();
                if (dataAddr == null) continue;
                Address initDataAddr = initRec.getSourceDataAddress();
                int byteLen = initRec.getDataLength();
                block = mem.getBlock(dataAddr);
                if (block == null) {
                    Msg.error((Object)this, (Object)("Failed to initialize data at " + dataAddr + " - no memory defined"));
                    continue;
                }
                if (!block.isInitialized()) {
                    mem.convertToInitialized(block, (byte)0);
                    block.setWrite(true);
                }
                if (byteLen != cinitBlock.getBytes(initDataAddr, bytes = new byte[byteLen])) {
                    throw new MemoryAccessException("unexpected end of .cinit block");
                }
                Msg.debug((Object)this, (Object)(byteLen + "-bytes at " + dataAddr + " initialized from .cinit data at " + initDataAddr));
                block.putBytes(dataAddr, bytes);
                bookmarkManager.setBookmark(dataAddr, "Analysis", "Data Initilized", byteLen + "-bytes initialized from .cinit data at " + initDataAddr);
            }
        }
        catch (MemoryAccessException e) {
            Msg.error((Object)this, (Object)("Error occured during block initialization: " + e.getMessage()));
        }
        catch (CodeUnitInsertionException e) {
            Msg.error((Object)this, (Object)("Failed to create .cinit data structure: " + e.getMessage()));
        }
        catch (AddressOverflowException e) {
            Msg.error((Object)this, (Object)"Unexpected end of .cinit block");
        }
        catch (LockException e) {
            Msg.showError((Object)this, null, (String)(this.getName() + " Failed"), (Object)(this.getName() + " requires exclusive check-out to perform " + block.getName() + " memory block initialization"));
            return false;
        }
        catch (NotFoundException e) {
            throw new AssertException((Throwable)e);
        }
        return true;
    }

    public static class CInitRecord {
        private final Address cinitRecordAddr;
        private final Address sourceDataAddr;
        private final Address targetAddr;
        private final int dataLength;
        private final Address nextRecordAddr;

        public CInitRecord(Address cinitRecordAddr, Address sourceDataAddr, Address targetAddr, int dataLength, Address nextRecordAddr) {
            this.cinitRecordAddr = cinitRecordAddr;
            this.sourceDataAddr = sourceDataAddr;
            this.targetAddr = targetAddr;
            this.dataLength = dataLength;
            this.nextRecordAddr = nextRecordAddr;
        }

        public Address getStartOfRecord() {
            return this.cinitRecordAddr;
        }

        public boolean isTerminalRecord() {
            return this.getDataLength() == 0;
        }

        public Address getTargetAddress() {
            return this.targetAddr;
        }

        public Address getSourceDataAddress() {
            return this.sourceDataAddr;
        }

        public int getDataLength() {
            return this.dataLength;
        }

        public Address getNextRecordAddress() {
            return this.nextRecordAddr;
        }
    }
}

