/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.refs;

import ghidra.app.cmd.refs.RemoveReferenceCmd;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;

public class RemoveAllReferencesCmd
implements Command {
    private Address fromAddr;
    private int opIndex;
    private boolean useOpIndex;

    public RemoveAllReferencesCmd(Address fromAddr) {
        this.fromAddr = fromAddr;
        this.useOpIndex = false;
    }

    public RemoveAllReferencesCmd(Address fromAddr, int opIndex) {
        this.fromAddr = fromAddr;
        this.opIndex = opIndex;
        this.useOpIndex = true;
    }

    public boolean applyTo(DomainObject obj) {
        Program program = (Program)obj;
        ReferenceManager refMgr = program.getReferenceManager();
        if (!this.useOpIndex) {
            refMgr.removeAllReferencesFrom(this.fromAddr);
            return true;
        }
        Reference[] refs = refMgr.getReferencesFrom(this.fromAddr, this.opIndex);
        for (int i = 0; i < refs.length; ++i) {
            refMgr.delete(refs[i]);
            RemoveReferenceCmd.fixupReferencedVariable(program, refs[i]);
        }
        return true;
    }

    public String getStatusMsg() {
        return null;
    }

    public String getName() {
        return "Remove References";
    }
}

