/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.memory;

import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryBlockType;
import ghidra.program.model.mem.MemoryConflictException;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.RollbackException;

public class AddMemoryBlockCmd
implements Command {
    private String name;
    private String comment;
    private String source;
    private Address start;
    private int length;
    private boolean read;
    private boolean write;
    private boolean execute;
    private boolean isVolatile;
    private byte initialValue;
    private MemoryBlockType blockType;
    private Address baseAddr;
    private Program program;
    private String message;
    private boolean isInitialized;

    public AddMemoryBlockCmd(String name, String comment, String source, Address start, int length, boolean read, boolean write, boolean execute, boolean isVolatile, byte initialValue, MemoryBlockType blockType, Address baseAddr, boolean isInitialized) {
        this.name = name;
        this.comment = comment;
        this.source = source;
        this.start = start;
        this.length = length;
        this.read = read;
        this.write = write;
        this.execute = execute;
        this.isVolatile = isVolatile;
        this.initialValue = initialValue;
        this.blockType = blockType;
        this.baseAddr = baseAddr;
        this.isInitialized = isInitialized;
    }

    public boolean applyTo(DomainObject obj) {
        this.program = (Program)obj;
        try {
            Memory memory = this.program.getMemory();
            MemoryBlock block = null;
            block = this.isInitialized ? memory.createInitializedBlock(this.name, this.start, (long)this.length, this.initialValue, null, this.blockType == MemoryBlockType.OVERLAY) : (this.blockType == MemoryBlockType.DEFAULT || this.blockType == MemoryBlockType.OVERLAY ? memory.createUninitializedBlock(this.name, this.start, (long)this.length, this.blockType == MemoryBlockType.OVERLAY) : (this.blockType == MemoryBlockType.BIT_MAPPED ? memory.createBitMappedBlock(this.name, this.start, this.baseAddr, (long)this.length) : memory.createByteMappedBlock(this.name, this.start, this.baseAddr, (long)this.length)));
            block.setComment(this.comment);
            block.setRead(this.read);
            block.setWrite(this.write);
            block.setExecute(this.execute);
            block.setVolatile(this.isVolatile);
            block.setSourceName(this.source);
            this.renameFragment(block.getStart());
            return true;
        }
        catch (IllegalArgumentException e) {
            this.message = e.getMessage();
        }
        catch (AddressOverflowException e) {
            this.message = e.getMessage();
        }
        catch (MemoryConflictException e) {
            this.message = e.getMessage();
        }
        catch (OutOfMemoryError e) {
            this.message = "Not enough memory to create block";
        }
        catch (DuplicateNameException e) {
            this.message = "Duplicate Name: " + e.getMessage();
        }
        catch (IllegalStateException e) {
            this.message = e.getMessage();
        }
        catch (Throwable t) {
            this.message = "Create block failed";
            Msg.showError((Object)this, null, (String)"Create Block Failed", (Object)t.getMessage(), (Throwable)t);
        }
        throw new RollbackException(this.message);
    }

    public String getName() {
        return "Add Memory Block";
    }

    public String getStatusMsg() {
        return this.message;
    }

    private void renameFragment(Address blockStartAddr) {
        Listing listing = this.program.getListing();
        String[] treeNames = listing.getTreeNames();
        for (int i = 0; i < treeNames.length; ++i) {
            try {
                ProgramFragment frag = listing.getFragment(treeNames[i], blockStartAddr);
                frag.setName(this.name);
                continue;
            }
            catch (DuplicateNameException duplicateNameException) {
                // empty catch block
            }
        }
    }
}

