/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.disassemble;

import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.program.disassemble.Disassembler;
import ghidra.program.disassemble.DisassemblerContextImpl;
import ghidra.program.disassemble.DisassemblerMessageListener;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.task.TaskMonitor;

public class DisassembleCommand
extends BackgroundCommand {
    protected AddressSetView startSet;
    protected boolean useDefaultRepeatPatternBehavior = false;
    private AddressSetView restrictedSet;
    private AddressSetView exectuableSet;
    private AddressSet disassembledAddrs;
    private boolean followFlow = true;
    private boolean enableAnalysis = true;
    private DisassemblerContextImpl seedContext;
    private RegisterValue initialContextValue;
    private int alignment;
    protected boolean disassemblyPerformed;
    protected boolean unalignedStart;
    protected boolean nonExecutableStart;

    public DisassembleCommand(Address start, AddressSetView restrictedSet, boolean followFlow) {
        this((AddressSetView)new AddressSet(start, start), restrictedSet, followFlow);
        this.useDefaultRepeatPatternBehavior = true;
    }

    public DisassembleCommand(AddressSetView startSet, AddressSetView restrictedSet) {
        this(startSet, restrictedSet, true);
    }

    public DisassembleCommand(AddressSetView startSet, AddressSetView restrictedSet, boolean followFlow) {
        this("Disassemble", startSet, restrictedSet, followFlow);
    }

    protected DisassembleCommand(String name, AddressSetView startSet, AddressSetView restrictedSet, boolean followFlow) {
        super(name, true, true, false);
        this.startSet = startSet;
        this.restrictedSet = restrictedSet;
        this.followFlow = followFlow;
    }

    public void setSeedContext(DisassemblerContextImpl seedContext) {
        this.seedContext = seedContext;
    }

    public void setInitialContext(RegisterValue initialContextValue) {
        if (initialContextValue != null) {
            Register reg = initialContextValue.getRegister();
            initialContextValue = initialContextValue.getRegisterValue(reg.getBaseRegister());
        }
        this.initialContextValue = initialContextValue;
    }

    public void enableCodeAnalysis(boolean enable) {
        this.enableAnalysis = enable;
    }

    public String getStatusMsg() {
        if (this.disassemblyPerformed) {
            return null;
        }
        if (this.nonExecutableStart) {
            return "Disassembly of non-executable memory is disabled";
        }
        if (this.unalignedStart) {
            return "Disassembler requires a start which is " + this.alignment + "-byte aligned and on an undefined code unit";
        }
        return "Disassembler requires a start which is an undefined code unit";
    }

    public synchronized boolean applyTo(DomainObject obj, TaskMonitor monitor) {
        Program program = (Program)obj;
        return this.doDisassembly(monitor, program, program.getLanguage().getInstructionAlignment());
    }

    private AddressSetView getExecutableSet(Program program) {
        Memory memory = program.getMemory();
        AddressSet set = new AddressSet();
        for (MemoryBlock block : memory.getBlocks()) {
            if (!block.isExecute()) continue;
            set.add(block.getStart(), block.getEnd());
        }
        return set;
    }

    protected boolean doDisassembly(TaskMonitor monitor, Program program, int instructionAlignment) {
        long startNumAddr;
        this.exectuableSet = Disassembler.isRestrictToExecuteMemory((Program)program) ? (this.exectuableSet = this.getExecutableSet(program)) : null;
        this.alignment = instructionAlignment;
        this.disassemblyPerformed = false;
        this.unalignedStart = false;
        this.nonExecutableStart = false;
        Disassembler disassembler = Disassembler.getDisassembler((Program)program, (TaskMonitor)monitor, (DisassemblerMessageListener)new MyListener(monitor));
        disassembler.setSeedContext(this.seedContext);
        if (this.startSet == null || this.startSet.isEmpty()) {
            return true;
        }
        AddressSet set = new AddressSet(this.startSet);
        if (!this.useDefaultRepeatPatternBehavior) {
            if (this.startSet != this.restrictedSet && !this.startSet.equals(this.restrictedSet)) {
                disassembler.setRepeatPatternLimitIgnored(this.startSet);
            } else {
                disassembler.setRepeatPatternLimit(-1);
            }
        }
        AutoAnalysisManager mgr = null;
        if (this.enableAnalysis) {
            mgr = AutoAnalysisManager.getAnalysisManager(program);
        }
        if ((startNumAddr = set.getNumAddresses()) > 1L) {
            monitor.initialize(startNumAddr);
        }
        AddressSet allLocalDisAddrs = new AddressSet();
        while (!set.isEmpty() && !monitor.isCancelled()) {
            AddressSet seedSet = this.getNextSeedSet(program, set, monitor);
            if (seedSet.isEmpty()) continue;
            if (startNumAddr > 1L) {
                monitor.setProgress(set.getNumAddresses() - startNumAddr);
            }
            AddressSet localDisAddrs = disassembler.disassemble((AddressSetView)seedSet, this.restrictedSet, this.initialContextValue, this.followFlow);
            allLocalDisAddrs.add((AddressSetView)localDisAddrs);
            if (localDisAddrs != null && !localDisAddrs.isEmpty()) {
                this.disassemblyPerformed = true;
                DisassembleCommand.analizeIfNeeded(mgr, (AddressSetView)set, (AddressSetView)localDisAddrs, monitor);
            }
            set = set.subtract((AddressSetView)localDisAddrs);
        }
        this.disassembledAddrs = allLocalDisAddrs;
        return this.disassemblyPerformed || !this.nonExecutableStart & !this.unalignedStart;
    }

    private static void analizeIfNeeded(AutoAnalysisManager mgr, AddressSetView startSet, AddressSetView disassembledSet, TaskMonitor monitor) {
        if (mgr == null || monitor.isCancelled()) {
            return;
        }
        mgr.codeDefined(disassembledSet);
        AddressRange firstRange = disassembledSet.getFirstRange();
        Address rangeEnd = firstRange.getMaxAddress();
        Address nextAddr = rangeEnd.next();
        if (nextAddr != null && startSet.contains(rangeEnd) && startSet.contains(nextAddr)) {
            mgr.startAnalysis(monitor, false);
        }
    }

    private AddressSet getNextSeedSet(Program program, AddressSet set, TaskMonitor monitor) {
        AddressSet seedSet = new AddressSet();
        boolean bigRangeFound = false;
        while (!(monitor.isCancelled() || set.isEmpty() || bigRangeFound)) {
            Address firstaddr = set.getMinAddress();
            AddressRange addressRange = (AddressRange)set.iterator().next();
            if (addressRange.getLength() > 4L) {
                bigRangeFound = true;
            }
            set.deleteRange(firstaddr, firstaddr);
            if (!program.getListing().isUndefined(firstaddr, firstaddr)) {
                Address end = firstaddr;
                if (set.isEmpty()) {
                    return seedSet;
                }
                Address nextAddr = firstaddr.next();
                if (nextAddr == null || !set.contains(nextAddr)) continue;
                Data next = program.getListing().getFirstUndefinedData((AddressSetView)set, monitor);
                if (next != null) {
                    end = next.getMinAddress();
                    set.deleteRange(firstaddr, end);
                    firstaddr = end;
                } else {
                    set.clear();
                    return seedSet;
                }
            }
            if (this.exectuableSet != null && !this.exectuableSet.contains(firstaddr) && !program.getMemory().getLoadedAndInitializedAddressSet().contains(firstaddr)) {
                this.nonExecutableStart = true;
            }
            if (firstaddr.getOffset() % (long)this.alignment != 0L) {
                firstaddr = firstaddr.subtract(firstaddr.getOffset() % (long)this.alignment);
            }
            if (!program.getListing().isUndefined(firstaddr, firstaddr)) continue;
            seedSet.add(firstaddr);
        }
        return seedSet;
    }

    public AddressSet getDisassembledAddressSet() {
        return this.disassembledAddrs;
    }

    private class MyListener
    implements DisassemblerMessageListener {
        private TaskMonitor monitor;

        MyListener(TaskMonitor monitor) {
            this.monitor = monitor;
        }

        public void disassembleMessageReported(String msg) {
            if (this.monitor != null) {
                this.monitor.setMessage(msg);
            }
        }
    }
}

