/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.byteviewer;

import ghidra.app.events.ProgramLocationPluginEvent;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.plugin.core.byteviewer.ByteBlockChangeManager;
import ghidra.app.plugin.core.byteviewer.ByteBlockChangePluginEvent;
import ghidra.app.plugin.core.byteviewer.MemoryByteBlock;
import ghidra.app.plugin.core.byteviewer.ProgramByteViewerComponentProvider;
import ghidra.app.plugin.core.format.ByteBlock;
import ghidra.app.plugin.core.format.ByteBlockInfo;
import ghidra.app.plugin.core.format.ByteBlockRange;
import ghidra.app.plugin.core.format.ByteBlockSelection;
import ghidra.app.plugin.core.format.ByteBlockSet;
import ghidra.app.plugin.core.format.ByteEditInfo;
import ghidra.framework.options.SaveState;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import java.math.BigInteger;
import java.util.ArrayList;

class ProgramByteBlockSet
implements ByteBlockSet {
    private MemoryBlock[] memBlocks;
    private Program program;
    private ByteBlockChangeManager bbcm;
    private ByteBlock[] blocks;
    private final ProgramByteViewerComponentProvider provider;

    ProgramByteBlockSet(ProgramByteViewerComponentProvider provider, Program program, ByteBlockChangeManager bbcm) {
        this.provider = provider;
        this.program = program;
        this.bbcm = bbcm == null ? new ByteBlockChangeManager(this) : new ByteBlockChangeManager(this, bbcm);
        this.getMemoryBlocks();
    }

    @Override
    public ByteBlock[] getBlocks() {
        return this.blocks;
    }

    @Override
    public ProgramSelectionPluginEvent getPluginEvent(String source, ByteBlockSelection selection) {
        AddressSet addrSet = new AddressSet();
        for (int i = 0; i < selection.getNumberOfRanges(); ++i) {
            ByteBlockRange br = selection.getRange(i);
            ByteBlock block = br.getByteBlock();
            Address start = this.getAddress(block, br.getStartIndex());
            Address end = this.getAddress(block, br.getEndIndex());
            addrSet.add((AddressRange)new AddressRangeImpl(start, end));
        }
        return new ProgramSelectionPluginEvent(source, new ProgramSelection((AddressSetView)addrSet), this.program);
    }

    @Override
    public ProgramLocationPluginEvent getPluginEvent(String source, ByteBlock block, BigInteger offset, int column) {
        ProgramLocation loc = this.provider.getLocation(block, offset, column);
        return new ProgramLocationPluginEvent(source, loc, this.program);
    }

    void processByteBlockChangeEvent(ByteBlockChangePluginEvent event) {
        if (event.getProgram() == this.program) {
            this.bbcm.add(event.getByteEditInfo());
        }
    }

    ByteBlockSelection getBlockSelection(ProgramSelection selection) {
        AddressRangeIterator iter = selection.getAddressRanges();
        ArrayList<ByteBlockRange> list = new ArrayList<ByteBlockRange>(3);
        while (iter.hasNext()) {
            AddressRange range = (AddressRange)iter.next();
            for (int i = 0; i < this.blocks.length; ++i) {
                Address blockEnd;
                Address blockStart = this.memBlocks[i].getStart();
                AddressRange intersection = range.intersect((AddressRange)new AddressRangeImpl(blockStart, blockEnd = this.memBlocks[i].getEnd()));
                if (intersection == null) continue;
                ByteBlockInfo startInfo = this.getByteBlockInfo(intersection.getMinAddress());
                ByteBlockInfo endInfo = this.getByteBlockInfo(intersection.getMaxAddress());
                ByteBlockRange br = new ByteBlockRange(startInfo.getBlock(), startInfo.getOffset(), endInfo.getOffset());
                list.add(br);
            }
        }
        ByteBlockRange[] bRange = new ByteBlockRange[list.size()];
        bRange = list.toArray(bRange);
        return new ByteBlockSelection(bRange);
    }

    @Override
    public boolean isChanged(ByteBlock block, BigInteger index, int length) {
        return this.bbcm.isChanged(block, index, length);
    }

    void setByteBlockChangeManager(ByteBlockChangeManager byteBlockChangeManager) {
        this.bbcm = byteBlockChangeManager;
    }

    @Override
    public void notifyByteEditing(ByteBlock block, BigInteger index, byte[] oldValue, byte[] newValue) {
        ByteEditInfo edit = new ByteEditInfo(this.getAddress(block, BigInteger.ZERO), index, oldValue, newValue);
        this.bbcm.add(edit);
        this.provider.notifyEdit(edit);
    }

    SaveState getUndoRedoState() {
        return this.bbcm.getUndoRedoState();
    }

    void restoreUndoReoState(SaveState saveState) {
        this.bbcm.restoreUndoRedoState(saveState);
    }

    ByteBlockChangeManager getByteBlockChangeManager() {
        return this.bbcm;
    }

    Address getAddress(ByteBlock block, BigInteger offset) {
        for (int i = 0; i < this.blocks.length; ++i) {
            if (this.blocks[i] != block) continue;
            try {
                Address addr = this.memBlocks[i].getStart();
                return addr.addNoWrap(offset);
            }
            catch (AddressOverflowException e) {
                throw new IndexOutOfBoundsException("Offset " + offset + " is not in this block");
            }
        }
        return null;
    }

    ByteBlockInfo getByteBlockInfo(Address address) {
        if (!this.program.getMemory().contains(address)) {
            return null;
        }
        for (int i = 0; i < this.blocks.length; ++i) {
            if (!this.memBlocks[i].contains(address)) continue;
            try {
                long off = address.subtract(this.memBlocks[i].getStart());
                BigInteger offset = off < 0L ? BigInteger.valueOf(off + Long.MIN_VALUE).subtract(BigInteger.valueOf(Long.MIN_VALUE)) : BigInteger.valueOf(off);
                return new ByteBlockInfo(this.blocks[i], offset);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    Address getBlockStart(ByteBlock block) {
        return this.getAddress(block, BigInteger.ZERO);
    }

    Address getBlockStart(int blockNumber) {
        return this.memBlocks[blockNumber].getStart();
    }

    int getByteBlockNumber(Address blockStartAddr) {
        for (int i = 0; i < this.memBlocks.length; ++i) {
            if (this.memBlocks[i].getStart().compareTo((Object)blockStartAddr) != 0) continue;
            return i;
        }
        return -1;
    }

    AddressSet getAddressSet(ByteBlockSelection selection) {
        AddressSet addrSet = new AddressSet();
        for (int i = 0; i < selection.getNumberOfRanges(); ++i) {
            ByteBlockRange br = selection.getRange(i);
            ByteBlock block = br.getByteBlock();
            Address start = this.getAddress(block, br.getStartIndex());
            Address end = this.getAddress(block, br.getEndIndex());
            addrSet.add((AddressRange)new AddressRangeImpl(start, end));
        }
        return addrSet;
    }

    private void getMemoryBlocks() {
        Memory memory = this.program.getMemory();
        this.memBlocks = this.program.getMemory().getBlocks();
        this.blocks = new ByteBlock[this.memBlocks.length];
        for (int i = 0; i < this.memBlocks.length; ++i) {
            this.blocks[i] = new MemoryByteBlock(this.program, memory, this.memBlocks[i]);
        }
    }

    @Override
    public void dispose() {
    }

    public int startTransaction() {
        return this.program.startTransaction("Memory Edit");
    }

    public void endTransaction(int transactionID, boolean b) {
        this.program.endTransaction(transactionID, b);
    }
}

