/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.extend;

import ghidra.app.util.bin.format.MemoryLoadable;
import ghidra.app.util.bin.format.elf.ElfDefaultGotPltMarkup;
import ghidra.app.util.bin.format.elf.ElfDynamicTable;
import ghidra.app.util.bin.format.elf.ElfDynamicType;
import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfLoadHelper;
import ghidra.app.util.bin.format.elf.ElfProgramHeader;
import ghidra.app.util.bin.format.elf.ElfProgramHeaderType;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfSectionHeaderType;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.ElfSymbolTable;
import ghidra.app.util.bin.format.elf.extend.ElfExtension;
import ghidra.app.util.bin.format.elf.relocation.MIPS_Elf64Relocation;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.EnumDataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.QWordDataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.WordDataType;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.task.TaskMonitor;
import java.math.BigInteger;

public class MIPS_ElfExtension
extends ElfExtension {
    private static final String MIPS_STUBS_SECTION_NAME = ".MIPS.stubs";
    public static final String MIPS_GP_VALUE_SYMBOL = "_mips_gp_value";
    public static final ElfProgramHeaderType PT_MIPS_REGINFO = new ElfProgramHeaderType(0x70000000, "PT_MIPS_REGINFO", "Register usage information.  Identifies one .reginfo section");
    public static final ElfProgramHeaderType PT_MIPS_RTPROC = new ElfProgramHeaderType(0x70000001, "PT_MIPS_RTPROC", "Runtime procedure table");
    public static final ElfProgramHeaderType PT_MIPS_OPTIONS = new ElfProgramHeaderType(0x70000002, "PT_MIPS_OPTIONS", ".MIPS.options section");
    public static final ElfProgramHeaderType PT_MIPS_ABIFLAGS = new ElfProgramHeaderType(0x70000003, "PT_MIPS_ABIFLAGS", "Records ABI related flags");
    public static final ElfSectionHeaderType SHT_MIPS_LIBLIST = new ElfSectionHeaderType(0x70000000, "SHT_MIPS_LIBLIST", "Section contains the set of dynamic shared objects used when statically linking");
    public static final ElfSectionHeaderType SHT_MIPS_MSYM = new ElfSectionHeaderType(0x70000001, "SHT_MIPS_MSYM", "");
    public static final ElfSectionHeaderType SHT_MIPS_CONFLICT = new ElfSectionHeaderType(0x70000002, "SHT_MIPS_CONFLICT", "Section contains list of symbols whose definitions conflict with symbols defined in shared objects");
    public static final ElfSectionHeaderType SHT_MIPS_GPTAB = new ElfSectionHeaderType(0x70000003, "SHT_MIPS_GPTAB", "Section contains the global pointer table");
    public static final ElfSectionHeaderType SHT_MIPS_UCODE = new ElfSectionHeaderType(0x70000004, "SHT_MIPS_UCODE", "Section contains microcode information");
    public static final ElfSectionHeaderType SHT_MIPS_DEBUG = new ElfSectionHeaderType(0x70000005, "SHT_MIPS_DEBUG", "Section contains some sort of debugging information");
    public static final ElfSectionHeaderType SHT_MIPS_REGINFO = new ElfSectionHeaderType(0x70000006, "SHT_MIPS_REGINFO", "Section contains register usage information");
    public static final ElfSectionHeaderType SHT_MIPS_PACKAGE = new ElfSectionHeaderType(0x70000007, "SHT_MIPS_PACKAGE", "");
    public static final ElfSectionHeaderType SHT_MIPS_PACKSYM = new ElfSectionHeaderType(0x70000008, "SHT_MIPS_PACKSYM", "");
    public static final ElfSectionHeaderType SHT_MIPS_RELD = new ElfSectionHeaderType(0x70000009, "SHT_MIPS_RELD", "");
    public static final ElfSectionHeaderType SHT_MIPS_IFACE = new ElfSectionHeaderType(0x7000000B, "", "Section contains interface information");
    public static final ElfSectionHeaderType SHT_MIPS_CONTENT = new ElfSectionHeaderType(0x7000000C, "SHT_MIPS_CONTENT", "Section contains description of contents of another section");
    public static final ElfSectionHeaderType SHT_MIPS_OPTIONS = new ElfSectionHeaderType(0x7000000D, "SHT_MIPS_OPTIONS", "Section contains miscellaneous options");
    public static final ElfSectionHeaderType SHT_MIPS_SHDR = new ElfSectionHeaderType(0x70000010, "SHT_MIPS_SHDR", "");
    public static final ElfSectionHeaderType SHT_MIPS_FDESC = new ElfSectionHeaderType(0x70000011, "SHT_MIPS_FDESC", "");
    public static final ElfSectionHeaderType SHT_MIPS_EXTSYM = new ElfSectionHeaderType(1879048210, "SHT_MIPS_EXTSYM", "");
    public static final ElfSectionHeaderType SHT_MIPS_DENSE = new ElfSectionHeaderType(1879048211, "SHT_MIPS_DENSE", "");
    public static final ElfSectionHeaderType SHT_MIPS_PDESC = new ElfSectionHeaderType(1879048212, "SHT_MIPS_PDESC", "");
    public static final ElfSectionHeaderType SHT_MIPS_LOCSYM = new ElfSectionHeaderType(1879048213, "SHT_MIPS_LOCSYM", "");
    public static final ElfSectionHeaderType SHT_MIPS_AUXSYM = new ElfSectionHeaderType(1879048214, "SHT_MIPS_AUXSYM", "");
    public static final ElfSectionHeaderType SHT_MIPS_OPTSYM = new ElfSectionHeaderType(0x70000017, "SHT_MIPS_OPTSYM", "");
    public static final ElfSectionHeaderType SHT_MIPS_LOCSTR = new ElfSectionHeaderType(1879048216, "SHT_MIPS_LOCSTR", "");
    public static final ElfSectionHeaderType SHT_MIPS_LINE = new ElfSectionHeaderType(1879048217, "SHT_MIPS_LINE", "");
    public static final ElfSectionHeaderType SHT_MIPS_RFDESC = new ElfSectionHeaderType(1879048218, "SHT_MIPS_RFDESC", "");
    public static final ElfSectionHeaderType SHT_MIPS_DELTASYM = new ElfSectionHeaderType(1879048219, "SHT_MIPS_DELTASYM", "Delta C++: symbol table");
    public static final ElfSectionHeaderType SHT_MIPS_DELTAINST = new ElfSectionHeaderType(1879048220, "SHT_MIPS_DELTAINST", "Delta C++: instance table");
    public static final ElfSectionHeaderType SHT_MIPS_DELTACLASS = new ElfSectionHeaderType(1879048221, "SHT_MIPS_DELTACLASS", "Delta C++: class table");
    public static final ElfSectionHeaderType SHT_MIPS_DWARF = new ElfSectionHeaderType(1879048222, "SHT_MIPS_DWARF", "DWARF debugging section");
    public static final ElfSectionHeaderType SHT_MIPS_DELTADECL = new ElfSectionHeaderType(1879048223, "SHT_MIPS_DELTADECL", "Delta C++: declarations");
    public static final ElfSectionHeaderType SHT_MIPS_SYMBOL_LIB = new ElfSectionHeaderType(0x70000020, "SHT_MIPS_SYMBOL_LIB", "List of libraries the binary depends on.  Includes a time stamp, version number");
    public static final ElfSectionHeaderType SHT_MIPS_EVENTS = new ElfSectionHeaderType(1879048225, "SHT_MIPS_EVENTS", "Events section");
    public static final ElfSectionHeaderType SHT_MIPS_TRANSLATE = new ElfSectionHeaderType(0x70000022, "SHT_MIPS_TRANSLATE", "");
    public static final ElfSectionHeaderType SHT_MIPS_PIXIE = new ElfSectionHeaderType(1879048227, "SHT_MIPS_PIXIE", "Special pixie sections");
    public static final ElfSectionHeaderType SHT_MIPS_XLATE = new ElfSectionHeaderType(1879048228, "SHT_MIPS_XLATE", "Address translation table (for debug info)");
    public static final ElfSectionHeaderType SHT_MIPS_XLATE_DEBUG = new ElfSectionHeaderType(1879048229, "SHT_MIPS_XLATE_DEBUG", "SGI internal address translation table (for debug info)");
    public static final ElfSectionHeaderType SHT_MIPS_WHIRL = new ElfSectionHeaderType(1879048230, "SHT_MIPS_WHIRL", "Intermediate code");
    public static final ElfSectionHeaderType SHT_MIPS_EH_REGION = new ElfSectionHeaderType(0x70000027, "SHT_MIPS_EH_REGION", "C++ exception handling region info");
    public static final ElfSectionHeaderType SHT_MIPS_XLATE_OLD = new ElfSectionHeaderType(1879048232, "SHT_MIPS_XLATE_OLD", "Obsolete address translation table (for debug info)");
    public static final ElfSectionHeaderType SHT_MIPS_PDR_EXCEPTION = new ElfSectionHeaderType(1879048233, "SHT_MIPS_PDR_EXCEPTION", "Runtime procedure descriptor table exception information");
    public static final ElfSectionHeaderType SHT_MIPS_ABIFLAGS = new ElfSectionHeaderType(1879048234, "SHT_MIPS_ABIFLAGS", "ABI related flags section");
    public static final ElfDynamicType DT_MIPS_RLD_VERSION = new ElfDynamicType(0x70000001, "DT_MIPS_RLD_VERSION", "32 bit version number for runtime linker interface", ElfDynamicType.ElfDynamicValueType.VALUE);
    public static final ElfDynamicType DT_MIPS_TIME_STAMP = new ElfDynamicType(0x70000002, "DT_MIPS_TIME_STAMP", "Time stamp", ElfDynamicType.ElfDynamicValueType.VALUE);
    public static final ElfDynamicType DT_MIPS_ICHECKSUM = new ElfDynamicType(0x70000003, "DT_MIPS_ICHECKSUM", "Checksum of external strings and common sizes", ElfDynamicType.ElfDynamicValueType.VALUE);
    public static final ElfDynamicType DT_MIPS_IVERSION = new ElfDynamicType(0x70000004, "DT_MIPS_IVERSION", "Index of version string in string table", ElfDynamicType.ElfDynamicValueType.STRING);
    public static final ElfDynamicType DT_MIPS_FLAGS = new ElfDynamicType(0x70000005, "DT_MIPS_FLAGS", "32 bits of flags", ElfDynamicType.ElfDynamicValueType.VALUE);
    public static final ElfDynamicType DT_MIPS_BASE_ADDRESS = new ElfDynamicType(0x70000006, "DT_MIPS_BASE_ADDRESS", "Base address of the segment", ElfDynamicType.ElfDynamicValueType.ADDRESS);
    public static final ElfDynamicType DT_MIPS_MSYM = new ElfDynamicType(0x70000007, "DT_MIPS_MSYM", "", ElfDynamicType.ElfDynamicValueType.VALUE);
    public static final ElfDynamicType DT_MIPS_CONFLICT = new ElfDynamicType(0x70000008, "DT_MIPS_CONFLICT", "Address of .conflict section", ElfDynamicType.ElfDynamicValueType.ADDRESS);
    public static final ElfDynamicType DT_MIPS_LIBLIST = new ElfDynamicType(0x70000009, "DT_MIPS_LIBLIST", "Address of .liblist section", ElfDynamicType.ElfDynamicValueType.ADDRESS);
    public static final ElfDynamicType DT_MIPS_LOCAL_GOTNO = new ElfDynamicType(0x7000000A, "DT_MIPS_LOCAL_GOTNO", "Number of local global offset table entries", ElfDynamicType.ElfDynamicValueType.VALUE);
    public static final ElfDynamicType DT_MIPS_CONFLICTNO = new ElfDynamicType(0x7000000B, "DT_MIPS_CONFLICTNO", "Number of entries in the .conflict section", ElfDynamicType.ElfDynamicValueType.VALUE);
    public static final ElfDynamicType DT_MIPS_LIBLISTNO = new ElfDynamicType(0x70000010, "DT_MIPS_LIBLISTNO", "Number of entries in the .liblist section", ElfDynamicType.ElfDynamicValueType.VALUE);
    public static final ElfDynamicType DT_MIPS_SYMTABNO = new ElfDynamicType(0x70000011, "DT_MIPS_SYMTABNO", "Number of entries in the .dynsym section", ElfDynamicType.ElfDynamicValueType.VALUE);
    public static final ElfDynamicType DT_MIPS_UNREFEXTNO = new ElfDynamicType(1879048210, "DT_MIPS_UNREFEXTNO", "Index of first external dynamic symbol not referenced locally", ElfDynamicType.ElfDynamicValueType.VALUE);
    public static final ElfDynamicType DT_MIPS_GOTSYM = new ElfDynamicType(1879048211, "DT_MIPS_GOTSYM", "Index of first dynamic symbol in global offset table", ElfDynamicType.ElfDynamicValueType.VALUE);
    public static final ElfDynamicType DT_MIPS_HIPAGENO = new ElfDynamicType(1879048212, "DT_MIPS_HIPAGENO", "Number of page table entries in global offset table", ElfDynamicType.ElfDynamicValueType.VALUE);
    public static final ElfDynamicType DT_MIPS_RLD_MAP = new ElfDynamicType(1879048214, "DT_MIPS_RLD_MAP", "Address of run time loader map, used for debugging", ElfDynamicType.ElfDynamicValueType.ADDRESS);
    public static final ElfDynamicType DT_MIPS_DELTA_CLASS = new ElfDynamicType(0x70000017, "DT_MIPS_DELTA_CLASS", "Delta C++ class definition", ElfDynamicType.ElfDynamicValueType.VALUE);
    public static final ElfDynamicType DT_MIPS_DELTA_CLASS_NO = new ElfDynamicType(1879048216, "DT_MIPS_DELTA_CLASS_NO", "Number of entries in DT_MIPS_DELTA_CLASS", ElfDynamicType.ElfDynamicValueType.VALUE);
    public static final ElfDynamicType DT_MIPS_DELTA_INSTANCE = new ElfDynamicType(1879048217, "DT_MIPS_DELTA_INSTANCE", "Delta C++ class instances", ElfDynamicType.ElfDynamicValueType.VALUE);
    public static final ElfDynamicType DT_MIPS_DELTA_INSTANCE_NO = new ElfDynamicType(1879048218, "DT_MIPS_DELTA_INSTANCE_NO", "Number of entries in DT_MIPS_DELTA_INSTANCE", ElfDynamicType.ElfDynamicValueType.VALUE);
    public static final ElfDynamicType DT_MIPS_DELTA_RELOC = new ElfDynamicType(1879048219, "DT_MIPS_DELTA_RELOC", "Delta relocations", ElfDynamicType.ElfDynamicValueType.ADDRESS);
    public static final ElfDynamicType DT_MIPS_DELTA_RELOC_NO = new ElfDynamicType(1879048220, "DT_MIPS_DELTA_RELOC_NO", "Number of entries in DT_MIPS_DELTA_RELOC", ElfDynamicType.ElfDynamicValueType.VALUE);
    public static final ElfDynamicType DT_MIPS_DELTA_SYM = new ElfDynamicType(1879048221, "DT_MIPS_DELTA_SYM", "Delta symbols that Delta relocations refer to", ElfDynamicType.ElfDynamicValueType.ADDRESS);
    public static final ElfDynamicType DT_MIPS_DELTA_SYM_NO = new ElfDynamicType(1879048222, "DT_MIPS_DELTA_SYM_NO", "Number of entries in DT_MIPS_DELTA_SYM", ElfDynamicType.ElfDynamicValueType.VALUE);
    public static final ElfDynamicType DT_MIPS_DELTA_CLASSSYM = new ElfDynamicType(0x70000020, "DT_MIPS_DELTA_CLASSSYM", "Delta symbols that hold class declarations", ElfDynamicType.ElfDynamicValueType.VALUE);
    public static final ElfDynamicType DT_MIPS_DELTA_CLASSSYM_NO = new ElfDynamicType(1879048225, "DT_MIPS_DELTA_CLASSSYM_NO", "Number of entries in DT_MIPS_DELTA_CLASSSYM", ElfDynamicType.ElfDynamicValueType.VALUE);
    public static final ElfDynamicType DT_MIPS_CXX_FLAGS = new ElfDynamicType(0x70000022, "DT_MIPS_CXX_FLAGS", "Flags indicating information about C++ flavor", ElfDynamicType.ElfDynamicValueType.VALUE);
    public static final ElfDynamicType DT_MIPS_PIXIE_INIT = new ElfDynamicType(1879048227, "DT_MIPS_PIXIE_INIT", "Pixie information", ElfDynamicType.ElfDynamicValueType.VALUE);
    public static final ElfDynamicType DT_MIPS_SYMBOL_LIB = new ElfDynamicType(1879048228, "DT_MIPS_SYMBOL_LIB", "Address of .MIPS.symlib", ElfDynamicType.ElfDynamicValueType.VALUE);
    public static final ElfDynamicType DT_MIPS_LOCALPAGE_GOTIDX = new ElfDynamicType(1879048229, "DT_MIPS_LOCALPAGE_GOTIDX", "The GOT index of the first PTE for a segment", ElfDynamicType.ElfDynamicValueType.VALUE);
    public static final ElfDynamicType DT_MIPS_LOCAL_GOTIDX = new ElfDynamicType(1879048230, "DT_MIPS_LOCAL_GOTIDX", "GOT index of the first PTE for a local symbol", ElfDynamicType.ElfDynamicValueType.VALUE);
    public static final ElfDynamicType DT_MIPS_HIDDEN_GOTIDX = new ElfDynamicType(0x70000027, "DT_MIPS_HIDDEN_GOTIDX", "The GOT index of the first PTE for a hidden symbol", ElfDynamicType.ElfDynamicValueType.VALUE);
    public static final ElfDynamicType DT_MIPS_PROTECTED_GOTIDX = new ElfDynamicType(1879048232, "DT_MIPS_PROTECTED_GOTIDX", "The GOT index of the first PTE for a protected symbol", ElfDynamicType.ElfDynamicValueType.VALUE);
    public static final ElfDynamicType DT_MIPS_OPTIONS = new ElfDynamicType(1879048233, "DT_MIPS_OPTIONS", "Address of `.MIPS.options'", ElfDynamicType.ElfDynamicValueType.ADDRESS);
    public static final ElfDynamicType DT_MIPS_INTERFACE = new ElfDynamicType(1879048234, "DT_MIPS_INTERFACE", "Address of `.interface'", ElfDynamicType.ElfDynamicValueType.ADDRESS);
    public static final ElfDynamicType DT_MIPS_DYNSTR_ALIGN = new ElfDynamicType(1879048235, "DT_MIPS_DYNSTR_ALIGN", "", ElfDynamicType.ElfDynamicValueType.VALUE);
    public static final ElfDynamicType DT_MIPS_INTERFACE_SIZE = new ElfDynamicType(1879048236, "DT_MIPS_INTERFACE_SIZE", "Size of the .interface section", ElfDynamicType.ElfDynamicValueType.VALUE);
    public static final ElfDynamicType DT_MIPS_RLD_TEXT_RESOLVE_ADDR = new ElfDynamicType(1879048237, "DT_MIPS_RLD_TEXT_RESOLVE_ADDR", "Size of rld_text_resolve function stored in the GOT", ElfDynamicType.ElfDynamicValueType.ADDRESS);
    public static final ElfDynamicType DT_MIPS_PERF_SUFFIX = new ElfDynamicType(1879048238, "DT_MIPS_PERF_SUFFIX", "Default suffix of DSO to be added by rld on dlopen() calls", ElfDynamicType.ElfDynamicValueType.VALUE);
    public static final ElfDynamicType DT_MIPS_COMPACT_SIZE = new ElfDynamicType(1879048239, "DT_MIPS_COMPACT_SIZE", "Size of compact relocation section (O32)", ElfDynamicType.ElfDynamicValueType.VALUE);
    public static final ElfDynamicType DT_MIPS_GP_VALUE = new ElfDynamicType(0x70000030, "DT_MIPS_GP_VALUE", "GP value for auxiliary GOTs", ElfDynamicType.ElfDynamicValueType.ADDRESS);
    public static final ElfDynamicType DT_MIPS_AUX_DYNAMIC = new ElfDynamicType(1879048241, "DT_MIPS_AUX_DYNAMIC", "Address of auxiliary .dynamic", ElfDynamicType.ElfDynamicValueType.ADDRESS);
    public static final ElfDynamicType DT_MIPS_PLTGOT = new ElfDynamicType(1879048242, "DT_MIPS_PLTGOT", "Address of the base of the PLTGOT", ElfDynamicType.ElfDynamicValueType.ADDRESS);
    public static final ElfDynamicType DT_MIPS_RWPLT = new ElfDynamicType(1879048244, "DT_MIPS_RWPLT", "Points to the base of a writable PLT", ElfDynamicType.ElfDynamicValueType.ADDRESS);
    public static final ElfDynamicType DT_MIPS_RLD_MAP_REL = new ElfDynamicType(1879048245, "DT_MIPS_RLD_MAP_REL", "Relative offset of run time loader map, used for debugging", ElfDynamicType.ElfDynamicValueType.VALUE);
    public static final int STO_MIPS_OPTIONAL = 4;
    public static final int STO_MIPS_PLT = 8;
    public static final int STO_MIPS_PIC = 32;
    public static final int STO_MIPS_MICROMIPS = 128;
    public static final int STO_MIPS_MIPS16 = 240;
    public static final byte ODK_NULL = 0;
    public static final byte ODK_REGINFO = 1;
    public static final byte ODK_EXCEPTIONS = 2;
    public static final byte ODK_PAD = 3;
    public static final byte ODK_HWPATCH = 4;
    public static final byte ODK_FILL = 5;
    public static final byte ODK_TAGS = 6;
    public static final byte ODK_HWAND = 7;
    public static final byte ODK_HWOR = 8;
    public static final byte ODK_GP_GROUP = 9;
    public static final byte ODK_IDENT = 10;
    public static final byte ODK_PAGESIZE = 11;

    public boolean canHandle(ElfHeader elf) {
        return elf.e_machine() == 8;
    }

    public boolean canHandle(ElfLoadHelper elfLoadHelper) {
        Language language = elfLoadHelper.getProgram().getLanguage();
        return this.canHandle(elfLoadHelper.getElfHeader()) && "MIPS".equals(language.getProcessor().toString());
    }

    public String getDataTypeSuffix() {
        return "_MIPS";
    }

    public Address creatingFunction(ElfLoadHelper elfLoadHelper, Address functionAddress) {
        Program program = elfLoadHelper.getProgram();
        Register isaModeRegister = program.getRegister("ISA_MODE");
        if (isaModeRegister == null) {
            return functionAddress;
        }
        if ((functionAddress.getOffset() & 1L) != 0L) {
            functionAddress = functionAddress.previous();
            try {
                program.getProgramContext().setValue(isaModeRegister, functionAddress, functionAddress, BigInteger.ONE);
            }
            catch (ContextChangeException contextChangeException) {
                // empty catch block
            }
        }
        return functionAddress;
    }

    public Address evaluateElfSymbol(ElfLoadHelper elfLoadHelper, ElfSymbol elfSymbol, Address address, boolean isExternal) {
        this.updateNonRelocatebleGotEntries(elfLoadHelper, elfSymbol, address);
        if (isExternal) {
            return address;
        }
        if (elfSymbol.getType() == 2) {
            Program program = elfLoadHelper.getProgram();
            Register isaModeRegister = program.getRegister("ISA_MODE");
            if (isaModeRegister != null) {
                address = this.applyIsaMode(elfSymbol, address, isaModeRegister, program);
            }
            if (!isExternal && (elfSymbol.getOther() & 8) != 0) {
                elfLoadHelper.createExternalFunctionLinkage(elfSymbol.getNameAsString(), address, null);
            }
        }
        return address;
    }

    private Address applyIsaMode(ElfSymbol elfSymbol, Address address, Register isaModeRegister, Program program) {
        int mipsMode = elfSymbol.getOther() & 0xF0;
        long symVal = address.getOffset();
        boolean enableISA = false;
        if ((symVal & 1L) != 0L) {
            enableISA = true;
            address = address.previous();
        } else {
            boolean bl = enableISA = mipsMode == 240 || mipsMode == 128;
        }
        if (enableISA) {
            try {
                program.getProgramContext().setValue(isaModeRegister, address, address, BigInteger.ONE);
            }
            catch (ContextChangeException contextChangeException) {
                // empty catch block
            }
        }
        return address;
    }

    private void updateNonRelocatebleGotEntries(ElfLoadHelper elfLoadHelper, ElfSymbol elfSymbol, Address address) {
        ElfHeader elfHeader = elfLoadHelper.getElfHeader();
        if (elfHeader.isRelocatable() || !elfSymbol.getSymbolTable().isDynamic()) {
            return;
        }
        Long gotBaseOffset = elfLoadHelper.getGOTValue();
        if (gotBaseOffset == null) {
            return;
        }
        ElfDynamicTable dynamicTable = elfHeader.getDynamicTable();
        if (dynamicTable == null || !dynamicTable.containsDynamicValue(DT_MIPS_LOCAL_GOTNO) || !dynamicTable.containsDynamicValue(DT_MIPS_GOTSYM)) {
            return;
        }
        try {
            int gotLocalEntryCount = (int)dynamicTable.getDynamicValue(DT_MIPS_LOCAL_GOTNO);
            int gotSymbolIndex = (int)dynamicTable.getDynamicValue(DT_MIPS_GOTSYM);
            int symbolIndex = elfSymbol.getSymbolTableIndex();
            if (symbolIndex < gotSymbolIndex) {
                return;
            }
            int gotIndex = gotLocalEntryCount + (symbolIndex - gotSymbolIndex);
            Program program = elfLoadHelper.getProgram();
            Address gotBaseAddress = program.getAddressFactory().getDefaultAddressSpace().getAddress(gotBaseOffset.longValue());
            long imageShift = elfLoadHelper.getImageBaseWordAdjustmentOffset();
            long symbolOffset = address.getOffset() - imageShift;
            this.setTableEntryIfZero(gotBaseAddress, gotIndex, symbolOffset, elfLoadHelper);
        }
        catch (MemoryAccessException e) {
            Msg.error((Object)((Object)this), (Object)"Failed to update .got table entry", (Throwable)e);
        }
        catch (NotFoundException e) {
            throw new AssertException("unexpected", (Throwable)e);
        }
    }

    public void processElf(ElfLoadHelper elfLoadHelper, TaskMonitor monitor) throws CancelledException {
        this.processMipsHeaders(elfLoadHelper, monitor);
        this.processMipsDyanmics(elfLoadHelper, monitor);
    }

    private void processMipsDyanmics(ElfLoadHelper elfLoadHelper, TaskMonitor monitor) {
        ElfDynamicTable dynamicTable = elfLoadHelper.getElfHeader().getDynamicTable();
        if (dynamicTable != null && dynamicTable.containsDynamicValue(DT_MIPS_GP_VALUE)) {
            try {
                ElfHeader elf = elfLoadHelper.getElfHeader();
                long gpValue = elf.adjustAddressForPrelink(dynamicTable.getDynamicValue(DT_MIPS_GP_VALUE));
                Address gpAddr = elfLoadHelper.getDefaultAddress(gpValue);
                elfLoadHelper.createSymbol(gpAddr, MIPS_GP_VALUE_SYMBOL, false, false, null);
                elfLoadHelper.log("_mips_gp_value=0x" + Long.toHexString(gpValue));
            }
            catch (InvalidInputException | NotFoundException throwable) {
                // empty catch block
            }
        }
    }

    private void processMipsHeaders(ElfLoadHelper elfLoadHelper, TaskMonitor monitor) {
        ElfDynamicTable dynamicTable;
        int headertype;
        ElfHeader elf = elfLoadHelper.getElfHeader();
        Address mipsOptionsAddr = null;
        Address regInfoAddr = null;
        for (ElfProgramHeader elfProgramHeader : elf.getProgramHeaders()) {
            headertype = elfProgramHeader.getType();
            if (headertype == MIPS_ElfExtension.PT_MIPS_OPTIONS.value) {
                mipsOptionsAddr = elfLoadHelper.findLoadAddress((MemoryLoadable)elfProgramHeader, 0L);
                continue;
            }
            if (headertype != MIPS_ElfExtension.PT_MIPS_REGINFO.value) continue;
            regInfoAddr = elfLoadHelper.findLoadAddress((MemoryLoadable)elfProgramHeader, 0L);
        }
        for (ElfProgramHeader elfProgramHeader : elf.getSections()) {
            headertype = elfProgramHeader.getType();
            if (headertype == MIPS_ElfExtension.SHT_MIPS_OPTIONS.value) {
                mipsOptionsAddr = elfLoadHelper.findLoadAddress((MemoryLoadable)elfProgramHeader, 0L);
                continue;
            }
            if (headertype != MIPS_ElfExtension.SHT_MIPS_REGINFO.value) continue;
            regInfoAddr = elfLoadHelper.findLoadAddress((MemoryLoadable)elfProgramHeader, 0L);
        }
        if (mipsOptionsAddr == null && (dynamicTable = elf.getDynamicTable()) != null && dynamicTable.containsDynamicValue(DT_MIPS_OPTIONS)) {
            try {
                long optionsOffset = elf.adjustAddressForPrelink(dynamicTable.getDynamicValue(DT_MIPS_OPTIONS));
                mipsOptionsAddr = elfLoadHelper.getDefaultAddress(optionsOffset);
            }
            catch (NotFoundException e) {
                throw new AssertException("unexpected", (Throwable)e);
            }
        }
        if (mipsOptionsAddr != null) {
            this.processMipsOptions(elfLoadHelper, mipsOptionsAddr);
        }
        if (regInfoAddr != null) {
            this.processMipsRegInfo(elfLoadHelper, regInfoAddr);
        }
    }

    private void processMipsOptions(ElfLoadHelper elfLoadHelper, Address mipsOptionsAddr) {
        boolean elf64 = elfLoadHelper.getElfHeader().is64Bit();
        String prefix = elf64 ? "Elf64" : "Elf32";
        EnumDataType odkType = new EnumDataType(prefix + "_MipsOptionKind", 1);
        odkType.add("ODK_NULL", 0L);
        odkType.add("ODK_REGINFO", 1L);
        odkType.add("ODK_EXCEPTIONS", 2L);
        odkType.add("ODK_PAD", 3L);
        odkType.add("ODK_HWPATCH", 4L);
        odkType.add("ODK_FILL", 5L);
        odkType.add("ODK_TAGS", 6L);
        odkType.add("ODK_HWAND", 7L);
        odkType.add("ODK_HWOR", 8L);
        odkType.add("ODK_GP_GROUP", 9L);
        odkType.add("ODK_IDENT", 10L);
        odkType.add("ODK_PAGESIZE", 11L);
        StructureDataType odkHeader = new StructureDataType(new CategoryPath("/ELF"), prefix + "_MipsOptionHeader", 0);
        odkHeader.add((DataType)odkType, "kind", null);
        odkHeader.add((DataType)ByteDataType.dataType, "size", null);
        odkHeader.add((DataType)WordDataType.dataType, "section", null);
        odkHeader.add((DataType)DWordDataType.dataType, "info", null);
        Structure odkRegInfo = this.buildRegInfoStructure(elf64, true);
        Memory memory = elfLoadHelper.getProgram().getMemory();
        long limit = 0L;
        MemoryBlock block = memory.getBlock(mipsOptionsAddr);
        if (block != null) {
            limit = block.getEnd().subtract(mipsOptionsAddr) + 1L;
        }
        Address nextOptionAddr = mipsOptionsAddr;
        int optionDataSize = 0;
        try {
            byte kind;
            while (limit >= (long)odkHeader.getLength() && (kind = memory.getByte(nextOptionAddr = nextOptionAddr.add((long)optionDataSize))) != 0) {
                Data odkData = elfLoadHelper.createData(nextOptionAddr, (DataType)odkHeader);
                if (odkData == null) {
                    throw new MemoryAccessException();
                }
                int size = (memory.getByte(nextOptionAddr.next()) & 0xFF) - odkData.getLength();
                optionDataSize = size + size % 8;
                if (memory.getByte(nextOptionAddr) != 0) {
                    nextOptionAddr = nextOptionAddr.add((long)odkData.getLength());
                    switch (kind) {
                        case 1: {
                            Data regInfoData = elfLoadHelper.createData(nextOptionAddr, (DataType)odkRegInfo);
                            break;
                        }
                        default: {
                            elfLoadHelper.createData(nextOptionAddr, (DataType)new ArrayDataType((DataType)ByteDataType.dataType, optionDataSize, 1));
                        }
                    }
                    limit -= (long)(odkHeader.getLength() + optionDataSize);
                    continue;
                }
                break;
            }
        }
        catch (AddressOutOfBoundsException | MemoryAccessException throwable) {
            // empty catch block
        }
        elfLoadHelper.log("WARNING: .MIPS.options section has not been processed (not yet implemented)");
    }

    private Structure buildRegInfoStructure(boolean elf64, boolean mipsOptions) {
        String prefix = elf64 ? "Elf64" : "Elf32";
        EnumDataType gprMask = new EnumDataType(prefix + "_GPRMask_MIPS", 4);
        gprMask.add("gpr_zero", 1L);
        gprMask.add("gpr_at", 2L);
        gprMask.add("gpr_v0", 4L);
        gprMask.add("gpr_v1", 8L);
        gprMask.add("gpr_a0", 16L);
        gprMask.add("gpr_a1", 32L);
        gprMask.add("gpr_a2", 64L);
        gprMask.add("gpr_a3", 128L);
        gprMask.add("gpr_t0", 256L);
        gprMask.add("gpr_t1", 512L);
        gprMask.add("gpr_t2", 1024L);
        gprMask.add("gpr_t3", 2048L);
        gprMask.add("gpr_t4", 4096L);
        gprMask.add("gpr_t5", 8192L);
        gprMask.add("gpr_t6", 16384L);
        gprMask.add("gpr_t7", 32768L);
        gprMask.add("gpr_s0", 65536L);
        gprMask.add("gpr_s1", 131072L);
        gprMask.add("gpr_s2", 262144L);
        gprMask.add("gpr_s3", 524288L);
        gprMask.add("gpr_s4", 0x100000L);
        gprMask.add("gpr_s5", 0x200000L);
        gprMask.add("gpr_s6", 0x400000L);
        gprMask.add("gpr_s7", 0x800000L);
        gprMask.add("gpr_t8", 0x1000000L);
        gprMask.add("gpr_t9", 0x2000000L);
        gprMask.add("gpr_k0", 0x4000000L);
        gprMask.add("gpr_k1", 0x8000000L);
        gprMask.add("gpr_gp", 0x10000000L);
        gprMask.add("gpr_sp", 0x20000000L);
        gprMask.add("gpr_fp", 0x40000000L);
        gprMask.add("gpr_ra", 0x80000000L);
        StructureDataType regInfoStruct = new StructureDataType(new CategoryPath("/ELF"), prefix + "_RegInfo_MIPS", 0);
        regInfoStruct.add((DataType)gprMask, "ri_gprmask", null);
        if (mipsOptions && elf64) {
            regInfoStruct.add((DataType)DWordDataType.dataType, "ri_pad", null);
        }
        regInfoStruct.add((DataType)new ArrayDataType((DataType)DWordDataType.dataType, 4, 4));
        if (mipsOptions & elf64) {
            regInfoStruct.add((DataType)QWordDataType.dataType, "ri_gp_value", null);
        } else {
            regInfoStruct.add((DataType)DWordDataType.dataType, "ri_gp_value", null);
        }
        return regInfoStruct;
    }

    private void processMipsRegInfo(ElfLoadHelper elfLoadHelper, Address regInfoAddr) {
        Structure regInfoStruct = this.buildRegInfoStructure(elfLoadHelper.getElfHeader().is64Bit(), false);
        Data data = elfLoadHelper.createData(regInfoAddr, (DataType)regInfoStruct);
        Data gpValueComponent = data.getComponent(5);
        if (gpValueComponent != null) {
            try {
                Scalar gpValue = gpValueComponent.getScalar(0);
                Address gpAddr = elfLoadHelper.getDefaultAddress(gpValue.getUnsignedValue());
                elfLoadHelper.createSymbol(gpAddr, MIPS_GP_VALUE_SYMBOL, false, false, null);
                elfLoadHelper.log("_mips_gp_value=0x" + Long.toHexString(gpValue.getUnsignedValue()));
            }
            catch (InvalidInputException invalidInputException) {
                // empty catch block
            }
        }
    }

    public void processGotPlt(ElfLoadHelper elfLoadHelper, TaskMonitor monitor) throws CancelledException {
        this.fixupGot(elfLoadHelper, monitor);
        this.fixupMipsGot(elfLoadHelper, monitor);
        super.processGotPlt(elfLoadHelper, monitor);
        this.processMipsStubsSection(elfLoadHelper, monitor);
    }

    private void processMipsStubsSection(ElfLoadHelper elfLoadHelper, TaskMonitor monitor) throws CancelledException {
        Memory memory = elfLoadHelper.getProgram().getMemory();
        MemoryBlock stubsBlock = memory.getBlock(MIPS_STUBS_SECTION_NAME);
        if (stubsBlock == null || !stubsBlock.isExecute()) {
            return;
        }
        ElfDefaultGotPltMarkup defaultGotPltMarkup = new ElfDefaultGotPltMarkup(elfLoadHelper);
        defaultGotPltMarkup.processLinkageTable(MIPS_STUBS_SECTION_NAME, stubsBlock.getStart(), stubsBlock.getEnd(), monitor);
    }

    private void fixupGot(ElfLoadHelper elfLoadHelper, TaskMonitor monitor) {
        ElfHeader elfHeader = elfLoadHelper.getElfHeader();
        ElfDynamicTable dynamicTable = elfHeader.getDynamicTable();
        ElfSymbolTable dynamicSymbolTable = elfHeader.getDynamicSymbolTable();
        if (dynamicTable == null || dynamicSymbolTable == null) {
            return;
        }
        if (!dynamicTable.containsDynamicValue(DT_MIPS_LOCAL_GOTNO) || !dynamicTable.containsDynamicValue(DT_MIPS_GOTSYM)) {
            return;
        }
        Program program = elfLoadHelper.getProgram();
        Long gotBaseOffset = elfLoadHelper.getGOTValue();
        if (gotBaseOffset == null) {
            return;
        }
        Address gotBaseAddress = program.getAddressFactory().getDefaultAddressSpace().getAddress(gotBaseOffset.longValue());
        try {
            ElfSymbol[] elfSymbols = dynamicSymbolTable.getSymbols();
            int gotLocalEntryCount = (int)dynamicTable.getDynamicValue(DT_MIPS_LOCAL_GOTNO);
            int gotSymbolIndex = (int)dynamicTable.getDynamicValue(DT_MIPS_GOTSYM);
            long imageShift = elfLoadHelper.getImageBaseWordAdjustmentOffset();
            for (int i = 0; i < gotLocalEntryCount; ++i) {
                Address gotEntryAddr = this.adjustTableEntryIfNonZero(gotBaseAddress, i, imageShift, elfLoadHelper);
                Data pointerData = elfLoadHelper.createData(gotEntryAddr, (DataType)PointerDataType.dataType);
                this.setConstant(pointerData);
            }
            int gotIndex = gotLocalEntryCount;
            for (int i = gotSymbolIndex; i < elfSymbols.length; ++i) {
                Address gotEntryAddr = this.adjustTableEntryIfNonZero(gotBaseAddress, gotIndex++, imageShift, elfLoadHelper);
                Data pointerData = elfLoadHelper.createData(gotEntryAddr, (DataType)PointerDataType.dataType);
                this.setConstant(pointerData);
                if (!elfSymbols[i].isFunction() || elfSymbols[i].getSectionHeaderIndex() != 0) continue;
                Address refAddr = (Address)pointerData.getValue();
                elfLoadHelper.createExternalFunctionLinkage(elfSymbols[i].getNameAsString(), refAddr, gotEntryAddr);
            }
        }
        catch (NotFoundException e) {
            throw new AssertException("unexpected", (Throwable)e);
        }
        catch (MemoryAccessException e) {
            elfLoadHelper.log("Failed to adjust GOT: " + e.getMessage());
        }
    }

    private void fixupMipsGot(ElfLoadHelper elfLoadHelper, TaskMonitor monitor) {
        ElfHeader elfHeader = elfLoadHelper.getElfHeader();
        ElfDynamicTable dynamicTable = elfHeader.getDynamicTable();
        ElfSymbolTable dynamicSymbolTable = elfHeader.getDynamicSymbolTable();
        if (dynamicTable == null || dynamicSymbolTable == null) {
            return;
        }
        ElfSymbol[] elfSymbols = dynamicSymbolTable.getSymbols();
        if (!dynamicTable.containsDynamicValue(DT_MIPS_PLTGOT) || !dynamicTable.containsDynamicValue(DT_MIPS_GOTSYM)) {
            return;
        }
        Program program = elfLoadHelper.getProgram();
        Symbol mipsPltgotSym = SymbolUtilities.getLabelOrFunctionSymbol((Program)program, (String)"__DT_MIPS_PLTGOT", err -> elfLoadHelper.getLog().appendMsg(err));
        if (mipsPltgotSym == null) {
            return;
        }
        Address mipsPltgotBase = mipsPltgotSym.getAddress();
        try {
            int gotSymbolIndex = (int)dynamicTable.getDynamicValue(DT_MIPS_GOTSYM);
            long imageShift = elfLoadHelper.getImageBaseWordAdjustmentOffset();
            int gotEntryIndex = 1;
            for (int i = 0; i < gotSymbolIndex; ++i) {
                if (!elfSymbols[i].isFunction() || elfSymbols[i].getSectionHeaderIndex() != 0) continue;
                Address gotEntryAddr = this.adjustTableEntryIfNonZero(mipsPltgotBase, ++gotEntryIndex, imageShift, elfLoadHelper);
                Data pointerData = elfLoadHelper.createData(gotEntryAddr, (DataType)PointerDataType.dataType);
                this.setConstant(pointerData);
            }
        }
        catch (NotFoundException e) {
            throw new AssertException("unexpected", (Throwable)e);
        }
        catch (MemoryAccessException e) {
            elfLoadHelper.log("Failed to adjust MIPS GOT: " + e.getMessage());
        }
    }

    private void setConstant(Data pointerData) {
        Memory memory = pointerData.getProgram().getMemory();
        MemoryBlock block = memory.getBlock(pointerData.getAddress());
        if (!block.isWrite() || block.getName().startsWith(".got")) {
            return;
        }
        pointerData.setLong("mutability", 2L);
    }

    private Address adjustTableEntryIfNonZero(Address tableBaseAddr, int entryIndex, long adjustment, ElfLoadHelper elfLoadHelper) throws MemoryAccessException {
        Address tableEntryAddr;
        boolean is64Bit = elfLoadHelper.getElfHeader().is64Bit();
        Memory memory = elfLoadHelper.getProgram().getMemory();
        if (is64Bit) {
            tableEntryAddr = tableBaseAddr.add((long)(entryIndex * 8));
            long offset = memory.getLong(tableEntryAddr);
            if (offset != 0L) {
                memory.setLong(tableEntryAddr, offset + adjustment);
            }
        } else {
            tableEntryAddr = tableBaseAddr.add((long)(entryIndex * 4));
            int offset = memory.getInt(tableEntryAddr);
            if (offset != 0) {
                memory.setInt(tableEntryAddr, (int)((long)offset + adjustment));
            }
        }
        return tableEntryAddr;
    }

    private Address setTableEntryIfZero(Address tableBaseAddr, int entryIndex, long value, ElfLoadHelper elfLoadHelper) throws MemoryAccessException {
        Address tableEntryAddr;
        boolean is64Bit = elfLoadHelper.getElfHeader().is64Bit();
        Memory memory = elfLoadHelper.getProgram().getMemory();
        if (is64Bit) {
            tableEntryAddr = tableBaseAddr.add((long)(entryIndex * 8));
            long offset = memory.getLong(tableEntryAddr);
            if (offset == 0L) {
                memory.setLong(tableEntryAddr, value);
            }
        } else {
            tableEntryAddr = tableBaseAddr.add((long)(entryIndex * 4));
            int offset = memory.getInt(tableEntryAddr);
            if (offset == 0) {
                memory.setInt(tableEntryAddr, (int)value);
            }
        }
        return tableEntryAddr;
    }

    public Class<? extends ElfRelocation> getRelocationClass(ElfHeader elfHeader) {
        if (elfHeader.is64Bit()) {
            return MIPS_Elf64Relocation.class;
        }
        return super.getRelocationClass(elfHeader);
    }
}

