/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.AnalyzerCaster;
import org.elasticsearch.painless.ClassWriter;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.Operation;
import org.elasticsearch.painless.ScriptRoot;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.elasticsearch.painless.lookup.def;
import org.elasticsearch.painless.node.AExpression;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

public final class EUnary
extends AExpression {
    private final Operation operation;
    private AExpression child;
    private Class<?> promote;
    private boolean originallyExplicit = false;

    public EUnary(Location location, Operation operation, AExpression child) {
        super(location);
        this.operation = Objects.requireNonNull(operation);
        this.child = Objects.requireNonNull(child);
    }

    @Override
    void extractVariables(Set<String> variables) {
        this.child.extractVariables(variables);
    }

    @Override
    void analyze(ScriptRoot scriptRoot, Locals locals) {
        this.originallyExplicit = this.explicit;
        if (this.operation == Operation.NOT) {
            this.analyzeNot(scriptRoot, locals);
        } else if (this.operation == Operation.BWNOT) {
            this.analyzeBWNot(scriptRoot, locals);
        } else if (this.operation == Operation.ADD) {
            this.analyzerAdd(scriptRoot, locals);
        } else if (this.operation == Operation.SUB) {
            this.analyzerSub(scriptRoot, locals);
        } else {
            throw this.createError(new IllegalStateException("Illegal tree structure."));
        }
    }

    void analyzeNot(ScriptRoot scriptRoot, Locals variables) {
        this.child.expected = Boolean.TYPE;
        this.child.analyze(scriptRoot, variables);
        this.child = this.child.cast(scriptRoot, variables);
        if (this.child.constant != null) {
            this.constant = (Boolean)this.child.constant == false;
        }
        this.actual = Boolean.TYPE;
    }

    void analyzeBWNot(ScriptRoot scriptRoot, Locals variables) {
        this.child.analyze(scriptRoot, variables);
        this.promote = AnalyzerCaster.promoteNumeric(this.child.actual, false);
        if (this.promote == null) {
            throw this.createError(new ClassCastException("Cannot apply not [~] to type [" + PainlessLookupUtility.typeToCanonicalTypeName(this.child.actual) + "]."));
        }
        this.child.expected = this.promote;
        this.child = this.child.cast(scriptRoot, variables);
        if (this.child.constant != null) {
            if (this.promote == Integer.TYPE) {
                this.constant = ~((Integer)this.child.constant).intValue();
            } else if (this.promote == Long.TYPE) {
                this.constant = (Long)this.child.constant ^ 0xFFFFFFFFFFFFFFFFL;
            } else {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
        this.actual = this.promote == def.class && this.expected != null ? this.expected : this.promote;
    }

    void analyzerAdd(ScriptRoot scriptRoot, Locals variables) {
        this.child.analyze(scriptRoot, variables);
        this.promote = AnalyzerCaster.promoteNumeric(this.child.actual, true);
        if (this.promote == null) {
            throw this.createError(new ClassCastException("Cannot apply positive [+] to type [" + PainlessLookupUtility.typeToJavaType(this.child.actual) + "]."));
        }
        this.child.expected = this.promote;
        this.child = this.child.cast(scriptRoot, variables);
        if (this.child.constant != null) {
            if (this.promote == Integer.TYPE) {
                this.constant = (int)((Integer)this.child.constant);
            } else if (this.promote == Long.TYPE) {
                this.constant = (long)((Long)this.child.constant);
            } else if (this.promote == Float.TYPE) {
                this.constant = Float.valueOf(((Float)this.child.constant).floatValue());
            } else if (this.promote == Double.TYPE) {
                this.constant = (double)((Double)this.child.constant);
            } else {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
        this.actual = this.promote == def.class && this.expected != null ? this.expected : this.promote;
    }

    void analyzerSub(ScriptRoot scriptRoot, Locals variables) {
        this.child.analyze(scriptRoot, variables);
        this.promote = AnalyzerCaster.promoteNumeric(this.child.actual, true);
        if (this.promote == null) {
            throw this.createError(new ClassCastException("Cannot apply negative [-] to type [" + PainlessLookupUtility.typeToJavaType(this.child.actual) + "]."));
        }
        this.child.expected = this.promote;
        this.child = this.child.cast(scriptRoot, variables);
        if (this.child.constant != null) {
            if (this.promote == Integer.TYPE) {
                this.constant = -((Integer)this.child.constant).intValue();
            } else if (this.promote == Long.TYPE) {
                this.constant = -((Long)this.child.constant).longValue();
            } else if (this.promote == Float.TYPE) {
                this.constant = Float.valueOf(-((Float)this.child.constant).floatValue());
            } else if (this.promote == Double.TYPE) {
                this.constant = -((Double)this.child.constant).doubleValue();
            } else {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
        this.actual = this.promote == def.class && this.expected != null ? this.expected : this.promote;
    }

    @Override
    void write(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
        methodWriter.writeDebugInfo(this.location);
        if (this.operation == Operation.NOT) {
            Label fals = new Label();
            Label end = new Label();
            this.child.write(classWriter, methodWriter, globals);
            methodWriter.ifZCmp(153, fals);
            methodWriter.push(false);
            methodWriter.goTo(end);
            methodWriter.mark(fals);
            methodWriter.push(true);
            methodWriter.mark(end);
        } else {
            this.child.write(classWriter, methodWriter, globals);
            int defFlags = 0;
            if (this.originallyExplicit) {
                defFlags |= 4;
            }
            Type actualType = MethodWriter.getType(this.actual);
            Type childType = MethodWriter.getType(this.child.actual);
            if (this.operation == Operation.BWNOT) {
                if (this.promote == def.class) {
                    Type descriptor = Type.getMethodType((Type)actualType, (Type[])new Type[]{childType});
                    methodWriter.invokeDefCall("not", descriptor, 7, defFlags);
                } else {
                    if (this.promote == Integer.TYPE) {
                        methodWriter.push(-1);
                    } else if (this.promote == Long.TYPE) {
                        methodWriter.push(-1L);
                    } else {
                        throw this.createError(new IllegalStateException("Illegal tree structure."));
                    }
                    methodWriter.math(130, actualType);
                }
            } else if (this.operation == Operation.SUB) {
                if (this.promote == def.class) {
                    Type descriptor = Type.getMethodType((Type)actualType, (Type[])new Type[]{childType});
                    methodWriter.invokeDefCall("neg", descriptor, 7, defFlags);
                } else {
                    methodWriter.math(116, actualType);
                }
            } else if (this.operation == Operation.ADD) {
                if (this.promote == def.class) {
                    Type descriptor = Type.getMethodType((Type)actualType, (Type[])new Type[]{childType});
                    methodWriter.invokeDefCall("plus", descriptor, 7, defFlags);
                }
            } else {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
    }

    @Override
    public String toString() {
        return this.singleLineToString(this.operation.symbol, this.child);
    }
}

