/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.vcslinks.comments;

import com.almworks.tracklink.IssueLinkModel;
import com.almworks.tracklink.codelinks.CodeLinkType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CommentParser {
    private final String myComment;
    private final IssueLinkModel myModel;
    private List<String> myUrls = null;

    public CommentParser(String comment, IssueLinkModel model) {
        this.myComment = comment == null ? "" : comment;
        this.myModel = model;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public List<String> getUrls() {
        if (this.myUrls == null) {
            this.myUrls = this.buildUrls();
        }
        List<String> list = this.myUrls;
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/almworks/tracklink/vcslinks/comments/CommentParser.getUrls must not return null");
        }
        return list;
    }

    private List<String> buildUrls() {
        if (this.myComment.length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> urls = new ArrayList<String>();
        List<CodeLinkType> types = this.myModel.getReferenceTypes();
        block0: for (CodeLinkType type : types) {
            String replacement;
            Pattern pattern = type.getPattern();
            if (pattern == null || (replacement = type.getReplacePattern().trim()).length() == 0) continue;
            Matcher matcher = pattern.matcher(this.myComment);
            StringBuffer buf = new StringBuffer();
            int last = 0;
            while (matcher.find()) {
                int extra = matcher.start() - last;
                last = matcher.end();
                int start = buf.length() + extra;
                matcher.appendReplacement(buf, replacement);
                if (buf.length() < start) {
                    assert (false) : buf + " " + this.myComment;
                    continue block0;
                }
                String url = buf.substring(start);
                if (url.length() <= 0) continue;
                urls.add(url);
            }
        }
        return urls;
    }
}

