/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.codehaus.plexus.util.FileUtils;

public final class WagonUtils {
    private WagonUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(String resource2, Wagon wagon) throws IOException, TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        File file2 = null;
        try {
            file2 = File.createTempFile("wagon", "tmp");
            wagon.get(resource2, file2);
            String string2 = FileUtils.fileRead(file2);
            return string2;
        }
        finally {
            boolean deleted;
            if (file2 != null && !(deleted = file2.delete())) {
                file2.deleteOnExit();
            }
        }
    }

    public static void putDirectory(File dir2, Wagon wagon, boolean includeBasdir) throws ResourceDoesNotExistException, TransferFailedException, AuthorizationException {
        LinkedList<String> queue = new LinkedList<String>();
        if (includeBasdir) {
            queue.add(dir2.getName());
        } else {
            queue.add("");
        }
        while (!queue.isEmpty()) {
            String path2 = (String)queue.removeFirst();
            File currentDir = new File(dir2, path2);
            File[] files = currentDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File file2 = files[i];
                String resource2 = path2.length() > 0 ? path2 + "/" + file2.getName() : file2.getName();
                if (file2.isDirectory()) {
                    queue.add(resource2);
                    continue;
                }
                wagon.put(file2, resource2);
            }
        }
    }
}

