/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.config;

import javax.jms.MessageListener;
import org.springframework.jms.config.JmsListenerEndpoint;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.listener.MessageListenerContainer;
import org.springframework.jms.listener.endpoint.JmsActivationSpecConfig;
import org.springframework.jms.listener.endpoint.JmsMessageEndpointManager;
import org.springframework.util.Assert;

public abstract class AbstractJmsListenerEndpoint
implements JmsListenerEndpoint {
    private String id;
    private String destination;
    private String subscription;
    private String selector;
    private String concurrency;

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setSubscription(String subscription) {
        this.subscription = subscription;
    }

    public String getSubscription() {
        return this.subscription;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    public String getSelector() {
        return this.selector;
    }

    public void setConcurrency(String concurrency) {
        this.concurrency = concurrency;
    }

    public String getConcurrency() {
        return this.concurrency;
    }

    @Override
    public void setupListenerContainer(MessageListenerContainer listenerContainer) {
        if (listenerContainer instanceof AbstractMessageListenerContainer) {
            this.setupJmsListenerContainer((AbstractMessageListenerContainer)listenerContainer);
        } else {
            new JcaEndpointConfigurer().configureEndpoint(listenerContainer);
        }
    }

    private void setupJmsListenerContainer(AbstractMessageListenerContainer listenerContainer) {
        if (this.getDestination() != null) {
            listenerContainer.setDestinationName(this.getDestination());
        }
        if (this.getSubscription() != null) {
            listenerContainer.setSubscriptionName(this.getSubscription());
        }
        if (this.getSelector() != null) {
            listenerContainer.setMessageSelector(this.getSelector());
        }
        if (this.getConcurrency() != null) {
            listenerContainer.setConcurrency(this.getConcurrency());
        }
        this.setupMessageListener(listenerContainer);
    }

    protected abstract MessageListener createMessageListener(MessageListenerContainer var1);

    private void setupMessageListener(MessageListenerContainer container) {
        MessageListener messageListener = this.createMessageListener(container);
        Assert.state(messageListener != null, "Endpoint [" + this + "] must provide a non null message listener");
        container.setupMessageListener(messageListener);
    }

    protected StringBuilder getEndpointDescription() {
        StringBuilder result = new StringBuilder();
        return result.append(this.getClass().getSimpleName()).append("[").append(this.id).append("] destination=").append(this.destination).append("' | subscription='").append(this.subscription).append(" | selector='").append(this.selector).append("'");
    }

    public String toString() {
        return this.getEndpointDescription().toString();
    }

    private class JcaEndpointConfigurer {
        private JcaEndpointConfigurer() {
        }

        public void configureEndpoint(Object listenerContainer) {
            if (!(listenerContainer instanceof JmsMessageEndpointManager)) {
                throw new IllegalArgumentException("Could not configure endpoint with the specified container '" + listenerContainer + "' Only JMS (" + AbstractMessageListenerContainer.class.getName() + " subclass) or JCA (" + JmsMessageEndpointManager.class.getName() + ") are supported.");
            }
            this.setupJcaMessageContainer((JmsMessageEndpointManager)listenerContainer);
        }

        private void setupJcaMessageContainer(JmsMessageEndpointManager container) {
            JmsActivationSpecConfig activationSpecConfig = container.getActivationSpecConfig();
            if (activationSpecConfig == null) {
                activationSpecConfig = new JmsActivationSpecConfig();
                container.setActivationSpecConfig(activationSpecConfig);
            }
            if (AbstractJmsListenerEndpoint.this.getDestination() != null) {
                activationSpecConfig.setDestinationName(AbstractJmsListenerEndpoint.this.getDestination());
            }
            if (AbstractJmsListenerEndpoint.this.getSubscription() != null) {
                activationSpecConfig.setSubscriptionName(AbstractJmsListenerEndpoint.this.getSubscription());
            }
            if (AbstractJmsListenerEndpoint.this.getSelector() != null) {
                activationSpecConfig.setMessageSelector(AbstractJmsListenerEndpoint.this.getSelector());
            }
            if (AbstractJmsListenerEndpoint.this.getConcurrency() != null) {
                activationSpecConfig.setConcurrency(AbstractJmsListenerEndpoint.this.getConcurrency());
            }
            AbstractJmsListenerEndpoint.this.setupMessageListener(container);
        }
    }
}

