/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.values;

import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssCheckableValue;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.RGBA;

public class LAB {
    String output = null;
    CssValue vl;
    CssValue va;
    CssValue vb;
    CssValue alpha;
    boolean faSet = false;
    boolean isGray = false;

    public static final CssValue filterL(ApplContext ac, CssValue val) throws InvalidParamException {
        CssCheckableValue v;
        if (val.getRawType() != 19 && val.getType() == 5 && !(v = val.getCheckableValue()).isPositive()) {
            ac.getFrame().addWarning("out-of-range", val.toString());
            CssNumber nb = new CssNumber();
            nb.setIntValue(0);
            return nb;
        }
        return val;
    }

    public final void setL(ApplContext ac, CssValue val) throws InvalidParamException {
        this.output = null;
        this.vl = LAB.filterL(ac, val);
    }

    public final void setA(ApplContext ac, CssValue val) throws InvalidParamException {
        this.output = null;
        this.va = val;
    }

    public final void setB(ApplContext ac, CssValue val) throws InvalidParamException {
        this.output = null;
        this.vb = val;
    }

    public final void setAlpha(ApplContext ac, CssValue val) throws InvalidParamException {
        this.output = null;
        this.faSet = true;
        this.alpha = RGBA.filterAlpha(ac, val);
    }

    public final boolean setGray(boolean isGray) {
        this.isGray = isGray;
        return isGray;
    }

    public boolean equals(LAB other) {
        if (other != null) {
            return this.vl.equals(other.vl) && this.va.equals(other.va) && this.vb.equals(other.vb) && (this.alpha == null && other.alpha == null || this.alpha != null && this.alpha.equals(other.alpha));
        }
        return false;
    }

    public String toString() {
        if (this.output == null) {
            StringBuilder sb;
            if (this.isGray) {
                sb = new StringBuilder("gray(");
                sb.append(this.vl);
                if (this.faSet) {
                    sb.append(" / ").append(this.alpha);
                }
                sb.append(')');
            } else {
                sb = new StringBuilder("lab(");
                sb.append(this.vl).append(' ');
                sb.append(this.va).append(' ');
                sb.append(this.vb);
                if (this.faSet) {
                    sb.append(" / ").append(this.alpha);
                }
                sb.append(')');
            }
            this.output = sb.toString();
        }
        return this.output;
    }
}

