/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc4;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import virtuoso.jdbc4.CallableStatementWrapper;
import virtuoso.jdbc4.Closeable;
import virtuoso.jdbc4.PreparedStatementWrapper;
import virtuoso.jdbc4.StatementWrapper;
import virtuoso.jdbc4.VirtuosoConnection;
import virtuoso.jdbc4.VirtuosoException;
import virtuoso.jdbc4.VirtuosoPooledConnection;
import virtuoso.jdbc4.VirtuosoXAResource;

public class ConnectionWrapper
implements Connection {
    private VirtuosoXAResource r_XAResource;
    private Boolean r_AutoCommit;
    private Boolean r_ReadOnly;
    private String r_Catalog;
    private Integer r_TxnIsolation;
    private Integer r_Holdability;
    private HashMap<Object, Object> objsToClose;
    protected StmtCache pStmtPool;
    private int maxStatements;
    private Connection rconn;
    private VirtuosoPooledConnection pconn;

    public ConnectionWrapper(Connection connection, VirtuosoPooledConnection virtuosoPooledConnection, LinkedList<Object> linkedList, int n) {
        this.rconn = connection;
        this.pconn = virtuosoPooledConnection;
        this.maxStatements = n;
        this.objsToClose = new HashMap(100);
        this.pStmtPool = new StmtCache(this, linkedList);
    }

    public synchronized void finalize() throws Throwable {
        this.close();
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.rconn == null) {
            return;
        }
        if (this.pconn != null) {
            this.pconn.sendCloseEvent();
        }
        this.rconn = null;
        this.pconn = null;
    }

    protected synchronized void closeAll() throws SQLException {
        this.pStmtPool.closeAll();
        this.close_objs();
        this.pconn = null;
        this.reset_XA();
        if (this.rconn != null) {
            this.rconn.close();
        }
        this.rconn = null;
    }

    @Override
    public Statement createStatement() throws SQLException {
        try {
            this.check_conn();
            return new StatementWrapper(this, this.rconn.createStatement());
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        try {
            this.check_conn();
            String string2 = string;
            PreparedStatementWrapper preparedStatementWrapper = this.pStmtPool.lookup(string2);
            if (preparedStatementWrapper != null) {
                return preparedStatementWrapper;
            }
            return new PreparedStatementWrapper(this, this.rconn.prepareStatement(string), string2);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLException {
        try {
            this.check_conn();
            return new CallableStatementWrapper(this, this.rconn.prepareCall(string));
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public String nativeSQL(String string) throws SQLException {
        try {
            this.check_conn();
            return this.rconn.nativeSQL(string);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
        try {
            this.check_conn();
            if (this.r_AutoCommit == null) {
                this.r_AutoCommit = new Boolean(this.getAutoCommit());
            }
            this.rconn.setAutoCommit(bl);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        try {
            this.check_conn();
            return this.rconn.getAutoCommit();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void commit() throws SQLException {
        try {
            this.check_conn();
            this.rconn.commit();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void rollback() throws SQLException {
        try {
            this.check_conn();
            this.rconn.rollback();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.rconn == null;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            this.check_conn();
            return this.rconn.getMetaData();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setReadOnly(boolean bl) throws SQLException {
        try {
            this.check_conn();
            if (this.r_ReadOnly == null) {
                this.r_ReadOnly = new Boolean(this.isReadOnly());
            }
            this.rconn.setReadOnly(bl);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try {
            this.check_conn();
            return this.rconn.isReadOnly();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setCatalog(String string) throws SQLException {
        try {
            this.check_conn();
            if (this.r_Catalog == null) {
                this.r_Catalog = this.getCatalog();
            }
            this.rconn.setCatalog(string);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        try {
            this.check_conn();
            return this.rconn.getCatalog();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setTransactionIsolation(int n) throws SQLException {
        try {
            this.check_conn();
            if (this.r_TxnIsolation == null) {
                this.r_TxnIsolation = new Integer(this.getTransactionIsolation());
            }
            this.rconn.setTransactionIsolation(n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        try {
            this.check_conn();
            return this.rconn.getTransactionIsolation();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            this.check_conn();
            return this.rconn.getWarnings();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            this.check_conn();
            this.rconn.clearWarnings();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public Statement createStatement(int n, int n2) throws SQLException {
        try {
            this.check_conn();
            return new StatementWrapper(this, this.rconn.createStatement(n, n2));
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        try {
            this.check_conn();
            StringBuffer stringBuffer = new StringBuffer(string.length() + 16);
            stringBuffer.append(n);
            stringBuffer.append('#');
            stringBuffer.append(n2);
            stringBuffer.append('#');
            stringBuffer.append(string);
            String string2 = stringBuffer.toString();
            PreparedStatementWrapper preparedStatementWrapper = this.pStmtPool.lookup(string2);
            if (preparedStatementWrapper != null) {
                return preparedStatementWrapper;
            }
            return new PreparedStatementWrapper(this, this.rconn.prepareStatement(string, n, n2), string2);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        try {
            this.check_conn();
            return new CallableStatementWrapper(this, this.rconn.prepareCall(string, n, n2));
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        try {
            this.check_conn();
            return this.rconn.getTypeMap();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.check_conn();
        this.rconn.setTypeMap(map);
    }

    @Override
    public int getHoldability() throws SQLException {
        try {
            this.check_conn();
            return this.rconn.getHoldability();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setHoldability(int n) throws SQLException {
        try {
            this.check_conn();
            if (this.r_Holdability == null) {
                this.r_Holdability = new Integer(this.getHoldability());
            }
            this.rconn.setHoldability(n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        try {
            this.check_conn();
            return this.rconn.setSavepoint();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLException {
        try {
            this.check_conn();
            return this.rconn.setSavepoint(string);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        try {
            this.check_conn();
            this.rconn.rollback(savepoint);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        try {
            this.check_conn();
            this.rconn.releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        try {
            this.check_conn();
            return new StatementWrapper(this, this.rconn.createStatement(n, n2, n3));
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        try {
            this.check_conn();
            StringBuffer stringBuffer = new StringBuffer(string.length() + 16);
            stringBuffer.append(n);
            stringBuffer.append('#');
            stringBuffer.append(n2);
            stringBuffer.append('#');
            stringBuffer.append(n3);
            stringBuffer.append('#');
            stringBuffer.append(string);
            String string2 = stringBuffer.toString();
            PreparedStatementWrapper preparedStatementWrapper = this.pStmtPool.lookup(string2);
            if (preparedStatementWrapper != null) {
                return preparedStatementWrapper;
            }
            return new PreparedStatementWrapper(this, this.rconn.prepareStatement(string, n, n2, n3), string2);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        try {
            this.check_conn();
            return new CallableStatementWrapper(this, this.rconn.prepareCall(string, n, n2, n3));
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        try {
            this.check_conn();
            StringBuffer stringBuffer = new StringBuffer(string.length() + 16);
            stringBuffer.append(n);
            stringBuffer.append('#');
            stringBuffer.append(string);
            String string2 = stringBuffer.toString();
            PreparedStatementWrapper preparedStatementWrapper = this.pStmtPool.lookup(string2);
            if (preparedStatementWrapper != null) {
                return preparedStatementWrapper;
            }
            return new PreparedStatementWrapper(this, this.rconn.prepareStatement(string, n), string2);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        try {
            this.check_conn();
            StringBuffer stringBuffer = new StringBuffer(string.length() + 16);
            stringBuffer.append('$');
            if (nArray != null) {
                for (int i = 0; i < nArray.length; ++i) {
                    stringBuffer.append(nArray[i]);
                }
            }
            stringBuffer.append('$');
            stringBuffer.append('#');
            stringBuffer.append(string);
            String string2 = stringBuffer.toString();
            PreparedStatementWrapper preparedStatementWrapper = this.pStmtPool.lookup(string2);
            if (preparedStatementWrapper != null) {
                return preparedStatementWrapper;
            }
            return new PreparedStatementWrapper(this, this.rconn.prepareStatement(string, nArray), string2);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        try {
            this.check_conn();
            StringBuffer stringBuffer = new StringBuffer(string.length() + 16);
            stringBuffer.append('@');
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append(stringArray[i]);
                }
            }
            stringBuffer.append('@');
            stringBuffer.append('#');
            stringBuffer.append(string);
            String string2 = stringBuffer.toString();
            PreparedStatementWrapper preparedStatementWrapper = this.pStmtPool.lookup(string2);
            if (preparedStatementWrapper != null) {
                return preparedStatementWrapper;
            }
            return new PreparedStatementWrapper(this, this.rconn.prepareStatement(string, stringArray), string2);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        try {
            this.check_conn();
            return this.rconn.createClob();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public Blob createBlob() throws SQLException {
        try {
            this.check_conn();
            return this.rconn.createBlob();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        try {
            this.check_conn();
            return this.rconn.createNClob();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        try {
            this.check_conn();
            return this.rconn.createSQLXML();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public boolean isValid(int n) throws SQLException {
        try {
            this.check_conn();
            return this.rconn.isValid(n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        try {
            this.check_conn();
            this.rconn.setClientInfo(string, string2);
        }
        catch (SQLClientInfoException sQLClientInfoException) {
            this.exceptionOccurred(sQLClientInfoException);
            throw sQLClientInfoException;
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw new SQLClientInfoException(sQLException.getMessage(), sQLException.getSQLState(), null);
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.check_conn();
            this.rconn.setClientInfo(properties);
        }
        catch (SQLClientInfoException sQLClientInfoException) {
            this.exceptionOccurred(sQLClientInfoException);
            throw sQLClientInfoException;
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw new SQLClientInfoException(sQLException.getMessage(), sQLException.getSQLState(), null);
        }
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        try {
            this.check_conn();
            return this.rconn.getClientInfo(string);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        try {
            this.check_conn();
            return this.rconn.getClientInfo();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        try {
            this.check_conn();
            return this.rconn.createArrayOf(string, objectArray);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        try {
            this.check_conn();
            return this.rconn.createStruct(string, objectArray);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        try {
            this.check_conn();
            return this.rconn.unwrap(clazz);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        try {
            this.check_conn();
            return this.rconn.isWrapperFor(clazz);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    protected void setXAResource(VirtuosoXAResource virtuosoXAResource) {
        this.r_XAResource = virtuosoXAResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addObjToClose(Object object) {
        HashMap<Object, Object> hashMap = this.objsToClose;
        synchronized (hashMap) {
            this.objsToClose.put(object, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeObjFromClose(Object object) {
        HashMap<Object, Object> hashMap = this.objsToClose;
        synchronized (hashMap) {
            this.objsToClose.remove(object);
        }
    }

    protected synchronized void reset_XA() {
        if (this.rconn == null) {
            return;
        }
        if (this.r_XAResource != null) {
            this.r_XAResource.reset_XA();
        }
    }

    protected synchronized LinkedList<Object> reset() {
        if (this.rconn == null) {
            return null;
        }
        this.reset_XA();
        try {
            this.rconn.rollback();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.close_objs();
        if (this.r_AutoCommit != null) {
            try {
                this.rconn.setAutoCommit(this.r_AutoCommit);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.r_ReadOnly != null) {
            try {
                this.rconn.setReadOnly(this.r_ReadOnly);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.r_Catalog != null) {
            try {
                this.rconn.setCatalog(this.r_Catalog);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.r_TxnIsolation != null) {
            try {
                this.rconn.setTransactionIsolation(this.r_TxnIsolation);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        try {
            this.rconn.setTypeMap(null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return this.pStmtPool.reset();
    }

    protected void clearStmtsCache() {
        this.pStmtPool.closeAll();
        this.close_objs();
    }

    protected void exceptionOccurred(SQLException sQLException) {
        if (this.pconn != null && VirtuosoConnection.isCriticalError(sQLException)) {
            this.pconn.sendErrorEvent(sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close_objs() {
        HashMap hashMap = (HashMap)this.objsToClose.clone();
        HashMap<Object, Object> hashMap2 = this.objsToClose;
        synchronized (hashMap2) {
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                try {
                    ((Closeable)iterator.next()).close();
                }
                catch (Exception exception) {}
            }
            this.objsToClose.clear();
        }
        hashMap.clear();
    }

    private void check_conn() throws SQLException {
        if (this.rconn == null) {
            throw new VirtuosoException("The connection is already closed.", -1);
        }
    }

    protected class StmtCache {
        private LinkedList<Object> unUsed = null;
        private HashMap<Object, Object> in_Use = new HashMap(32);
        private int cacheSize = 0;
        private ConnectionWrapper connWrapper;

        protected StmtCache(ConnectionWrapper connectionWrapper2, LinkedList<Object> linkedList) {
            this.connWrapper = connectionWrapper2;
            if (linkedList != null) {
                this.unUsed = linkedList;
                this.attach_stmts(this.unUsed);
            } else {
                this.unUsed = new LinkedList();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private PreparedStatementWrapper lookup(String string) {
            int n = string.hashCode();
            StmtCache stmtCache = this;
            synchronized (stmtCache) {
                Iterator iterator = this.unUsed.iterator();
                while (iterator.hasNext()) {
                    PreparedStatementWrapper preparedStatementWrapper = (PreparedStatementWrapper)iterator.next();
                    if (preparedStatementWrapper.hashStmtKey != n || !preparedStatementWrapper.stmtKey.equals(string)) continue;
                    iterator.remove();
                    return preparedStatementWrapper;
                }
            }
            return null;
        }

        protected synchronized void addToUsed(PreparedStatementWrapper preparedStatementWrapper) {
            this.in_Use.put(preparedStatementWrapper, preparedStatementWrapper);
            ++this.cacheSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void reuse(PreparedStatementWrapper preparedStatementWrapper) throws SQLException {
            boolean bl = true;
            StmtCache stmtCache = this;
            synchronized (stmtCache) {
                this.in_Use.remove(preparedStatementWrapper);
                --this.cacheSize;
                if (ConnectionWrapper.this.maxStatements > 0) {
                    this.unUsed.addFirst(preparedStatementWrapper.reuse());
                    ++this.cacheSize;
                    if (this.unUsed.size() > ConnectionWrapper.this.maxStatements) {
                        this.unUsed.removeLast();
                        --this.cacheSize;
                    }
                } else {
                    bl = false;
                }
            }
            if (!bl) {
                preparedStatementWrapper.closeAll();
            }
        }

        private synchronized LinkedList<Object> reset() {
            Object object;
            if (ConnectionWrapper.this.maxStatements > 0) {
                object = this.unUsed.listIterator();
                while (object.hasPrevious() && this.unUsed.size() > ConnectionWrapper.this.maxStatements) {
                    PreparedStatementWrapper preparedStatementWrapper = (PreparedStatementWrapper)object.previous();
                    object.remove();
                    preparedStatementWrapper.closeAll();
                }
            }
            object = this.in_Use.keySet().iterator();
            while (object.hasNext()) {
                ((PreparedStatementWrapper)object.next()).closeAll();
            }
            this.in_Use.clear();
            object = (LinkedList)this.unUsed.clone();
            this.unUsed.clear();
            this.detach_stmts((LinkedList)object);
            return object;
        }

        private synchronized void closeAll() {
            Iterator<Object> iterator = this.unUsed.iterator();
            while (iterator.hasNext()) {
                ((PreparedStatementWrapper)iterator.next()).closeAll();
            }
            this.unUsed.clear();
            iterator = this.in_Use.keySet().iterator();
            while (iterator.hasNext()) {
                ((PreparedStatementWrapper)iterator.next()).closeAll();
            }
            this.in_Use.clear();
        }

        private void detach_stmts(LinkedList linkedList) {
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                try {
                    ((PreparedStatementWrapper)iterator.next()).wconn = null;
                }
                catch (Exception exception) {}
            }
        }

        private void attach_stmts(LinkedList linkedList) {
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                try {
                    ((PreparedStatementWrapper)iterator.next()).wconn = this.connWrapper;
                }
                catch (Exception exception) {}
            }
        }
    }
}

