/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.commons.util.time;

import com.cloudhopper.commons.util.time.DateTimePeriod;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class DateTimePeriodSelector {
    private DateTimePeriodSelector() {
    }

    public static DateTimePeriod thisMonth(DateTimeZone zone) {
        DateTime now = new DateTime(zone);
        return DateTimePeriod.createMonth(now.getYear(), now.getMonthOfYear(), zone);
    }

    public static DateTimePeriod lastMonth(DateTimeZone zone) {
        return DateTimePeriodSelector.thisMonth(zone).getPrevious();
    }

    public static List<DateTimePeriod> last12Months(DateTimeZone zone) {
        ArrayList<DateTimePeriod> periods = new ArrayList<DateTimePeriod>();
        DateTime now = new DateTime(zone);
        for (int i = 0; i < 12; ++i) {
            DateTimePeriod period = DateTimePeriod.createMonth(now.getYear(), now.getMonthOfYear(), zone);
            periods.add(period);
            now = now.minusMonths(1);
        }
        Collections.reverse(periods);
        return periods;
    }
}

