/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.sendopts;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import org.netbeans.api.sendopts.CommandException;
import org.netbeans.modules.sendopts.OptionImpl;
import org.netbeans.spi.sendopts.Env;
import org.netbeans.spi.sendopts.OptionProcessor;
import org.openide.util.Lookup;

public final class Option {
    private final int shortName;
    private final String longName;
    final OptionImpl impl;
    private final String[] keys;
    private final String[] bundles;
    public static final char NO_SHORT_NAME = '\uffff';
    private static String[] EMPTY = new String[2];
    static /* synthetic */ Class class$java$lang$ClassLoader;

    private Option(char c, String string, int n) {
        this.shortName = c == '\uffff' ? -1 : (int)c;
        this.longName = string;
        switch (n) {
            case 0: {
                this.impl = OptionImpl.createNoArg(this);
                break;
            }
            case 1: {
                this.impl = OptionImpl.createOneArg(this, false);
                break;
            }
            case 2: {
                this.impl = OptionImpl.createOneArg(this, true);
                break;
            }
            case 3: {
                this.impl = OptionImpl.createAdd(this, false);
                break;
            }
            case 4: {
                this.impl = OptionImpl.createAdd(this, true);
                break;
            }
            case 5: {
                this.impl = OptionImpl.createAlways(this);
                break;
            }
            default: {
                throw new IllegalArgumentException("Type: " + n);
            }
        }
        this.keys = EMPTY;
        this.bundles = EMPTY;
    }

    Option(int n, Option[] optionArray) {
        this.shortName = -1;
        this.longName = null;
        this.impl = OptionImpl.create(this, n, Arrays.asList(optionArray));
        this.keys = EMPTY;
        this.bundles = EMPTY;
    }

    private Option(Option option, int n, String string, String string2) {
        this.shortName = option.shortName;
        this.longName = option.longName;
        this.impl = OptionImpl.cloneImpl(option.impl, this, null);
        this.keys = (String[])option.keys.clone();
        this.bundles = (String[])option.bundles.clone();
        this.keys[n] = string2;
        this.bundles[n] = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(this)));
        stringBuffer.append('[');
        stringBuffer.append(this.shortName);
        stringBuffer.append(',');
        stringBuffer.append(this.longName);
        stringBuffer.append(',');
        this.impl.append(stringBuffer);
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof Option) {
            Option option = (Option)object;
            return this.impl.root == option.impl.root;
        }
        return false;
    }

    public int hashCode() {
        return System.identityHashCode(this.impl.root);
    }

    public static Option withoutArgument(char c, String string) {
        return new Option(c, string, 0);
    }

    public static Option optionalArgument(char c, String string) {
        return new Option(c, string, 1);
    }

    public static Option requiredArgument(char c, String string) {
        return new Option(c, string, 2);
    }

    public static Option additionalArguments(char c, String string) {
        return new Option(c, string, 3);
    }

    public static Option defaultArguments() {
        return new Option('\uffff', null, 4);
    }

    public static Option always() {
        return new Option('\uffff', null, 5);
    }

    public static Option displayName(Option option, String string, String string2) {
        return new Option(option, 0, string, string2);
    }

    public static Option shortDescription(Option option, String string, String string2) {
        return new Option(option, 1, string, string2);
    }

    static {
        OptionImpl.Trampoline.DEFAULT = new OptionImpl.Trampoline(){

            @Override
            public OptionImpl impl(Option option) {
                return option.impl;
            }

            @Override
            public Env create(InputStream inputStream, OutputStream outputStream, OutputStream outputStream2, File file) {
                return new Env(inputStream, outputStream, outputStream2, file);
            }

            @Override
            public void usage(PrintWriter printWriter, Option option, int n) {
                if (option.keys[1] != null) {
                    printWriter.print(this.key(option.bundles[1], option.keys[1], Locale.getDefault()));
                }
            }

            @Override
            public Option[] getOptions(OptionProcessor optionProcessor) {
                return optionProcessor.getOptions().toArray(new Option[0]);
            }

            @Override
            public void process(OptionProcessor optionProcessor, Env env, Map<Option, String[]> map) throws CommandException {
                optionProcessor.process(env, Collections.unmodifiableMap(map));
            }

            @Override
            public String getLongName(Option option) {
                return option.longName;
            }

            @Override
            public int getShortName(Option option) {
                return option.shortName;
            }

            @Override
            public String getDisplayName(Option option, Locale locale) {
                return this.key(option.bundles[0], option.keys[0], locale);
            }

            private String key(String string, String string2, Locale locale) {
                if (string2 == null) {
                    return null;
                }
                ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = Option.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
                if (classLoader == null) {
                    classLoader = Thread.currentThread().getContextClassLoader();
                }
                if (classLoader == null) {
                    classLoader = this.getClass().getClassLoader();
                }
                try {
                    ResourceBundle resourceBundle = ResourceBundle.getBundle(string, locale, classLoader);
                    return resourceBundle.getString(string2);
                }
                catch (MissingResourceException missingResourceException) {
                    OptionImpl.LOG.log(Level.WARNING, null, missingResourceException);
                    return string2;
                }
            }
        };
    }
}

