/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.search;

import javax.mail.Message;
import javax.mail.search.SearchTerm;

public final class OrTerm
extends SearchTerm {
    protected SearchTerm[] terms;
    private static final long serialVersionUID = 5380534067523646936L;

    public OrTerm(SearchTerm searchTerm, SearchTerm searchTerm2) {
        this.terms = new SearchTerm[2];
        this.terms[0] = searchTerm;
        this.terms[1] = searchTerm2;
    }

    public OrTerm(SearchTerm[] searchTermArray) {
        this.terms = new SearchTerm[searchTermArray.length];
        int n = 0;
        while (n < searchTermArray.length) {
            this.terms[n] = searchTermArray[n];
            ++n;
        }
    }

    public SearchTerm[] getTerms() {
        return (SearchTerm[])this.terms.clone();
    }

    public boolean match(Message message) {
        int n = 0;
        while (n < this.terms.length) {
            if (this.terms[n].match(message)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (!(object instanceof OrTerm)) {
            return false;
        }
        OrTerm orTerm = (OrTerm)object;
        if (orTerm.terms.length != this.terms.length) {
            return false;
        }
        int n = 0;
        while (n < this.terms.length) {
            if (!this.terms[n].equals(orTerm.terms[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.terms.length) {
            n += this.terms[n2].hashCode();
            ++n2;
        }
        return n;
    }
}

