/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongBitSet;
import org.apache.solr.common.SolrException;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.JoinQuery;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.join.MultiValueTermOrdinalCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopLevelJoinQuery
extends JoinQuery {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public TopLevelJoinQuery(String fromField, String toField, String coreName, Query subQuery) {
        super(fromField, toField, coreName, subQuery);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        if (!(searcher instanceof SolrIndexSearcher)) {
            log.debug("Falling back to JoinQueryWeight because searcher [{}] is not the required SolrIndexSearcher", (Object)searcher);
            return super.createWeight(searcher, scoreMode, boost);
        }
        SolrIndexSearcher solrSearcher = (SolrIndexSearcher)searcher;
        JoinQuery.JoinQueryWeight weight = new JoinQuery.JoinQueryWeight(solrSearcher, ScoreMode.COMPLETE_NO_SCORES, 1.0f);
        SolrIndexSearcher fromSearcher = weight.fromSearcher;
        SolrIndexSearcher toSearcher = weight.toSearcher;
        try {
            SortedSetDocValues topLevelFromDocValues = this.validateAndFetchDocValues(fromSearcher, this.fromField, "from");
            final SortedSetDocValues topLevelToDocValues = this.validateAndFetchDocValues(toSearcher, this.toField, "to");
            if (topLevelFromDocValues.getValueCount() == 0L || topLevelToDocValues.getValueCount() == 0L) {
                return this.createNoMatchesWeight(boost);
            }
            LongBitSet fromOrdBitSet = TopLevelJoinQuery.findFieldOrdinalsMatchingQuery(this.q, this.fromField, fromSearcher, topLevelFromDocValues);
            final LongBitSet toOrdBitSet = new LongBitSet(topLevelToDocValues.getValueCount());
            final BitsetBounds toBitsetBounds = this.convertFromOrdinalsIntoToField(fromOrdBitSet, topLevelFromDocValues, toOrdBitSet, topLevelToDocValues);
            final boolean toMultivalued = toSearcher.getSchema().getFieldOrNull(this.toField).multiValued();
            return new ConstantScoreWeight(this, boost){

                public Scorer scorer(LeafReaderContext context) throws IOException {
                    SortedSetDocValues toApproximation;
                    if (toBitsetBounds.lower == -1L) {
                        return null;
                    }
                    Object object = toApproximation = toMultivalued ? context.reader().getSortedSetDocValues(TopLevelJoinQuery.this.toField) : context.reader().getSortedDocValues(TopLevelJoinQuery.this.toField);
                    if (toApproximation == null) {
                        return null;
                    }
                    final int docBase = context.docBase;
                    return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, new TwoPhaseIterator((DocIdSetIterator)toApproximation){

                        public boolean matches() throws IOException {
                            boolean hasDoc = topLevelToDocValues.advanceExact(docBase + this.approximation.docID());
                            if (hasDoc) {
                                long ord = topLevelToDocValues.nextOrd();
                                while (ord != -1L) {
                                    if (toOrdBitSet.get(ord)) {
                                        return true;
                                    }
                                    ord = topLevelToDocValues.nextOrd();
                                }
                            }
                            return false;
                        }

                        public float matchCost() {
                            return 10.0f;
                        }
                    });
                }

                public boolean isCacheable(LeafReaderContext ctx) {
                    return false;
                }
            };
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Weight createNoMatchesWeight(float boost) {
        return new ConstantScoreWeight(this, boost){

            public Scorer scorer(LeafReaderContext context) throws IOException {
                return null;
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return false;
            }
        };
    }

    private SortedSetDocValues validateAndFetchDocValues(SolrIndexSearcher solrSearcher, String fieldName, String querySide) throws IOException {
        IndexSchema schema = solrSearcher.getSchema();
        SchemaField field = schema.getFieldOrNull(fieldName);
        if (field == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, querySide + " field '" + fieldName + "' does not exist");
        }
        if (!field.hasDocValues()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'top-level' join queries require both 'from' and 'to' fields to have docValues, but " + querySide + " field [" + fieldName + "] does not.");
        }
        LeafReader leafReader = solrSearcher.getSlowAtomicReader();
        if (field.multiValued()) {
            return DocValues.getSortedSet((LeafReader)leafReader, (String)fieldName);
        }
        return DocValues.singleton((SortedDocValues)DocValues.getSorted((LeafReader)leafReader, (String)fieldName));
    }

    private static LongBitSet findFieldOrdinalsMatchingQuery(Query q, String field, SolrIndexSearcher searcher, SortedSetDocValues docValues) throws IOException {
        LongBitSet fromOrdBitSet = new LongBitSet(docValues.getValueCount());
        MultiValueTermOrdinalCollector fromCollector = new MultiValueTermOrdinalCollector(field, docValues, fromOrdBitSet);
        searcher.search(q, (Collector)fromCollector);
        return fromOrdBitSet;
    }

    private BitsetBounds convertFromOrdinalsIntoToField(LongBitSet fromOrdBitSet, SortedSetDocValues fromDocValues, LongBitSet toOrdBitSet, SortedSetDocValues toDocValues) throws IOException {
        long firstToOrd = -1L;
        long lastToOrd = 0L;
        for (long fromOrdinal = 0L; fromOrdinal < fromOrdBitSet.length() && (fromOrdinal = fromOrdBitSet.nextSetBit(fromOrdinal)) >= 0L; ++fromOrdinal) {
            BytesRef fromBytesRef = fromDocValues.lookupOrd(fromOrdinal);
            long toOrdinal = this.lookupTerm(toDocValues, fromBytesRef, lastToOrd);
            if (toOrdinal < 0L) continue;
            toOrdBitSet.set(toOrdinal);
            if (firstToOrd == -1L) {
                firstToOrd = toOrdinal;
            }
            lastToOrd = toOrdinal;
        }
        return new BitsetBounds(firstToOrd, lastToOrd);
    }

    private long lookupTerm(SortedSetDocValues docValues, BytesRef key, long startOrd) throws IOException {
        long low = startOrd;
        long high = docValues.getValueCount() - 1L;
        while (low <= high) {
            long mid = low + high >>> 1;
            BytesRef term = docValues.lookupOrd(mid);
            int cmp = term.compareTo(key);
            if (cmp < 0) {
                low = mid + 1L;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1L;
                continue;
            }
            return mid;
        }
        return -(low + 1L);
    }

    private static class BitsetBounds {
        public static final long NO_MATCHES = -1L;
        public final long lower;
        public final long upper;

        public BitsetBounds(long lower, long upper) {
            this.lower = lower;
            this.upper = upper;
        }
    }
}

