"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var specs_1 = require("./actions/specs");
var interactions_1 = require("./reducers/interactions");
var chart_types_1 = require("../chart_types");
var chart_state_1 = require("../chart_types/xy_chart/state/chart_state");
var settings_1 = require("../specs/settings");
var chart_1 = require("./actions/chart");
var chart_settings_1 = require("./actions/chart_settings");
var events_1 = require("./actions/events");
exports.getInitialState = function (chartId) {
    var _a;
    return ({
        chartId: chartId,
        specsInitialized: false,
        chartRendered: false,
        chartRenderedCount: 0,
        specs: (_a = {},
            _a[settings_1.DEFAULT_SETTINGS_SPEC.id] = settings_1.DEFAULT_SETTINGS_SPEC,
            _a),
        chartType: null,
        internalChartState: null,
        interactions: {
            pointer: {
                dragging: false,
                current: {
                    position: {
                        x: -1,
                        y: -1,
                    },
                    time: 0,
                },
                down: null,
                up: null,
                lastDrag: null,
                lastClick: null,
            },
            legendCollapsed: false,
            highlightedLegendItemKey: null,
            deselectedDataSeries: [],
            invertDeselect: false,
        },
        externalEvents: {
            pointer: null,
        },
        parentDimensions: {
            height: 0,
            width: 0,
            left: 0,
            top: 0,
        },
    });
};
exports.chartStoreReducer = function (chartId) {
    var initialState = exports.getInitialState(chartId);
    return function (state, action) {
        var _a;
        if (state === void 0) { state = initialState; }
        switch (action.type) {
            case specs_1.SPEC_PARSED:
                var chartType = findMainChartType(state.specs);
                if (isChartTypeChanged(state, chartType)) {
                    var internalChartState = initInternalChartState(chartType);
                    return __assign(__assign({}, state), { specsInitialized: true, chartRendered: false, chartType: chartType,
                        internalChartState: internalChartState });
                }
                else {
                    return __assign(__assign({}, state), { specsInitialized: true, chartRendered: false, chartType: chartType });
                }
            case specs_1.SPEC_UNMOUNTED:
                return __assign(__assign({}, state), { specsInitialized: false, chartRendered: false });
            case specs_1.UPSERT_SPEC:
                return __assign(__assign({}, state), { specsInitialized: false, chartRendered: false, specs: __assign(__assign({}, state.specs), (_a = {}, _a[action.spec.id] = action.spec, _a)) });
            case specs_1.REMOVE_SPEC:
                var _b = state.specs, _c = action.id, specToRemove = _b[_c], rest = __rest(_b, [typeof _c === "symbol" ? _c : _c + ""]);
                return __assign(__assign({}, state), { specsInitialized: false, chartRendered: false, specs: __assign({}, rest) });
            case chart_1.CHART_RENDERED:
                var count = state.chartRendered ? state.chartRenderedCount : state.chartRenderedCount + 1;
                return __assign(__assign({}, state), { chartRendered: true, chartRenderedCount: count });
            case chart_settings_1.UPDATE_PARENT_DIMENSION:
                return __assign(__assign({}, state), { parentDimensions: __assign({}, action.dimensions) });
            case events_1.EXTERNAL_POINTER_EVENT:
                // discard events from self if any
                if (action.event.chartId === chartId) {
                    return __assign(__assign({}, state), { externalEvents: __assign(__assign({}, state.externalEvents), { pointer: null }) });
                }
                return __assign(__assign({}, state), { externalEvents: __assign(__assign({}, state.externalEvents), { pointer: __assign({}, action.event) }) });
            default:
                return __assign(__assign({}, state), { interactions: interactions_1.interactionsReducer(state.interactions, action) });
        }
    };
};
function findMainChartType(specs) {
    var types = Object.keys(specs).reduce(function (acc, specId) {
        var chartType = specs[specId].chartType;
        var accumulator = acc[chartType];
        if (accumulator === undefined) {
            accumulator = 0;
        }
        else {
            accumulator += 1;
        }
        acc[chartType] = accumulator;
        return acc;
    }, {});
    // https://stackoverflow.com/questions/55012174/why-doesnt-object-keys-return-a-keyof-type-in-typescript
    var chartTypes = Object.keys(types).filter(function (type) { return type !== chart_types_1.ChartTypes.Global; });
    if (chartTypes.length > 1) {
        // eslint-disable-next-line no-console
        console.warn('Multiple chart type on the same configuration');
        return null;
    }
    else {
        return chartTypes[0];
    }
}
function initInternalChartState(chartType) {
    switch (chartType) {
        case chart_types_1.ChartTypes.Pie:
            return null; // TODO add pie chart state
        case chart_types_1.ChartTypes.XYAxis:
            return new chart_state_1.XYAxisChartState();
        default:
            return null;
    }
}
function isChartTypeChanged(state, newChartType) {
    return state.chartType !== newChartType;
}
//# sourceMappingURL=chart_state.js.map