"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var __1 = require("../..");
var series_1 = require("../../chart_types/xy_chart/utils/series");
var commons_1 = require("../../utils/commons");
var MockSeriesCollection = /** @class */ (function () {
    function MockSeriesCollection() {
    }
    MockSeriesCollection.empty = function () {
        return new Map();
    };
    MockSeriesCollection.fromSpecs = function (seriesSpecs) {
        var seriesCollection = series_1.getSplittedSeries(seriesSpecs, []).seriesCollection;
        return seriesCollection;
    };
    return MockSeriesCollection;
}());
exports.MockSeriesCollection = MockSeriesCollection;
var MockSeriesIdentifier = /** @class */ (function () {
    function MockSeriesIdentifier() {
    }
    MockSeriesIdentifier.default = function (partial) {
        return commons_1.mergePartial(MockSeriesIdentifier.base, partial, { mergeOptionalPartialValues: true });
    };
    MockSeriesIdentifier.base = {
        specId: __1.getSpecId('bars'),
        yAccessor: 'y',
        seriesKeys: ['a'],
        splitAccessors: new Map().set('g', 'a'),
        key: 'spec{bars}yAccessor{y}splitAccessors{g-a}',
    };
    return MockSeriesIdentifier;
}());
exports.MockSeriesIdentifier = MockSeriesIdentifier;
//# sourceMappingURL=seriesIdentifiers.js.map