"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importStar(require("react"));
var classnames_1 = __importDefault(require("classnames"));
var axis_utils_1 = require("../../chart_types/xy_chart/utils/axis_utils");
var react_redux_1 = require("react-redux");
var specs_1 = require("../../chart_types/xy_chart/utils/specs");
var get_legend_items_1 = require("../../state/selectors/get_legend_items");
var get_settings_specs_1 = require("../../state/selectors/get_settings_specs");
var get_chart_theme_1 = require("../../state/selectors/get_chart_theme");
var get_legend_items_values_1 = require("../../state/selectors/get_legend_items_values");
var get_legend_size_1 = require("../../state/selectors/get_legend_size");
var legend_1 = require("../../state/actions/legend");
var redux_1 = require("redux");
var light_theme_1 = require("../../utils/themes/light_theme");
var legend_item_1 = require("./legend_item");
var legend_2 = require("../../chart_types/xy_chart/legend/legend");
var legend_3 = require("../../state/actions/legend");
var geometry_1 = require("../../utils/geometry");
var LegendComponent = /** @class */ (function (_super) {
    __extends(LegendComponent, _super);
    function LegendComponent() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.legendItemCount = 0;
        _this.echLegend = react_1.createRef();
        _this.getLegendListStyle = function (position, _a) {
            var chartMargins = _a.chartMargins, legend = _a.legend;
            var paddingTop = chartMargins.top, paddingBottom = chartMargins.bottom, paddingLeft = chartMargins.left, paddingRight = chartMargins.right;
            if (axis_utils_1.isHorizontalAxis(position)) {
                return {
                    paddingLeft: paddingLeft,
                    paddingRight: paddingRight,
                    gridTemplateColumns: "repeat(auto-fill, minmax(" + legend.verticalWidth + "px, 1fr))",
                };
            }
            return {
                paddingTop: paddingTop,
                paddingBottom: paddingBottom,
            };
        };
        _this.getLegendStyle = function (position, size) {
            if (axis_utils_1.isVerticalAxis(position)) {
                var width = size.width + "px";
                return {
                    width: width,
                    maxWidth: width,
                };
            }
            var height = size.height + "px";
            return {
                height: height,
                maxHeight: height,
            };
        };
        _this.renderLegendElement = function (item) {
            if (!_this.props.settings) {
                return null;
            }
            var key = item.key, displayValue = item.displayValue, banded = item.banded;
            var _a = _this.props, legendItemTooltipValues = _a.legendItemTooltipValues, settings = _a.settings;
            var showLegendDisplayValue = settings.showLegendDisplayValue, legendPosition = settings.legendPosition;
            var legendValues = _this.getLegendValues(legendItemTooltipValues, key, banded);
            return legendValues.map(function (value, index) {
                var yAccessor = index === 0 ? geometry_1.BandedAccessorType.Y1 : geometry_1.BandedAccessorType.Y0;
                return (react_1.default.createElement(legend_item_1.LegendListItem, __assign({}, item, { label: legend_2.getItemLabel(item, yAccessor), key: key + "-" + yAccessor, legendItem: item, displayValue: value !== '' ? value : displayValue.formatted[yAccessor], showLegendDisplayValue: showLegendDisplayValue, legendPosition: legendPosition, toggleDeselectSeriesAction: _this.props.onToggleDeselectSeriesAction, legendItemOutAction: _this.props.onLegendItemOutAction, legendItemOverAction: _this.props.onLegendItemOverAction, onLegendItemOverListener: settings.onLegendItemOver, onLegendItemOutListener: settings.onLegendItemOut, onLegendItemClickListener: settings.onLegendItemClick })));
            });
        };
        return _this;
    }
    LegendComponent.prototype.render = function () {
        var _a = this.props, legendItems = _a.legendItems, legendPosition = _a.legendPosition, legendSize = _a.legendSize, showLegend = _a.showLegend, debug = _a.debug, chartTheme = _a.chartTheme;
        if (!showLegend || legendItems.size === 0) {
            return null;
        }
        var legendContainerStyle = this.getLegendStyle(legendPosition, legendSize);
        var legendListStyle = this.getLegendListStyle(legendPosition, chartTheme);
        var legendClasses = classnames_1.default('echLegend', "echLegend--" + legendPosition, {
            'echLegend--debug': debug,
        });
        return (react_1.default.createElement("div", { ref: this.echLegend, className: legendClasses },
            react_1.default.createElement("div", { style: legendContainerStyle, className: "echLegendListContainer" },
                react_1.default.createElement("div", { style: legendListStyle, className: "echLegendList" }, __spread(legendItems.values()).map(this.renderLegendElement)))));
    };
    LegendComponent.prototype.getLegendValues = function (tooltipValues, key, banded) {
        if (banded === void 0) { banded = false; }
        var values = tooltipValues && tooltipValues.get(key);
        if (values === null || values === undefined) {
            return banded ? ['', ''] : [''];
        }
        var y0 = values.y0, y1 = values.y1;
        return banded ? [y1, y0] : [y1];
    };
    LegendComponent.displayName = 'Legend';
    return LegendComponent;
}(react_1.default.Component));
var mapDispatchToProps = function (dispatch) {
    return redux_1.bindActionCreators({
        onToggleLegend: legend_1.onToggleLegend,
        onToggleDeselectSeriesAction: legend_3.onToggleDeselectSeriesAction,
        onLegendItemOutAction: legend_3.onLegendItemOutAction,
        onLegendItemOverAction: legend_3.onLegendItemOverAction,
    }, dispatch);
};
var mapStateToProps = function (state) {
    if (!state.specsInitialized) {
        return {
            legendItems: new Map(),
            legendPosition: specs_1.Position.Right,
            showLegend: false,
            legendCollapsed: false,
            legendItemTooltipValues: new Map(),
            debug: false,
            chartTheme: light_theme_1.LIGHT_THEME,
            legendSize: { width: 0, height: 0 },
        };
    }
    var _a = get_settings_specs_1.getSettingsSpecSelector(state), legendPosition = _a.legendPosition, showLegend = _a.showLegend, debug = _a.debug;
    if (!showLegend) {
        return {
            legendItems: new Map(),
            legendPosition: specs_1.Position.Right,
            showLegend: false,
            legendCollapsed: false,
            legendItemTooltipValues: new Map(),
            debug: false,
            chartTheme: light_theme_1.LIGHT_THEME,
            legendSize: { width: 0, height: 0 },
        };
    }
    var legendItems = get_legend_items_1.getLegendItemsSelector(state);
    return {
        legendItems: legendItems,
        legendPosition: legendPosition,
        showLegend: showLegend,
        legendCollapsed: state.interactions.legendCollapsed,
        legendItemTooltipValues: get_legend_items_values_1.getLegendItemsValuesSelector(state),
        debug: debug,
        chartTheme: get_chart_theme_1.getChartThemeSelector(state),
        legendSize: get_legend_size_1.getLegendSizeSelector(state),
        settings: get_settings_specs_1.getSettingsSpecSelector(state),
    };
};
exports.Legend = react_redux_1.connect(mapStateToProps, mapDispatchToProps)(LegendComponent);
//# sourceMappingURL=legend.js.map