"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
var scales_1 = require("../../../utils/scales/scales");
exports.datumXSortPredicate = function (xScaleType) { return function (a, b) {
    if (xScaleType === scales_1.ScaleType.Ordinal || typeof a.x === 'string' || typeof b.x === 'string') {
        return 0;
    }
    return a.x - b.x;
}; };
/**
 * Map each y value from a RawDataSeries on it's specific x value into,
 * ordering the stack based on the dataseries index.
 * @param dataseries
 */
function getYValueStackMap(dataseries, xValues) {
    var stackMap = new Map();
    var missingXValues = new Set(__spread(xValues));
    dataseries.forEach(function (ds, index) {
        var e_1, _a;
        ds.data.forEach(function (datum) {
            var stack = stackMap.get(datum.x) || new Array(dataseries.length).fill(0);
            stack[index] = datum.y1;
            stackMap.set(datum.x, stack);
            if (xValues.has(datum.x)) {
                missingXValues.delete(datum.x);
            }
        });
        try {
            for (var _b = __values(missingXValues.values()), _c = _b.next(); !_c.done; _c = _b.next()) {
                var x = _c.value;
                var stack = stackMap.get(x) || new Array(dataseries.length).fill(0);
                // currently filling as 0 value
                stack[index] = 0;
                stackMap.set(x, stack);
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
    });
    return stackMap;
}
exports.getYValueStackMap = getYValueStackMap;
/**
 * For each key of the yValueStackMap, it stacks the values one after the other,
 * summing the previous value to the next one.
 * @param yValueStackMap
 * @param scaleToExtent
 */
function computeYStackedMapValues(yValueStackMap, scaleToExtent) {
    var stackedValues = new Map();
    yValueStackMap.forEach(function (yStackArray, xValue) {
        var stackArray = yStackArray.reduce(function (acc, currentValue, index) {
            if (acc.values.length === 0) {
                if (scaleToExtent) {
                    return {
                        values: [currentValue, currentValue],
                        total: currentValue,
                    };
                }
                return {
                    values: [0, currentValue],
                    total: currentValue,
                };
            }
            return {
                values: __spread(acc.values, [acc.values[index] + currentValue]),
                total: acc.total + currentValue,
            };
        }, {
            values: [],
            total: 0,
        });
        var percent = stackArray.values.map(function (value) {
            return value / stackArray.total;
        });
        stackedValues.set(xValue, {
            values: stackArray.values,
            percent: percent,
            total: stackArray.total,
        });
    });
    return stackedValues;
}
exports.computeYStackedMapValues = computeYStackedMapValues;
function formatStackedDataSeriesValues(dataseries, scaleToExtent, isPercentageMode, xValues, xScaleType) {
    var yValueStackMap = getYValueStackMap(dataseries, xValues);
    var stackedValues = computeYStackedMapValues(yValueStackMap, scaleToExtent);
    var stackedDataSeries = dataseries.map(function (ds, seriesIndex) {
        var e_2, _a;
        var newData = [];
        var missingXValues = new Set(__spread(xValues));
        ds.data.forEach(function (data) {
            var formattedSeriesDatum = getStackedFormattedSeriesDatum(data, stackedValues, seriesIndex, scaleToExtent, isPercentageMode);
            if (formattedSeriesDatum === undefined) {
                return;
            }
            missingXValues.delete(data.x);
            newData.push(formattedSeriesDatum);
        });
        try {
            for (var _b = __values(missingXValues.values()), _c = _b.next(); !_c.done; _c = _b.next()) {
                var x = _c.value;
                var filledSeriesDatum = getStackedFormattedSeriesDatum({
                    x: x,
                    // filling as 0 value
                    y1: 0,
                }, stackedValues, seriesIndex, scaleToExtent, isPercentageMode, {
                    x: x,
                    // filling as 0 value
                    y1: 0,
                });
                if (filledSeriesDatum) {
                    newData.push(filledSeriesDatum);
                }
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_2) throw e_2.error; }
        }
        newData.sort(exports.datumXSortPredicate(xScaleType));
        return __assign(__assign({}, ds), { data: newData });
    });
    return stackedDataSeries;
}
exports.formatStackedDataSeriesValues = formatStackedDataSeriesValues;
function getStackedFormattedSeriesDatum(data, stackedValues, seriesIndex, scaleToExtent, isPercentageMode, filled) {
    if (isPercentageMode === void 0) { isPercentageMode = false; }
    var x = data.x, datum = data.datum;
    var stack = stackedValues.get(x);
    if (!stack) {
        return;
    }
    var y1 = null;
    if (isPercentageMode) {
        y1 = data.y1 != null ? data.y1 / stack.total : null;
    }
    else {
        y1 = data.y1;
    }
    var y0 = isPercentageMode && data.y0 != null ? data.y0 / stack.total : data.y0;
    var computedY0;
    if (scaleToExtent) {
        computedY0 = y0 ? y0 : y1;
    }
    else {
        computedY0 = y0 ? y0 : null;
    }
    var initialY0 = y0 == null ? null : y0;
    if (seriesIndex === 0) {
        return __assign({ x: x,
            y1: y1, y0: computedY0, initialY1: y1, initialY0: initialY0,
            datum: datum }, (filled && { filled: filled }));
    }
    else {
        var stackY = isPercentageMode ? stack.percent[seriesIndex] : stack.values[seriesIndex];
        var stackedY1 = null;
        var stackedY0 = null;
        if (isPercentageMode) {
            stackedY1 = y1 !== null ? stackY + y1 : null;
            stackedY0 = y0 != null ? stackY + y0 : stackY;
        }
        else {
            stackedY1 = y1 !== null ? stackY + y1 : null;
            stackedY0 = y0 != null ? stackY + y0 : stackY;
            // configure null y0 if y1 is null
            // it's semantically correct to say y0 is null if y1 is null
            if (stackedY1 === null) {
                stackedY0 = null;
            }
        }
        return __assign({ x: x, y1: stackedY1, y0: stackedY0, initialY1: y1, initialY0: initialY0,
            datum: datum }, (filled && { filled: filled }));
    }
}
//# sourceMappingURL=stacked_series_utils.js.map