"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SeriesTypes = Object.freeze({
    Area: 'area',
    Bar: 'bar',
    Line: 'line',
});
exports.SpecTypes = Object.freeze({
    Series: 'series',
    Axis: 'axis',
    Annotation: 'annotation',
    Settings: 'settings',
});
exports.DEFAULT_GLOBAL_ID = '__global__';
/**
 * The fit function type
 */
exports.Fit = Object.freeze({
    /**
     * Don't draw value on the graph. Slices out area between `null` values.
     *
     * Example:
     * ```js
     * [2, null, null, 8] => [2, null null, 8]
     * ```
     */
    None: 'none',
    /**
     * Use the previous non-`null` value
     *
     * Example:
     * ```js
     * [2, null, null, 8] => [2, 2, 2, 8]
     * ```
     *
     * @opposite `Lookahead`
     */
    Carry: 'carry',
    /**
     * Use the next non-`null` value
     *
     * Example:
     * ```js
     * [2, null, null, 8] => [2, 8, 8, 8]
     * ```
     *
     * @opposite `Carry`
     */
    Lookahead: 'lookahead',
    /**
     * Use the closest non-`null` value (before or after)
     *
     * Example:
     * ```js
     * [2, null, null, 8] => [2, 2, 8, 8]
     * ```
     */
    Nearest: 'nearest',
    /**
     * Average between the closest non-`null` values
     *
     * Example:
     * ```js
     * [2, null, null, 8] => [2, 5, 5, 8]
     * ```
     */
    Average: 'average',
    /**
     * Linear interpolation between the closest non-`null` values
     *
     * Example:
     * ```js
     * [2, null, null, 8] => [2, 4, 6, 8]
     * ```
     */
    Linear: 'linear',
    /**
     * Sets all `null` values to `0`
     *
     * Example:
     * ```js
     * [2, null, null, 8] => [2, 0, 0, 8]
     * ```
     */
    Zero: 'zero',
    /**
     * Specify an explicit value `X`
     *
     * Example:
     * ```js
     * [2, null, null, 8] => [2, X, X, 8]
     * ```
     */
    Explicit: 'explicit',
});
exports.HistogramModeAlignments = Object.freeze({
    Start: 'start',
    Center: 'center',
    End: 'end',
});
/**
 * The position of the axis relative to the chart.
 * A left or right positioned axis is a vertical axis.
 * A top or bottom positioned axis is an horizontal axis.
 */
exports.Position = Object.freeze({
    Top: 'top',
    Bottom: 'bottom',
    Left: 'left',
    Right: 'right',
});
exports.AnnotationTypes = Object.freeze({
    Line: 'line',
    Rectangle: 'rectangle',
    Text: 'text',
});
exports.AnnotationDomainTypes = Object.freeze({
    XDomain: 'xDomain',
    YDomain: 'yDomain',
});
function isLineAnnotation(spec) {
    return spec.annotationType === exports.AnnotationTypes.Line;
}
exports.isLineAnnotation = isLineAnnotation;
function isRectAnnotation(spec) {
    return spec.annotationType === exports.AnnotationTypes.Rectangle;
}
exports.isRectAnnotation = isRectAnnotation;
function isBarSeriesSpec(spec) {
    return spec.seriesType === exports.SeriesTypes.Bar;
}
exports.isBarSeriesSpec = isBarSeriesSpec;
function isLineSeriesSpec(spec) {
    return spec.seriesType === exports.SeriesTypes.Line;
}
exports.isLineSeriesSpec = isLineSeriesSpec;
function isAreaSeriesSpec(spec) {
    return spec.seriesType === exports.SeriesTypes.Area;
}
exports.isAreaSeriesSpec = isAreaSeriesSpec;
function isBandedSpec(y0Accessors) {
    return Boolean(y0Accessors && y0Accessors.length > 0);
}
exports.isBandedSpec = isBandedSpec;
//# sourceMappingURL=specs.js.map