"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var get_settings_specs_1 = require("../../../../state/selectors/get_settings_specs");
var get_tooltip_values_highlighted_geoms_1 = require("./get_tooltip_values_highlighted_geoms");
var index_1 = require("../../../index");
var getLastClickSelector = function (state) { return state.interactions.pointer.lastClick; };
function isClicking(prevProps, nextProps) {
    if (nextProps === null) {
        return false;
    }
    if (!nextProps.settings || !nextProps.settings.onElementClick || nextProps.indexedGeometries.length === 0) {
        return false;
    }
    var prevLastClick = prevProps !== null ? prevProps.lastClick : null;
    var nextLastClick = nextProps !== null ? nextProps.lastClick : null;
    if (prevLastClick === null && nextLastClick !== null) {
        return true;
    }
    if (prevLastClick !== null && nextLastClick !== null && prevLastClick.time !== nextLastClick.time) {
        return true;
    }
    return false;
}
/**
 * Will call the onElementClick listener every time the following preconditions are met:
 * - the onElementClick listener is available
 * - we have at least one highlighted geometry
 * - the pointer state goes from down state to up state
 */
function createOnElementClickCaller() {
    var prevProps = null;
    var selector = null;
    return function (state) {
        if (selector === null && state.chartType === index_1.ChartTypes.XYAxis) {
            selector = re_reselect_1.default([getLastClickSelector, get_settings_specs_1.getSettingsSpecSelector, get_tooltip_values_highlighted_geoms_1.getHighlightedGeomsSelector], function (lastClick, settings, indexedGeometries) {
                var nextProps = {
                    lastClick: lastClick,
                    settings: settings,
                    indexedGeometries: indexedGeometries,
                };
                if (isClicking(prevProps, nextProps)) {
                    if (settings && settings.onElementClick) {
                        settings.onElementClick(indexedGeometries.map(function (_a) {
                            var value = _a.value;
                            return value;
                        }));
                    }
                }
                prevProps = nextProps;
            })({
                keySelector: function (state) { return state.chartId; },
            });
        }
        if (selector) {
            selector(state);
        }
    };
}
exports.createOnElementClickCaller = createOnElementClickCaller;
//# sourceMappingURL=on_element_click_caller.js.map