"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var interactions_1 = require("../../utils/interactions");
var get_settings_specs_1 = require("../../../../state/selectors/get_settings_specs");
var get_projected_pointer_position_1 = require("./get_projected_pointer_position");
var get_tooltip_values_highlighted_geoms_1 = require("./get_tooltip_values_highlighted_geoms");
var get_chart_id_1 = require("../../../../state/selectors/get_chart_id");
var getTooltipType = function (state) {
    var tooltip = get_settings_specs_1.getSettingsSpecSelector(state).tooltip;
    if (!tooltip) {
        return undefined;
    }
    if (interactions_1.isTooltipType(tooltip)) {
        return tooltip;
    }
    if (interactions_1.isTooltipProps(tooltip)) {
        return tooltip.type;
    }
};
var getPointerSelector = function (state) { return state.interactions.pointer; };
exports.isTooltipVisibleSelector = re_reselect_1.default([getTooltipType, getPointerSelector, get_projected_pointer_position_1.getProjectedPointerPositionSelector, get_tooltip_values_highlighted_geoms_1.getTooltipValuesSelector], isTooltipVisible)(get_chart_id_1.getChartIdSelector);
function isTooltipVisible(tooltipType, pointer, projectedPointerPosition, tooltipValues) {
    return (tooltipType !== interactions_1.TooltipType.None &&
        pointer.down === null &&
        projectedPointerPosition.x > -1 &&
        projectedPointerPosition.y > -1 &&
        tooltipValues.length > 0);
}
//# sourceMappingURL=is_tooltip_visible.js.map