"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
var axis_utils_1 = require("../utils/axis_utils");
var commons_1 = require("../../../utils/commons");
var domain_1 = require("../../../utils/domain");
var scales_1 = require("../../../utils/scales/scales");
var specs_1 = require("../utils/specs");
/**
 * Merge X domain value between a set of chart specification.
 * @param specs an array of [{ seriesType, xScaleType }]
 * @param xValues a set of unique x values from all specs
 * @param customXDomain if specified, a custom xDomain
 * @returns a merged XDomain between all series.
 */
function mergeXDomain(specs, xValues, customXDomain) {
    var mainXScaleType = convertXScaleTypes(specs);
    if (!mainXScaleType) {
        throw new Error('Cannot merge the domain. Missing X scale types');
    }
    var values = __spread(xValues.values());
    var seriesXComputedDomains;
    var minInterval = 0;
    if (mainXScaleType.scaleType === scales_1.ScaleType.Ordinal) {
        seriesXComputedDomains = domain_1.computeOrdinalDataDomain(values, commons_1.identity, false, true);
        if (customXDomain) {
            if (Array.isArray(customXDomain)) {
                seriesXComputedDomains = customXDomain;
            }
            else {
                throw new Error('xDomain for ordinal scale should be an array of values, not a DomainRange object');
            }
        }
    }
    else {
        seriesXComputedDomains = domain_1.computeContinuousDataDomain(values, commons_1.identity, true);
        var customMinInterval = void 0;
        if (!commons_1.isNumberArray(values)) {
            throw new Error("Each X value in a " + mainXScaleType.scaleType + " x scale needs be be a number. String or objects are not allowed");
        }
        if (customXDomain) {
            if (Array.isArray(customXDomain)) {
                throw new Error('xDomain for continuous scale should be a DomainRange object, not an array');
            }
            customMinInterval = customXDomain.minInterval;
            var _a = __read(seriesXComputedDomains, 2), computedDomainMin = _a[0], computedDomainMax = _a[1];
            if (axis_utils_1.isCompleteBound(customXDomain)) {
                if (customXDomain.min > customXDomain.max) {
                    throw new Error('custom xDomain is invalid, min is greater than max');
                }
                seriesXComputedDomains = [customXDomain.min, customXDomain.max];
            }
            else if (axis_utils_1.isLowerBound(customXDomain)) {
                if (customXDomain.min > computedDomainMax) {
                    throw new Error('custom xDomain is invalid, custom min is greater than computed max');
                }
                seriesXComputedDomains = [customXDomain.min, computedDomainMax];
            }
            else if (axis_utils_1.isUpperBound(customXDomain)) {
                if (computedDomainMin > customXDomain.max) {
                    throw new Error('custom xDomain is invalid, computed min is greater than custom max');
                }
                seriesXComputedDomains = [computedDomainMin, customXDomain.max];
            }
        }
        var computedMinInterval = findMinInterval(values);
        if (customMinInterval != null) {
            // Allow greater custom min iff xValues has 1 member.
            if (xValues.size > 1 && customMinInterval > computedMinInterval) {
                throw new Error('custom xDomain is invalid, custom minInterval is greater than computed minInterval');
            }
            if (customMinInterval < 0) {
                throw new Error('custom xDomain is invalid, custom minInterval is less than 0');
            }
        }
        minInterval = customMinInterval || computedMinInterval;
    }
    return {
        type: 'xDomain',
        scaleType: mainXScaleType.scaleType,
        isBandScale: mainXScaleType.isBandScale,
        domain: seriesXComputedDomains,
        minInterval: minInterval,
        timeZone: mainXScaleType.timeZone,
    };
}
exports.mergeXDomain = mergeXDomain;
/**
 * Find the minimum interval between xValues.
 * Default to 0 if an empty array, 1 if one item array
 */
function findMinInterval(xValues) {
    var valuesLength = xValues.length;
    if (valuesLength <= 0) {
        return 0;
    }
    if (valuesLength === 1) {
        return 1;
    }
    var sortedValues = xValues.slice().sort(commons_1.compareByValueAsc);
    var i;
    var minInterval = Math.abs(sortedValues[1] - sortedValues[0]);
    for (i = 1; i < valuesLength - 1; i++) {
        var current = sortedValues[i];
        var next = sortedValues[i + 1];
        var interval = Math.abs(next - current);
        minInterval = Math.min(minInterval, interval);
    }
    return minInterval;
}
exports.findMinInterval = findMinInterval;
/**
 * Convert the scale types of a set of specification to a generic one.
 * If there are at least one `ordinal` scale type, the resulting scale is coerched to ordinal.
 * If there are only `continuous` scale types, the resulting scale is coerched to linear.
 * If there are only `time` scales, we coerch the timeZone to `utc` only if we have multiple
 * different timezones.
 * @returns the coerched scale type, the timezone and a parameter that describe if its a bandScale or not
 */
function convertXScaleTypes(specs) {
    var seriesTypes = new Set();
    var scaleTypes = new Set();
    var timeZones = new Set();
    specs.forEach(function (spec) {
        seriesTypes.add(spec.seriesType);
        scaleTypes.add(spec.xScaleType);
        if (spec.timeZone) {
            timeZones.add(spec.timeZone.toLowerCase());
        }
    });
    if (specs.length === 0 || seriesTypes.size === 0 || scaleTypes.size === 0) {
        return null;
    }
    var isBandScale = seriesTypes.has(specs_1.SeriesTypes.Bar);
    if (scaleTypes.size === 1) {
        var scaleType = scaleTypes.values().next().value;
        var timeZone = void 0;
        if (scaleType === scales_1.ScaleType.Time) {
            if (timeZones.size > 1) {
                timeZone = 'utc';
            }
            else {
                timeZone = timeZones.values().next().value;
            }
        }
        return { scaleType: scaleType, isBandScale: isBandScale, timeZone: timeZone };
    }
    if (scaleTypes.size > 1 && scaleTypes.has(scales_1.ScaleType.Ordinal)) {
        return { scaleType: scales_1.ScaleType.Ordinal, isBandScale: isBandScale };
    }
    return { scaleType: scales_1.ScaleType.Linear, isBandScale: isBandScale };
}
exports.convertXScaleTypes = convertXScaleTypes;
//# sourceMappingURL=x_domain.js.map