"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
var specs_1 = require("../utils/specs");
var scales_1 = require("../../../utils/scales/scales");
var utils_1 = require("../state/utils");
var line_annotation_tooltip_1 = require("./line_annotation_tooltip");
var rect_annotation_tooltip_1 = require("./rect_annotation_tooltip");
function scaleAndValidateDatum(dataValue, scale, alignWithTick) {
    var isContinuous = scale.type !== scales_1.ScaleType.Ordinal;
    var scaledValue = scale.scale(dataValue);
    // d3.scale will return 0 for '', rendering the line incorrectly at 0
    if (isNaN(scaledValue) || (isContinuous && dataValue === '')) {
        return null;
    }
    if (isContinuous) {
        var _a = __read(scale.domain, 2), domainStart = _a[0], domainEnd = _a[1];
        // if we're not aligning the ticks, we need to extend the domain by one more tick for histograms
        var domainEndOffset = alignWithTick ? 0 : scale.minInterval;
        if (domainStart > dataValue || domainEnd + domainEndOffset < dataValue) {
            return null;
        }
    }
    return scaledValue;
}
exports.scaleAndValidateDatum = scaleAndValidateDatum;
function getAnnotationAxis(axesSpecs, groupId, domainType, chartRotation) {
    var _a = utils_1.getAxesSpecForSpecId(axesSpecs, groupId), xAxis = _a.xAxis, yAxis = _a.yAxis;
    var isHorizontalRotated = utils_1.isHorizontalRotation(chartRotation);
    var isXDomainAnnotation = isXDomain(domainType);
    var annotationAxis = isXDomainAnnotation ? xAxis : yAxis;
    var rotatedAnnotation = isHorizontalRotated ? annotationAxis : isXDomainAnnotation ? yAxis : xAxis;
    return rotatedAnnotation ? rotatedAnnotation.position : null;
}
exports.getAnnotationAxis = getAnnotationAxis;
function computeClusterOffset(totalBarsInCluster, barsShift, bandwidth) {
    if (totalBarsInCluster > 1) {
        return barsShift - bandwidth / 2;
    }
    return 0;
}
exports.computeClusterOffset = computeClusterOffset;
function isXDomain(domainType) {
    return domainType === specs_1.AnnotationDomainTypes.XDomain;
}
exports.isXDomain = isXDomain;
function getRotatedCursor(
/** the cursor position relative to the projection area */
cursorPosition, chartDimensions, chartRotation) {
    var x = cursorPosition.x, y = cursorPosition.y;
    var height = chartDimensions.height, width = chartDimensions.width;
    switch (chartRotation) {
        case 0:
            return { x: x, y: y };
        case 90:
            return { x: y, y: width - x };
        case -90:
            return { x: height - y, y: x };
        case 180:
            return { x: width - x, y: height - y };
    }
}
exports.getRotatedCursor = getRotatedCursor;
function computeAnnotationDimensions(annotations, chartDimensions, chartRotation, yScales, xScale, axesSpecs, totalBarsInCluster, enableHistogramMode) {
    var annotationDimensions = new Map();
    var barsShift = (totalBarsInCluster * xScale.bandwidth) / 2;
    var band = xScale.bandwidth / (1 - xScale.barsPadding);
    var halfPadding = (band - xScale.bandwidth) / 2;
    var barsPadding = halfPadding * totalBarsInCluster;
    var clusterOffset = computeClusterOffset(totalBarsInCluster, barsShift, xScale.bandwidth);
    // Annotations should always align with the axis line in histogram mode
    var xScaleOffset = utils_1.computeXScaleOffset(xScale, enableHistogramMode, specs_1.HistogramModeAlignments.Start);
    annotations.forEach(function (annotationSpec) {
        var id = annotationSpec.id;
        if (specs_1.isLineAnnotation(annotationSpec)) {
            var groupId = annotationSpec.groupId, domainType = annotationSpec.domainType;
            var annotationAxisPosition = getAnnotationAxis(axesSpecs, groupId, domainType, chartRotation);
            if (!annotationAxisPosition) {
                return;
            }
            var dimensions = line_annotation_tooltip_1.computeLineAnnotationDimensions(annotationSpec, chartDimensions, chartRotation, yScales, xScale, annotationAxisPosition, xScaleOffset - clusterOffset, enableHistogramMode);
            if (dimensions) {
                annotationDimensions.set(id, dimensions);
            }
        }
        else if (specs_1.isRectAnnotation(annotationSpec)) {
            var dimensions = rect_annotation_tooltip_1.computeRectAnnotationDimensions(annotationSpec, yScales, xScale, enableHistogramMode, barsPadding);
            if (dimensions) {
                annotationDimensions.set(id, dimensions);
            }
        }
    });
    return annotationDimensions;
}
exports.computeAnnotationDimensions = computeAnnotationDimensions;
function computeAnnotationTooltipState(cursorPosition, annotationDimensions, annotationSpecs, chartRotation, axesSpecs, chartDimensions) {
    var e_1, _a;
    try {
        for (var annotationDimensions_1 = __values(annotationDimensions), annotationDimensions_1_1 = annotationDimensions_1.next(); !annotationDimensions_1_1.done; annotationDimensions_1_1 = annotationDimensions_1.next()) {
            var _b = __read(annotationDimensions_1_1.value, 2), annotationId = _b[0], annotationDimension = _b[1];
            var spec = utils_1.getSpecsById(annotationSpecs, annotationId);
            if (!spec || spec.hideTooltips) {
                continue;
            }
            var groupId = spec.groupId;
            if (specs_1.isLineAnnotation(spec)) {
                if (spec.hideLines) {
                    continue;
                }
                var lineAnnotationTooltipState = line_annotation_tooltip_1.computeLineAnnotationTooltipState(cursorPosition, annotationDimension, groupId, spec.domainType, axesSpecs);
                if (lineAnnotationTooltipState.isVisible) {
                    return lineAnnotationTooltipState;
                }
            }
            else if (specs_1.isRectAnnotation(spec)) {
                var rectAnnotationTooltipState = rect_annotation_tooltip_1.computeRectAnnotationTooltipState(cursorPosition, annotationDimension, chartRotation, chartDimensions, spec.renderTooltip);
                if (rectAnnotationTooltipState.isVisible) {
                    return rectAnnotationTooltipState;
                }
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (annotationDimensions_1_1 && !annotationDimensions_1_1.done && (_a = annotationDimensions_1.return)) _a.call(annotationDimensions_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return null;
}
exports.computeAnnotationTooltipState = computeAnnotationTooltipState;
//# sourceMappingURL=annotation_utils.js.map