/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en.heuristics;

import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.languagetool.analysis.AnalyzedTokenReadings;
import org.languagetool.language.Language;
import org.languagetool.rules.Example;
import org.languagetool.rules.GenericUnpairedBracketsRule;
import org.languagetool.rules.SymbolLocator;
import org.languagetool.rules.UnsyncStack;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016JQ\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0014\u00a2\u0006\u0002\u0010\u0017\u00a8\u0006\u0019"}, d2={"Lorg/languagetool/rules/en/heuristics/EnglishUnpairedBracketsRule;", "Lorg/languagetool/rules/GenericUnpairedBracketsRule;", "messages", "Ljava/util/ResourceBundle;", "language", "Lorg/languagetool/language/Language;", "(Ljava/util/ResourceBundle;Lorg/languagetool/language/Language;)V", "getId", "", "isNoException", "", "tokenStr", "tokens", "", "Lorg/languagetool/analysis/AnalyzedTokenReadings;", "i", "", "j", "precSpace", "follSpace", "symbolStack", "Lorg/languagetool/rules/UnsyncStack;", "Lorg/languagetool/rules/SymbolLocator;", "(Ljava/lang/String;[Lorg/languagetool/analysis/AnalyzedTokenReadings;IIZZLorg/languagetool/rules/UnsyncStack;)Z", "Companion", "en"})
public final class EnglishUnpairedBracketsRule
extends GenericUnpairedBracketsRule {
    private static final List<String> EN_START_SYMBOLS;
    private static final List<String> EN_END_SYMBOLS;
    private static final Pattern NUMBER;
    private static final Pattern YEAR_NUMBER;
    private static final Pattern ALPHA;
    public static final Companion Companion;

    @NotNull
    public String getId() {
        return "EN_UNPAIRED_BRACKETS";
    }

    protected boolean isNoException(@NotNull String tokenStr, @NotNull AnalyzedTokenReadings[] tokens, int i, int j, boolean precSpace, boolean follSpace, @NotNull UnsyncStack<SymbolLocator> symbolStack) {
        Intrinsics.checkParameterIsNotNull((Object)tokenStr, (String)"tokenStr");
        Intrinsics.checkParameterIsNotNull((Object)tokens, (String)"tokens");
        Intrinsics.checkParameterIsNotNull(symbolStack, (String)"symbolStack");
        if (i <= 1) {
            return true;
        }
        if (i > 2 && Intrinsics.areEqual((Object)"'", (Object)tokens[i].getToken()) && Intrinsics.areEqual((Object)"-", (Object)tokens[i - 1].getToken()) && !tokens[i - 1].isWhitespaceBefore() && ALPHA.matcher(tokens[i - 2].getToken()).matches()) {
            return false;
        }
        if (!super.isNoException(tokenStr, tokens, i, j, precSpace, follSpace, symbolStack)) {
            return false;
        }
        if (!precSpace && follSpace || tokens[i].isSentenceEnd()) {
            AnalyzedTokenReadings prevToken = tokens[i - 1];
            if (Intrinsics.areEqual((Object)"\"", (Object)tokenStr)) {
                if (!symbolStack.empty()) {
                    Object object = symbolStack.peek();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"symbolStack.peek()");
                    if (Intrinsics.areEqual((Object)"\"", (Object)((SymbolLocator)object).getSymbol())) {
                        return true;
                    }
                }
                if (NUMBER.matcher(prevToken.getToken()).matches()) {
                    return false;
                }
            }
            if ((Intrinsics.areEqual((Object)"'", (Object)tokenStr) || Intrinsics.areEqual((Object)"\u2019", (Object)tokenStr)) && tokens[i].hasPosTag("POS")) {
                return false;
            }
            if (Intrinsics.areEqual((Object)"'", (Object)tokenStr) && prevToken.hasPosTag("VBG") && StringsKt.endsWith$default((String)prevToken.getToken(), (String)"in", (boolean)false, (int)2, null)) {
                return false;
            }
        }
        if (precSpace && !follSpace && Intrinsics.areEqual((Object)"'", (Object)tokenStr) && i + 1 < tokens.length) {
            return Intrinsics.areEqual((Object)"em", (Object)tokens[i + 1].getToken()) ? false : !YEAR_NUMBER.matcher(tokens[i + 1].getToken()).matches();
        }
        return true;
    }

    public EnglishUnpairedBracketsRule(@NotNull ResourceBundle messages, @NotNull Language language) {
        Intrinsics.checkParameterIsNotNull((Object)messages, (String)"messages");
        Intrinsics.checkParameterIsNotNull((Object)language, (String)"language");
        super(messages, language, EN_START_SYMBOLS, EN_END_SYMBOLS);
        this.addExamplePair(Example.wrong((String)"<marker>\"</marker>I'm over here, she said."), Example.fixed((String)"\"I'm over here,<marker>\"</marker> she said."));
    }

    static {
        Companion = new Companion(null);
        EN_START_SYMBOLS = CollectionsKt.listOf((Object[])new String[]{"[", "(", "{", "\u201c", "\"", "'"});
        EN_END_SYMBOLS = CollectionsKt.listOf((Object[])new String[]{"]", ")", "}", "\u201d", "\"", "'"});
        NUMBER = Pattern.compile("\\d+(?:-\\d+)?");
        YEAR_NUMBER = Pattern.compile("\\d\\ds?");
        ALPHA = Pattern.compile("\\p{L}+");
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/languagetool/rules/en/heuristics/EnglishUnpairedBracketsRule$Companion;", "", "()V", "ALPHA", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "EN_END_SYMBOLS", "", "", "EN_START_SYMBOLS", "NUMBER", "YEAR_NUMBER", "en"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

